/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import wardentools.misc.wind.WhisperManager;
import wardentools.network.PacketHandler;
import wardentools.network.ParticulesSoundsEffects.ParticleContagionImplosion;

public class WindWhispererBlock
extends Block {
    private static final VoxelShape SHAPE_BOTTOM = Block.box((double)4.5, (double)1.0, (double)4.5, (double)11.5, (double)2.0, (double)11.5);
    private static final VoxelShape SHAPE_MIDDLE_BOTTOM = Block.box((double)3.5, (double)2.0, (double)3.5, (double)12.5, (double)4.0, (double)12.5);
    private static final VoxelShape SHAPE_MIDDLE = Block.box((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape SHAPE_TOP = Block.box((double)3.5, (double)8.0, (double)3.5, (double)12.5, (double)9.0, (double)12.5);
    private static final VoxelShape SHAPE_TOP_BIG = Block.box((double)4.5, (double)9.0, (double)4.5, (double)8.5, (double)12.0, (double)8.5);
    private static final VoxelShape SHAPE_TOP_MIDDLE = Block.box((double)8.5, (double)9.0, (double)5.0, (double)10.5, (double)11.0, (double)7.0);
    private static final VoxelShape SHAPE_TOP_SMALL = Block.box((double)7.0, (double)9.0, (double)9.0, (double)11.0, (double)10.0, (double)12.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)SHAPE_BOTTOM, (VoxelShape[])new VoxelShape[]{SHAPE_MIDDLE_BOTTOM, SHAPE_MIDDLE, SHAPE_TOP, SHAPE_TOP_BIG, SHAPE_TOP_MIDDLE, SHAPE_TOP_SMALL});

    public WindWhispererBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    public void randomTick(@NotNull BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos blockPos, @NotNull RandomSource random) {
        if (WhisperManager.INSTANCE.sendRandomWhisperToAllPlayers(level)) {
            PacketHandler.sendToAllClient(new ParticleContagionImplosion(blockPos.getCenter()));
        }
    }
}

