/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import wardentools.blockentity.BlockEntityRegistry;

public class AbyssPortalBlockEntity
extends BlockEntity {
    private boolean shouldShowWinScreen = false;

    protected AbyssPortalBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("shouldShowWinScreen", this.shouldShowWinScreen);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.shouldShowWinScreen = tag.getBoolean("shouldShowWinScreen");
    }

    public boolean shouldShowWinScreen() {
        return this.shouldShowWinScreen;
    }

    public void setShouldShowWinScreen(boolean shouldShowWinScreen) {
        this.shouldShowWinScreen = shouldShowWinScreen;
        this.setChanged();
    }

    public AbyssPortalBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityRegistry.ABYSS_PORTAL_BLOCK_ENTITY.get(), pos, state);
    }

    public boolean shouldRenderFace(Direction direction) {
        if (this.level == null) {
            return false;
        }
        return Block.shouldRenderFace((BlockState)this.getBlockState(), (BlockGetter)this.level, (BlockPos)this.getBlockPos(), (Direction)direction, (BlockPos)this.getBlockPos().relative(direction));
    }
}

