/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlackLanternBlock;
import wardentools.blockentity.BlockEntityRegistry;
import wardentools.blockentity.util.TickableBlockEntity;

public class BlackLanternBlockEntity
extends BlockEntity
implements TickableBlockEntity {
    private int tickCountDown = 0;
    private int numberOfBlink = 0;

    protected BlackLanternBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BlackLanternBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityRegistry.BLACK_LANTERN_BLOCK_ENTITY.get(), pos, state);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.getBlockState().setValue((Property)BlackLanternBlock.LIT, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public void tick() {
        if (this.level == null) {
            return;
        }
        if (!this.level.isClientSide && this.numberOfBlink > 0) {
            if (this.tickCountDown == 0) {
                this.switchState(this.getBlockState(), (ServerLevel)this.level, this.getBlockPos());
                this.tickCountDown = this.level.getRandom().nextInt(1, 5);
                --this.numberOfBlink;
            } else {
                --this.tickCountDown;
            }
        }
    }

    public void switchState(@NotNull BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos blockPos) {
        if (!((Boolean)blockState.getValue((Property)BlackLanternBlock.LIT)).booleanValue()) {
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)BlackLanternBlock.LIT, (Comparable)Boolean.valueOf(true)));
        } else {
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)BlackLanternBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void setNumberOfBlink(int numberOfBlink) {
        this.numberOfBlink = numberOfBlink;
    }
}

