/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wardentools.block.AbyssPortalBlock;
import wardentools.block.BlockRegistry;
import wardentools.blockentity.AbyssPortalBlockEntity;
import wardentools.blockentity.BlockEntityRegistry;
import wardentools.blockentity.util.TickableBlockEntity;
import wardentools.entity.ModEntities;
import wardentools.entity.custom.ContagionIncarnationEntity;
import wardentools.gui.menu.DysfunctionningCatalystMenu;
import wardentools.misc.Crystal;
import wardentools.network.PacketHandler;
import wardentools.network.ParticulesSoundsEffects.AncientLaboratoryGateSound;
import wardentools.network.ParticulesSoundsEffects.ContagionIncarnationEmergeSound;
import wardentools.network.ParticulesSoundsEffects.ParticleContagionExplosion;
import wardentools.network.ParticulesSoundsEffects.ParticleDarktreeFenceDestroyed;
import wardentools.particle.ParticleRegistry;

public class DysfunctionningCatalystBlockEntity
extends BlockEntity
implements TickableBlockEntity,
MenuProvider {
    private static final float particleSpawnRadius = 2.0f;
    private final ItemStackHandler inventory = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            DysfunctionningCatalystBlockEntity.this.setChanged();
        }
    };
    private final LazyOptional<ItemStackHandler> inventoryOptional = LazyOptional.of(() -> this.inventory);
    private static final Component TITLE = Component.translatable((String)"container.wardentools.dysfunctionning_catalyst");
    private final ContainerData containerData = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> DysfunctionningCatalystBlockEntity.this.citrine;
                case 1 -> DysfunctionningCatalystBlockEntity.this.amethyst;
                case 2 -> DysfunctionningCatalystBlockEntity.this.pale;
                case 3 -> DysfunctionningCatalystBlockEntity.this.ruby;
                case 4 -> DysfunctionningCatalystBlockEntity.this.malachite;
                case 5 -> DysfunctionningCatalystBlockEntity.this.echo;
                case 6 -> DysfunctionningCatalystBlockEntity.this.total_charge;
                case 7 -> DysfunctionningCatalystBlockEntity.this.eye_progression;
                default -> throw new IllegalStateException("Unexpected value: " + index);
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    DysfunctionningCatalystBlockEntity.this.citrine = value;
                    break;
                }
                case 1: {
                    DysfunctionningCatalystBlockEntity.this.amethyst = value;
                    break;
                }
                case 2: {
                    DysfunctionningCatalystBlockEntity.this.pale = value;
                    break;
                }
                case 3: {
                    DysfunctionningCatalystBlockEntity.this.ruby = value;
                    break;
                }
                case 4: {
                    DysfunctionningCatalystBlockEntity.this.malachite = value;
                    break;
                }
                case 5: {
                    DysfunctionningCatalystBlockEntity.this.echo = value;
                    break;
                }
                case 6: {
                    DysfunctionningCatalystBlockEntity.this.total_charge = value;
                    break;
                }
                case 7: {
                    DysfunctionningCatalystBlockEntity.this.eye_progression = value;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + index);
                }
            }
        }

        public int getCount() {
            return 8;
        }
    };
    public static final int MAX_PROGRESSION = 28;
    public static final int MAX_TOTAL = 72;
    public static final int MAX_EYE = 40;
    private static final int UPDATE_INTERVAL = 5;
    private int citrine = 0;
    private int amethyst = 0;
    private int pale = 0;
    private int ruby = 0;
    private int malachite = 0;
    private int echo = 0;
    private int total_charge = 0;
    private int eye_progression = 0;
    private int next_check = 0;
    private static final int FENCE_INTERVAL = 35;
    private static final int MAX_FENCE = 5;
    private int schedule_fence = 0;
    private int fence_level = 0;
    private static final int SUMMON_DELAY = 200;
    private int schedule_summon = 0;
    private boolean isContagionDefeated = false;

    protected DysfunctionningCatalystBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public DysfunctionningCatalystBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityRegistry.DYSFUNCTIONNING_CATALYST_BLOCK_ENTITY.get(), pos, state);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        CompoundTag wardentoolsData = tag.getCompound("wardentools");
        if (wardentoolsData.isEmpty()) {
            return;
        }
        if (wardentoolsData.contains("Inventory", 10)) {
            this.inventory.deserializeNBT(provider, wardentoolsData.getCompound("Inventory"));
        }
        this.citrine = wardentoolsData.getInt("Citrine");
        this.amethyst = wardentoolsData.getInt("Amethyst");
        this.pale = wardentoolsData.getInt("PaleShard");
        this.ruby = wardentoolsData.getInt("Ruby");
        this.malachite = wardentoolsData.getInt("Malachite");
        this.echo = wardentoolsData.getInt("EchoShard");
        this.total_charge = wardentoolsData.getInt("TotalCharge");
        this.isContagionDefeated = wardentoolsData.getBoolean("IsContagionDefeated");
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        CompoundTag wardentoolsData = new CompoundTag();
        wardentoolsData.put("Inventory", (Tag)this.inventory.serializeNBT(provider));
        wardentoolsData.putInt("Citrine", this.citrine);
        wardentoolsData.putInt("Amethyst", this.amethyst);
        wardentoolsData.putInt("PaleShard", this.pale);
        wardentoolsData.putInt("Ruby", this.ruby);
        wardentoolsData.putInt("Malachite", this.malachite);
        wardentoolsData.putInt("EchoShard", this.echo);
        wardentoolsData.putInt("TotalCharge", this.total_charge);
        wardentoolsData.putBoolean("IsContagionDefeated", this.isContagionDefeated);
        tag.put("wardentools", (Tag)wardentoolsData);
    }

    @Override
    public void tick() {
        if (this.level != null && !this.level.isClientSide) {
            this.sendUpdate();
            if (this.next_check <= 0 && this.total_charge != 72) {
                this.next_check = 5;
                if (this.inventory.getStackInSlot(0).is(Crystal.AMETHYST.getJewel()) && this.amethyst < 28) {
                    ++this.amethyst;
                    this.sendUpdate();
                } else if (this.amethyst > 0 && !this.inventory.getStackInSlot(0).is(Crystal.AMETHYST.getJewel())) {
                    --this.amethyst;
                    this.sendUpdate();
                }
                if (this.inventory.getStackInSlot(1).is(Crystal.CITRINE.getJewel()) && this.citrine < 28) {
                    ++this.citrine;
                    this.sendUpdate();
                } else if (this.citrine > 0 && !this.inventory.getStackInSlot(1).is(Crystal.CITRINE.getJewel())) {
                    --this.citrine;
                    this.sendUpdate();
                }
                if (this.inventory.getStackInSlot(2).is(Crystal.ECHO.getJewel()) && this.echo < 28) {
                    ++this.echo;
                    this.sendUpdate();
                } else if (this.echo > 0 && !this.inventory.getStackInSlot(2).is(Crystal.ECHO.getJewel())) {
                    --this.echo;
                    this.sendUpdate();
                }
                if (this.inventory.getStackInSlot(3).is(Crystal.RUBY.getJewel()) && this.ruby < 28) {
                    ++this.ruby;
                    this.sendUpdate();
                } else if (this.ruby > 0 && !this.inventory.getStackInSlot(3).is(Crystal.RUBY.getJewel())) {
                    --this.ruby;
                    this.sendUpdate();
                }
                if (this.inventory.getStackInSlot(4).is(Crystal.MALACHITE.getJewel()) && this.malachite < 28) {
                    ++this.malachite;
                    this.sendUpdate();
                } else if (this.malachite > 0 && !this.inventory.getStackInSlot(4).is(Crystal.MALACHITE.getJewel())) {
                    --this.malachite;
                    this.sendUpdate();
                }
                if (this.inventory.getStackInSlot(5).is(Crystal.PALE.getJewel()) && this.pale < 28) {
                    ++this.pale;
                    this.sendUpdate();
                } else if (this.pale > 0 && !this.inventory.getStackInSlot(5).is(Crystal.PALE.getJewel())) {
                    --this.pale;
                    this.sendUpdate();
                }
            } else {
                --this.next_check;
            }
            if (this.crystalsFullyCharged() && this.total_charge < 72) {
                ++this.total_charge;
                if (this.readyToSummon() && this.isInCorrectSpot()) {
                    this.doSummoning();
                }
            } else if (this.total_charge > 0 && !this.crystalsFullyCharged() && this.total_charge < 72) {
                --this.total_charge;
            }
            if (this.total_charge == 72 && this.eye_progression < 40) {
                ++this.eye_progression;
            } else if (this.eye_progression > 0 && this.total_charge < 72) {
                --this.eye_progression;
            }
            if (this.isInCorrectSpot()) {
                if (this.schedule_fence > 0 && this.fence_level < 5) {
                    --this.schedule_fence;
                    if (this.schedule_fence == 0) {
                        this.placeFence();
                        ++this.fence_level;
                        if (this.fence_level < 5) {
                            this.schedule_fence = 35;
                        }
                    }
                }
                if (this.schedule_summon > 0) {
                    --this.schedule_summon;
                    if (this.schedule_summon == 0) {
                        this.summonContagionIncarnation();
                    }
                }
            }
        }
    }

    private void summonContagionIncarnation() {
        if (this.level == null) {
            return;
        }
        this.placeSolidCorruptionBlock();
        ContagionIncarnationEntity contagionIncarnation = new ContagionIncarnationEntity((EntityType<? extends Monster>)((EntityType)ModEntities.CONTAGION_INCARNATION.get()), this.level);
        contagionIncarnation.setPos(this.worldPosition.below(12).getCenter().add(0.0, 0.5, 0.0));
        contagionIncarnation.setHealth(contagionIncarnation.getMaxHealth());
        contagionIncarnation.initiateSpawnAnimation();
        contagionIncarnation.setCatalystPos(this.worldPosition);
        this.level.addFreshEntity((Entity)contagionIncarnation);
        PacketHandler.sendToAllClient(new ContagionIncarnationEmergeSound());
    }

    public void clientTick() {
        this.handleParticleEffects();
    }

    private void placeFence() {
        List<BlockPos> fencePos;
        if (this.level != null && (fencePos = this.getFencePosByLevel(this.fence_level)) != null) {
            for (BlockPos pos : this.getFenceSoundPos()) {
                this.sendGateClosingSoundEffectToClient(pos.getCenter());
            }
            for (BlockPos pos : fencePos) {
                this.level.setBlockAndUpdate(pos, ((Block)BlockRegistry.DARKTREE_FENCE.get()).defaultBlockState());
            }
        }
    }

    private void removeFences() {
        if (this.level != null) {
            for (int level = 0; level <= 5; ++level) {
                List<BlockPos> fencePos = this.getFencePosByLevel(level);
                if (fencePos == null) continue;
                for (BlockPos pos : fencePos) {
                    if (this.level.getBlockState(pos).getBlock() != BlockRegistry.DARKTREE_FENCE.get()) continue;
                    this.level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    PacketHandler.sendToAllClient(new ParticleDarktreeFenceDestroyed(pos.getCenter()));
                }
            }
        }
    }

    public void contagionDied() {
        this.isContagionDefeated = true;
        this.removeFences();
        this.placeAbyssPortalBlock();
    }

    public boolean isContagionDefeated() {
        return this.isContagionDefeated;
    }

    private void sendGateClosingSoundEffectToClient(Vec3 source) {
        PacketHandler.sendToAllClient(new AncientLaboratoryGateSound(source));
    }

    private void handleParticleEffects() {
        if (this.isContagionDefeated) {
            return;
        }
        if (this.level == null) {
            return;
        }
        if (this.level.getGameTime() % 5L == (long)this.level.getRandom().nextInt(5)) {
            Vec3 center = this.getBlockPos().getCenter();
            float x = (this.level.getRandom().nextFloat() * 2.0f - 1.0f) * 2.0f;
            float y = (this.level.getRandom().nextFloat() * 2.0f - 1.0f) * 2.0f;
            float z = (this.level.getRandom().nextFloat() * 2.0f - 1.0f) * 2.0f;
            float norm = Mth.sqrt((float)(x * x + y * y + z * z)) / 0.2f;
            this.level.addParticle((ParticleOptions)ParticleRegistry.CORRUPTION.get(), (double)((float)center.x + x), (double)((float)center.y + y), (double)((float)center.z + z), (double)(-x / norm), (double)(-y / norm), (double)(-z / norm));
        }
        if (this.isChargingCrystals()) {
            this.particleLevitation(10, 0.2f, 5.0f, -13.0f, 5.0f);
        }
        if (this.isChargingTotal()) {
            this.particleImplosion(10, 0.4f, 20.0f);
        }
        if (this.isFightActive()) {
            this.particleLevitation(100, 0.05f, 19.0f, -13.0f, 5.0f);
        }
    }

    private void particleImplosion(int particleNumber, float speedMultiplier, float radius) {
        if (this.level == null || !this.level.isClientSide) {
            return;
        }
        Vec3 source = this.worldPosition.getCenter();
        for (int i = 0; i < particleNumber; ++i) {
            double offsetX = (this.level.random.nextDouble() - 0.5) * (double)radius;
            double offsetY = (this.level.random.nextDouble() - 0.5) * (double)radius;
            double offsetZ = (this.level.random.nextDouble() - 0.5) * (double)radius;
            double norm = Math.sqrt(offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ);
            double speed = (double)speedMultiplier / norm;
            this.level.addParticle((ParticleOptions)ParticleRegistry.CORRUPTION.get(), source.x + offsetX, source.y + offsetY, source.z + offsetZ, -offsetX * speed, -offsetY * speed, -offsetZ * speed);
        }
    }

    private void particleLevitation(int particleNumber, float speedMultiplier, float radius, float yMinParticleSpawn, float yMaxParticleSpawn) {
        if (this.level == null || !this.level.isClientSide) {
            return;
        }
        Vec3 source = this.worldPosition.getCenter();
        for (int i = 0; i < particleNumber; ++i) {
            float x = (this.level.random.nextFloat() * 2.0f - 1.0f) * radius;
            float y = this.level.random.nextFloat() * (yMaxParticleSpawn - yMinParticleSpawn) + yMinParticleSpawn;
            float z = (this.level.random.nextFloat() * 2.0f - 1.0f) * radius;
            this.level.addParticle((ParticleOptions)ParticleRegistry.CORRUPTION.get(), source.x + (double)x, source.y + (double)y, source.z + (double)z, 0.0, (double)speedMultiplier, 0.0);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return this.inventoryOptional.cast();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryOptional.invalidate();
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new DysfunctionningCatalystMenu(containerId, playerInventory, this, this.containerData);
    }

    private void sendUpdate() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean crystalsFullyCharged() {
        return this.citrine == 28 && this.amethyst == 28 && this.pale == 28 && this.ruby == 28 && this.malachite == 28 && this.echo == 28;
    }

    public boolean isChargingCrystals() {
        return this.inventory.getStackInSlot(0).is(Crystal.AMETHYST.getJewel()) && this.citrine < 28 || this.inventory.getStackInSlot(1).is(Crystal.CITRINE.getJewel()) && this.amethyst < 28 || this.inventory.getStackInSlot(2).is(Crystal.ECHO.getJewel()) && this.pale < 28 || this.inventory.getStackInSlot(3).is(Crystal.RUBY.getJewel()) && this.ruby < 28 || this.inventory.getStackInSlot(4).is(Crystal.MALACHITE.getJewel()) && this.malachite < 28 || this.inventory.getStackInSlot(5).is(Crystal.PALE.getJewel()) && this.echo < 28;
    }

    public boolean isChargingTotal() {
        return this.total_charge < 72 && this.crystalsFullyCharged();
    }

    public boolean readyToSummon() {
        return this.total_charge == 72;
    }

    public boolean isFightActive() {
        return this.total_charge == 72;
    }

    public boolean isInCorrectSpot() {
        if (this.level == null) {
            return false;
        }
        for (BlockPos pos : this.getFountainBelowPositions()) {
            if (this.level.getBlockState(pos.below(2)).getBlock().equals(Blocks.BEDROCK)) continue;
            return false;
        }
        return true;
    }

    public void doSummoning() {
        this.hugeParticleExplosion();
        this.schedule_fence = 35;
        this.schedule_summon = 200;
        this.removeInventory();
    }

    private void removeInventory() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.getStackInSlot(i).shrink(1);
        }
    }

    public void placeSolidCorruptionBlock() {
        if (this.level != null) {
            for (BlockPos pos : this.getFountainBelowPositions()) {
                this.level.setBlockAndUpdate(pos, ((Block)BlockRegistry.SOLID_CORRUPTION.get()).defaultBlockState());
            }
        }
    }

    public void placeAbyssPortalBlock() {
        if (this.level != null) {
            for (BlockPos pos : this.getFountainBelowPositions()) {
                this.level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                this.level.setBlockAndUpdate(pos.below(), ((AbyssPortalBlock)((Object)BlockRegistry.ABYSS_PORTAL_BLOCK.get())).defaultBlockState());
                BlockEntity blockEntity = this.level.getBlockEntity(pos.below());
                if (!(blockEntity instanceof AbyssPortalBlockEntity)) continue;
                AbyssPortalBlockEntity abyssPortalBlockEntity = (AbyssPortalBlockEntity)blockEntity;
                abyssPortalBlockEntity.setShouldShowWinScreen(true);
            }
        }
    }

    public void hugeParticleExplosion() {
        PacketHandler.sendToAllClient(new ParticleContagionExplosion(this.worldPosition.getCenter(), 1.0f, 2.0f, 800));
    }

    public List<BlockPos> getFenceSoundPos() {
        return List.of(this.worldPosition.offset(19, -9, 0), this.worldPosition.offset(0, -9, 19), this.worldPosition.offset(-19, -9, 0), this.worldPosition.offset(0, -9, -19));
    }

    @Nullable
    public List<BlockPos> getFencePosByLevel(int level) {
        if (level == 0) {
            return List.of(this.worldPosition.offset(19, -8, 0), this.worldPosition.offset(19, -8, 1), this.worldPosition.offset(19, -8, -1), this.worldPosition.offset(0, -8, 19), this.worldPosition.offset(1, -8, 19), this.worldPosition.offset(-1, -8, 19), this.worldPosition.offset(-19, -8, 0), this.worldPosition.offset(-19, -8, 1), this.worldPosition.offset(-19, -8, -1), this.worldPosition.offset(0, -8, -19), this.worldPosition.offset(1, -8, -19), this.worldPosition.offset(-1, -8, -19));
        }
        if (level >= 1 && level <= 5) {
            return List.of(this.worldPosition.offset(19, -8 - level, 0), this.worldPosition.offset(19, -8 - level, 1), this.worldPosition.offset(19, -8 - level, -1), this.worldPosition.offset(0, -8 - level, 19), this.worldPosition.offset(1, -8 - level, 19), this.worldPosition.offset(-1, -8 - level, 19), this.worldPosition.offset(-19, -8 - level, 0), this.worldPosition.offset(-19, -8 - level, 1), this.worldPosition.offset(-19, -8 - level, -1), this.worldPosition.offset(0, -8 - level, -19), this.worldPosition.offset(1, -8 - level, -19), this.worldPosition.offset(-1, -8 - level, -19), this.worldPosition.offset(19, -8 - level, 2), this.worldPosition.offset(19, -8 - level, -2), this.worldPosition.offset(2, -8 - level, 19), this.worldPosition.offset(-2, -8 - level, 19), this.worldPosition.offset(-19, -8 - level, 2), this.worldPosition.offset(-19, -8 - level, -2), this.worldPosition.offset(2, -8 - level, -19), this.worldPosition.offset(-2, -8 - level, -19));
        }
        return null;
    }

    public List<BlockPos> getFountainBelowPositions() {
        return List.of(this.worldPosition.offset(0, -12, 0), this.worldPosition.offset(1, -12, 0), this.worldPosition.offset(0, -12, 1), this.worldPosition.offset(1, -12, 1), this.worldPosition.offset(2, -12, 0), this.worldPosition.offset(2, -12, 1), this.worldPosition.offset(2, -12, 2), this.worldPosition.offset(1, -12, 2), this.worldPosition.offset(0, -12, 2), this.worldPosition.offset(3, -12, 0), this.worldPosition.offset(3, -12, 1), this.worldPosition.offset(3, -12, 2), this.worldPosition.offset(3, -12, 3), this.worldPosition.offset(2, -12, 3), this.worldPosition.offset(1, -12, 3), this.worldPosition.offset(0, -12, 3), this.worldPosition.offset(4, -12, 0), this.worldPosition.offset(4, -12, 1), this.worldPosition.offset(4, -12, 2), this.worldPosition.offset(1, -12, 0), this.worldPosition.offset(0, -12, 1), this.worldPosition.offset(1, -12, 1), this.worldPosition.offset(2, -12, 0), this.worldPosition.offset(2, -12, 1), this.worldPosition.offset(2, -12, 2), this.worldPosition.offset(1, -12, 2), this.worldPosition.offset(3, -12, 0), this.worldPosition.offset(3, -12, 1), this.worldPosition.offset(3, -12, 2), this.worldPosition.offset(3, -12, 3), this.worldPosition.offset(2, -12, 3), this.worldPosition.offset(1, -12, 3), this.worldPosition.offset(0, -12, 3), this.worldPosition.offset(4, -12, 0), this.worldPosition.offset(4, -12, 1), this.worldPosition.offset(4, -12, 2), this.worldPosition.offset(2, -12, 4), this.worldPosition.offset(1, -12, 4), this.worldPosition.offset(0, -12, 4), this.worldPosition.offset(-1, -12, 0), this.worldPosition.offset(0, -12, -1), this.worldPosition.offset(-1, -12, -1), this.worldPosition.offset(-2, -12, 0), this.worldPosition.offset(-2, -12, -1), this.worldPosition.offset(-2, -12, -2), this.worldPosition.offset(-1, -12, -2), this.worldPosition.offset(0, -12, -2), this.worldPosition.offset(-3, -12, 0), this.worldPosition.offset(-3, -12, -1), this.worldPosition.offset(-3, -12, -2), this.worldPosition.offset(-3, -12, -3), this.worldPosition.offset(-2, -12, -3), this.worldPosition.offset(-1, -12, -3), this.worldPosition.offset(0, -12, -3), this.worldPosition.offset(-4, -12, 0), this.worldPosition.offset(-4, -12, -1), this.worldPosition.offset(-4, -12, -2), this.worldPosition.offset(-2, -12, -4), this.worldPosition.offset(-1, -12, -4), this.worldPosition.offset(0, -12, -4), this.worldPosition.offset(-1, -12, 1), this.worldPosition.offset(-2, -12, 1), this.worldPosition.offset(-2, -12, 2), this.worldPosition.offset(-1, -12, 2), this.worldPosition.offset(-3, -12, 1), this.worldPosition.offset(-3, -12, 2), this.worldPosition.offset(-3, -12, 3), this.worldPosition.offset(-2, -12, 3), this.worldPosition.offset(-1, -12, 3), this.worldPosition.offset(-4, -12, 1), this.worldPosition.offset(-4, -12, 2), this.worldPosition.offset(-2, -12, 4), this.worldPosition.offset(-1, -12, 4), this.worldPosition.offset(1, -12, -1), this.worldPosition.offset(2, -12, -1), this.worldPosition.offset(2, -12, -2), this.worldPosition.offset(1, -12, -2), this.worldPosition.offset(3, -12, -1), this.worldPosition.offset(3, -12, -2), this.worldPosition.offset(3, -12, -3), this.worldPosition.offset(2, -12, -3), this.worldPosition.offset(1, -12, -3), this.worldPosition.offset(4, -12, -1), this.worldPosition.offset(4, -12, -2), this.worldPosition.offset(2, -12, -4), this.worldPosition.offset(1, -12, -4));
    }

    @NotNull
    public Component getDisplayName() {
        return TITLE;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public LazyOptional<ItemStackHandler> getInventoryOptional() {
        return this.inventoryOptional;
    }
}

