/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import wardentools.block.GolemStoneBlock;
import wardentools.blockentity.BlockEntityRegistry;

public class GolemStoneBlockEntity
extends BlockEntity {
    private int delayBeforeCheck = 40;

    public GolemStoneBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.GOLEM_STONE_BLOCK_ENTITY.get(), pos, state);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
    }

    public void tick() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (!this.level.getBlockState(this.getBlockPos()).hasProperty((Property)GolemStoneBlock.HAS_SPAWNED_GOLEM)) {
            return;
        }
        if (((Boolean)this.getBlockState().getValue((Property)GolemStoneBlock.HAS_SPAWNED_GOLEM)).booleanValue()) {
            return;
        }
        if (this.delayBeforeCheck > 0) {
            --this.delayBeforeCheck;
            if (this.delayBeforeCheck == 0) {
                GolemStoneBlock.placeGolem(this.level, this.worldPosition, this.getBlockState());
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)GolemStoneBlock.HAS_SPAWNED_GOLEM, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }
}

