/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import wardentools.block.LivingSproutBlock;
import wardentools.blockentity.BlockEntityRegistry;
import wardentools.sounds.ModSounds;

public class LivingSproutBlockEntity
extends BlockEntity
implements GameEventListener.Provider<VibrationSystem.Listener>,
VibrationSystem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int COOLDOWN = 216;
    private VibrationSystem.Data vibrationData;
    private final VibrationSystem.Listener vibrationListener;
    private final VibrationSystem.User vibrationUser = this.createVibrationUser();
    private boolean isPulsing = false;
    private int lastTimeHeard = 0;

    public LivingSproutBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.vibrationData = new VibrationSystem.Data();
        this.vibrationListener = new VibrationSystem.Listener((VibrationSystem)this);
    }

    public LivingSproutBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityRegistry.LIVING_SPROUT_BLOCK_ENTITY.get(), pos, state);
    }

    public VibrationSystem.User createVibrationUser() {
        return new VibrationUser(this.getBlockPos());
    }

    @NotNull
    public VibrationSystem.Listener getListener() {
        return this.vibrationListener;
    }

    @NotNull
    public VibrationSystem.Data getVibrationData() {
        return this.vibrationData;
    }

    @NotNull
    public VibrationSystem.User getVibrationUser() {
        return this.vibrationUser;
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        RegistryOps context = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (tag.contains("listener", 10)) {
            VibrationSystem.Data.CODEC.parse((DynamicOps)context, (Object)tag.getCompound("listener")).resultOrPartial(error -> LOGGER.error("Failed to parse vibration listener for Living Sprout: '{}'", error)).ifPresent(data -> {
                this.vibrationData = data;
            });
        }
        if (tag.contains("lastTimeHeard", 3)) {
            this.lastTimeHeard = tag.getInt("lastTimeHeard");
        }
        if (tag.contains("isPulsing", 1)) {
            this.isPulsing = tag.getBoolean("isPulsing");
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        RegistryOps context = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        VibrationSystem.Data.CODEC.encodeStart((DynamicOps)context, (Object)this.vibrationData).resultOrPartial(error -> LOGGER.error("Failed to encode vibration listener for Living Sprout: '{}'", error)).ifPresent(tag1 -> tag.put("listener", tag1));
        tag.putInt("lastTimeHeard", this.lastTimeHeard);
        tag.putBoolean("isPulsing", this.isPulsing);
    }

    public void tick() {
        VibrationSystem.Ticker.tick((Level)this.level, (VibrationSystem.Data)this.getVibrationData(), (VibrationSystem.User)this.getVibrationUser());
        if (this.level == null) {
            return;
        }
        if (this.level.getGameTime() - (long)this.lastTimeHeard >= 216L && this.isPulsing) {
            this.calmDown();
        }
    }

    public boolean isPulsing() {
        return this.isPulsing;
    }

    public int getLastTimeHeard() {
        return this.lastTimeHeard;
    }

    public void trigger(int timeTick) {
        if (this.level == null) {
            return;
        }
        if (timeTick - this.lastTimeHeard < 216) {
            if (this.isPulsing) {
                this.level.destroyBlock(this.getBlockPos(), true);
                return;
            }
        } else {
            this.isPulsing = true;
        }
        this.lastTimeHeard = timeTick;
        this.update();
    }

    public void calmDown() {
        this.isPulsing = false;
        this.update();
    }

    public void update() {
        if (this.level == null) {
            return;
        }
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        if (!this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
        this.setChanged();
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected class VibrationUser
    implements VibrationSystem.User {
        protected final BlockPos blockPos;
        private final PositionSource positionSource;

        public VibrationUser(BlockPos pos) {
            this.blockPos = pos;
            this.positionSource = new BlockPositionSource(pos);
        }

        public int getListenerRadius() {
            return 8;
        }

        @NotNull
        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        public boolean canTriggerAvoidVibration() {
            return true;
        }

        public boolean canReceiveVibration(@NotNull ServerLevel level, BlockPos pos, @NotNull Holder<GameEvent> gameEventHolder, @Nullable GameEvent.Context context) {
            Player player;
            Entity entity;
            return (!pos.equals((Object)this.blockPos) || !gameEventHolder.is((Holder)GameEvent.BLOCK_DESTROY) && !gameEventHolder.is((Holder)GameEvent.BLOCK_PLACE)) && LivingSproutBlock.canActivate(LivingSproutBlockEntity.this.getBlockState()) && context != null && (entity = context.sourceEntity()) instanceof Player && !(player = (Player)entity).isCreative();
        }

        public void onReceiveVibration(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull Holder<GameEvent> gameEventHolder, @Nullable Entity entity, @Nullable Entity entity1, float v) {
            BlockState state = LivingSproutBlockEntity.this.getBlockState();
            if (LivingSproutBlock.canActivate(state)) {
                if (!LivingSproutBlockEntity.this.isPulsing() && ModSounds.HEART_BEAT.getHolder().isPresent()) {
                    BlockPos blockPos = LivingSproutBlockEntity.this.getBlockPos();
                    level.playSeededSound(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (Holder)ModSounds.HEART_BEAT.getHolder().get(), SoundSource.BLOCKS, 5.0f, 1.0f, 1L);
                }
                LivingSproutBlock.activate((Level)level, LivingSproutBlockEntity.this.getBlockPos());
            }
            LivingSproutBlockEntity.this.trigger((int)level.getGameTime());
        }

        public void onDataChanged() {
            LivingSproutBlockEntity.this.setChanged();
        }

        public boolean requiresAdjacentChunksToBeTicking() {
            return true;
        }
    }
}

