/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wardentools.advancement.ModCriteriaTriggers;
import wardentools.blockentity.BlockEntityRegistry;
import wardentools.blockentity.util.TickableBlockEntity;
import wardentools.entity.ModEntities;
import wardentools.entity.custom.ProtectorEntity;
import wardentools.items.ItemRegistry;
import wardentools.items.ProtectorHeartItem;
import wardentools.network.PacketHandler;
import wardentools.network.ParticulesSoundsEffects.ParticleRadianceExplosion;

public class ProtectorInvokerBlockEntity
extends BlockEntity
implements TickableBlockEntity {
    public boolean protectorSuccessfullyInvoked = false;
    public static final int radiusForProtectorSpawn = 5;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ProtectorInvokerBlockEntity.this.setChanged();
            if (ProtectorInvokerBlockEntity.this.level == null) {
                return;
            }
            if (!((ProtectorInvokerBlockEntity)ProtectorInvokerBlockEntity.this).level.isClientSide) {
                ProtectorInvokerBlockEntity.this.level.sendBlockUpdated(ProtectorInvokerBlockEntity.this.getBlockPos(), ProtectorInvokerBlockEntity.this.getBlockState(), ProtectorInvokerBlockEntity.this.getBlockState(), 2);
            }
        }
    };
    private final LazyOptional<ItemStackHandler> inventoryOptional = LazyOptional.of(() -> this.inventory);

    public ProtectorInvokerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.PROTECTOR_INVOKER_BLOCK_ENTITY.get(), pos, state);
    }

    public InteractionResult playerInteract(Player player, BlockPos pos, InteractionHand interactionHand) {
        ItemStack heldItem = player.getItemInHand(interactionHand);
        if (this.level == null) {
            return InteractionResult.FAIL;
        }
        if (heldItem.is((Item)ItemRegistry.PROTECTOR_HEART.get()) && this.getInventory().getStackInSlot(0).isEmpty()) {
            this.getInventory().setStackInSlot(0, heldItem.copy());
            heldItem.shrink(1);
            if (ProtectorInvokerBlockEntity.protectorWithThisInvokerExists(this.level, this)) {
                return InteractionResult.CONSUME;
            }
            ProtectorInvokerBlockEntity.trySpawnNewProtector(this.level, pos, this);
            if (!this.level.isClientSide) {
                ModCriteriaTriggers.SUMMON_PROTECTOR.trigger((ServerPlayer)player);
            }
            return InteractionResult.CONSUME;
        }
        if (heldItem.isEmpty() && !this.getInventory().getStackInSlot(0).isEmpty()) {
            player.setItemInHand(interactionHand, this.getInventory().getStackInSlot(0).copy());
            this.getInventory().getStackInSlot(0).shrink(1);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private static void trySpawnNewProtector(Level level, BlockPos pos, ProtectorInvokerBlockEntity invoker) {
        ProtectorEntity protec;
        if (level.isClientSide()) {
            return;
        }
        BlockPos spawnPos = ProtectorInvokerBlockEntity.findSpawnPosition(level, pos);
        if (spawnPos != null && (protec = (ProtectorEntity)((EntityType)ModEntities.PROTECTOR.get()).create(level)) != null) {
            protec.moveTo((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5, level.random.nextFloat() * 360.0f, 0.0f);
            protec.setHealth(Objects.requireNonNull(invoker.heartItem()).readHealth(invoker.heartStack()));
            protec.setInvokerPos(pos);
            if (invoker.heartItem() != null) {
                Objects.requireNonNull(invoker.heartItem()).setProtector(invoker.heartStack(), protec);
            }
            protec.makeSpawnAnimation();
            Vec3 particleSource = spawnPos.above().getCenter();
            PacketHandler.sendToAllClient(new ParticleRadianceExplosion(particleSource));
            level.addFreshEntity((Entity)protec);
            invoker.protectorSuccessfullyInvoked = true;
        }
    }

    public static boolean protectorWithThisInvokerExists(Level level, ProtectorInvokerBlockEntity invoker) {
        AABB searchBox = new AABB(invoker.getBlockPos()).inflate(100.0);
        return level.getEntitiesOfClass(ProtectorEntity.class, searchBox).stream().anyMatch(protector -> ProtectorInvokerBlockEntity.compareBlockPos(invoker.getBlockPos(), protector));
    }

    private static boolean compareBlockPos(BlockPos pos1, ProtectorEntity protector) {
        if (protector.invokerPos == null) {
            return false;
        }
        BlockPos pos2 = protector.invokerPos;
        return pos1.getX() == pos2.getX() && pos1.getY() == pos2.getY() && pos1.getZ() == pos2.getZ();
    }

    private static BlockPos findSpawnPosition(Level level, BlockPos invokerPos) {
        for (int r = 1; r <= 5; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    for (int dy = -2; dy <= 2; ++dy) {
                        BlockPos pos;
                        if (Math.abs(dx) != r && Math.abs(dz) != r || !ProtectorInvokerBlockEntity.isSpaceAvailable(level, pos = invokerPos.offset(dx, dy, dz))) continue;
                        return pos;
                    }
                }
            }
        }
        return null;
    }

    private static boolean isSpaceAvailable(Level level, BlockPos pos) {
        int x;
        for (x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos checkPos = pos.offset(x, -1, z);
                if (level.getBlockState(checkPos).isSolid()) continue;
                return false;
            }
        }
        for (x = -1; x <= 1; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos checkPos = pos.offset(x, y, z);
                    if (level.getBlockState(checkPos).isAir()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void saveHealth(ProtectorEntity protector) {
        this.saveHealth(protector.getHealth());
    }

    public void saveHealth(float health) {
        this.sendUpdate();
        if (!this.inventory.getStackInSlot(0).isEmpty() && this.inventory.getStackInSlot(0).is((Item)ItemRegistry.PROTECTOR_HEART.get())) {
            ((ProtectorHeartItem)this.inventory.getStackInSlot(0).getItem()).saveHealth(this.inventory.getStackInSlot(0), health);
            if (((ProtectorHeartItem)this.inventory.getStackInSlot(0).getItem()).readHealth(this.inventory.getStackInSlot(0)) <= 0.0f) {
                this.inventory.getStackInSlot(0).shrink(1);
                this.inventory.setStackInSlot(0, new ItemStack((ItemLike)ItemRegistry.DYING_PROTECTOR_HEART.get()));
            }
        }
    }

    private void sendUpdate() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryOptional.cast();
        }
        return super.getCapability(cap);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryOptional.invalidate();
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.isEmpty()) {
            return;
        }
        if (tag.contains("Inventory", 10)) {
            this.inventory.deserializeNBT(provider, tag.getCompound("Inventory"));
        }
        if (tag.contains("ProtectorSuccessfullyInvoked", 1)) {
            this.protectorSuccessfullyInvoked = tag.getBoolean("ProtectorSuccessfullyInvoked");
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(provider));
        tag.putBoolean("ProtectorSuccessfullyInvoked", this.protectorSuccessfullyInvoked);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public LazyOptional<ItemStackHandler> getInventoryOptional() {
        return this.inventoryOptional;
    }

    public boolean isProtectorValid(ProtectorEntity protector) {
        if (!this.inventory.getStackInSlot(0).isEmpty()) {
            if (this.heartItem() == null) {
                return false;
            }
            if (Objects.requireNonNull(this.heartItem()).getProtectorID(this.inventory.getStackInSlot(0)) == protector.getId()) {
                return true;
            }
            if (Objects.requireNonNull(this.heartItem()).getProtectorUUID(this.heartStack()) == null) {
                return false;
            }
            if (Objects.equals(Objects.requireNonNull(this.heartItem()).getProtectorUUID(this.inventory.getStackInSlot(0)), protector.getUUID())) {
                Objects.requireNonNull(this.heartItem()).setProtector(this.inventory.getStackInSlot(0), protector);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public ProtectorHeartItem heartItem() {
        if (this.inventory.getStackInSlot(0).isEmpty()) {
            return null;
        }
        if (!this.inventory.getStackInSlot(0).is((Item)ItemRegistry.PROTECTOR_HEART.get())) {
            return null;
        }
        return (ProtectorHeartItem)this.inventory.getStackInSlot(0).getItem();
    }

    @Nullable
    public ItemStack heartStack() {
        if (this.inventory.getStackInSlot(0).isEmpty()) {
            return null;
        }
        if (!this.inventory.getStackInSlot(0).is((Item)ItemRegistry.PROTECTOR_HEART.get())) {
            return null;
        }
        return this.inventory.getStackInSlot(0);
    }

    public String healthText() {
        if (this.inventory.getStackInSlot(0).is((Item)ItemRegistry.PROTECTOR_HEART.get())) {
            return ((ProtectorHeartItem)this.inventory.getStackInSlot(0).getItem()).getTextHealth(this.inventory.getStackInSlot(0));
        }
        return "--/--";
    }

    @Override
    public void tick() {
    }
}

