/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wardentools.block.BlockRegistry;
import wardentools.block.sculktendril.TendrilNode;
import wardentools.block.sculktendril.TendrilTree;
import wardentools.blockentity.BlockEntityRegistry;
import wardentools.tags.ModTags;

public class SculkTendrilBlockEntity
extends BlockEntity {
    private HashMap<Direction, Boolean> connections = new HashMap<Direction, Boolean>(Map.of(Direction.NORTH, false, Direction.SOUTH, false, Direction.EAST, false, Direction.WEST, false, Direction.UP, false, Direction.DOWN, false));
    @Nullable
    private TendrilTree tendrilTreeGraph = null;
    private BlockPos originPos;
    private int width = 0;

    public SculkTendrilBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.originPos = pos;
    }

    public SculkTendrilBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityRegistry.SCULK_TENDRIL_BLOCK_ENTITY.get(), pos, state);
    }

    public boolean isOrigin() {
        return this.tendrilTreeGraph != null;
    }

    public BlockPos getOrigin() {
        return this.originPos;
    }

    public void setOrigin(BlockPos origin) {
        this.originPos = origin;
    }

    @Nullable
    public TendrilTree getTendrilTreeGraph() {
        return this.tendrilTreeGraph;
    }

    public void setTendrilTreeGraph(@NotNull TendrilTree tendrilTreeGraph) {
        this.tendrilTreeGraph = tendrilTreeGraph;
        this.originPos = tendrilTreeGraph.getOrigin();
        this.sendUpdate();
    }

    public boolean getConnection(Direction direction) {
        return this.connections.get(direction);
    }

    public Map<Direction, Boolean> getAllConnections() {
        return this.connections;
    }

    @Nullable
    public TendrilTree getRelativeTendrilTreeGraph() {
        if (this.level == null) {
            return null;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.originPos);
        if (blockEntity instanceof SculkTendrilBlockEntity) {
            SculkTendrilBlockEntity originEntity = (SculkTendrilBlockEntity)blockEntity;
            return originEntity.getTendrilTreeGraph();
        }
        return null;
    }

    public int getWidth() {
        if (this.width == 0) {
            if (this.getRelativeTendrilTreeGraph() == null) {
                return 8;
            }
            this.width = this.getRelativeTendrilTreeGraph().getWidth(this.worldPosition);
        }
        return this.width;
    }

    public void updateWidth() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.getRelativeTendrilTreeGraph() == null) {
            return;
        }
        this.width = this.getRelativeTendrilTreeGraph().getWidth(this.worldPosition);
        this.updateConnections();
        this.sendUpdate();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.tendrilTreeGraph != null) {
            tag.put("tendril_tree", (Tag)this.tendrilTreeGraph.writeTreeToTag());
        }
        tag.put("origin_pos", (Tag)TendrilNode.blockPosToTag(this.originPos));
        tag.putInt("width", this.width);
        this.saveConnectionsToTag(tag);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("tendril_tree")) {
            this.tendrilTreeGraph = new TendrilTree(tag.getCompound("tendril_tree"));
        }
        if (tag.contains("origin_pos")) {
            this.originPos = TendrilNode.blockPosFromTag(tag.getCompound("origin_pos"));
        }
        this.width = tag.contains("width") ? tag.getInt("width") : 0;
        this.loadConnectionsFromTag(tag);
    }

    public void updateConnections() {
        TendrilTree tendrilTree;
        if (this.level != null && (tendrilTree = this.getRelativeTendrilTreeGraph()) != null) {
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = this.worldPosition.relative(direction);
                boolean connected = false;
                if (tendrilTree.getChildrenOf(this.worldPosition).contains(neighborPos) && this.level.getBlockState(neighborPos).is((Block)BlockRegistry.SCULK_TENDRIL_BLOCK.get())) {
                    connected = true;
                } else if (tendrilTree.getParentOf(this.worldPosition) != null && Objects.equals(tendrilTree.getParentOf(this.worldPosition), neighborPos)) {
                    connected = true;
                } else if (this.level.getBlockState(neighborPos).is(ModTags.Blocks.CONNECT_TO_TENDRILS_BLOCKS)) {
                    connected = true;
                }
                this.connections.put(direction, connected);
            }
        }
    }

    private void saveConnectionsToTag(CompoundTag tag) {
        for (Map.Entry<Direction, Boolean> entry : this.connections.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            tag.putBoolean(entry.getKey().getSerializedName(), true);
        }
    }

    private void loadConnectionsFromTag(CompoundTag tag) {
        for (Direction direction : Direction.values()) {
            if (tag.contains(direction.getSerializedName())) {
                this.connections.put(direction, tag.getBoolean(direction.getSerializedName()));
                continue;
            }
            this.connections.put(direction, false);
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    private void sendUpdate() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)((float)this.worldPosition.getX() - 1.0f), (double)((float)this.worldPosition.getY() - 1.0f), (double)((float)this.worldPosition.getZ() - 1.0f), (double)((float)this.worldPosition.getX() + 1.0f), (double)((float)this.worldPosition.getY() + 1.0f), (double)((float)this.worldPosition.getZ() + 1.0f));
    }
}

