/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import wardentools.blockentity.AbyssPortalBlockEntity;
import wardentools.client.rendering.AbyssPortalBuilder;

public class AbyssPortalBlockRenderer
implements BlockEntityRenderer<AbyssPortalBlockEntity> {
    public AbyssPortalBlockRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@NotNull AbyssPortalBlockEntity entity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (entity.getLevel() == null) {
            return;
        }
        ClientLevel level = (ClientLevel)entity.getLevel();
        Minecraft mc = Minecraft.getInstance();
        Camera camera = mc.gameRenderer.getMainCamera();
        AbyssPortalBuilder.INSTANCE.updateSkyTexture(level, camera, partialTicks);
        int skyTex = AbyssPortalBuilder.INSTANCE.getSkyTextureId();
        if (skyTex == 0) {
            return;
        }
        poseStack.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (int)skyTex);
        Matrix4f projection = RenderSystem.getProjectionMatrix();
        Matrix4f view = RenderSystem.getModelViewMatrix();
        Matrix4f model = poseStack.last().pose();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bb = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        for (Direction dir : Direction.values()) {
            if (!entity.shouldRenderFace(dir)) continue;
            AbyssPortalBlockRenderer.emitFace(bb, model, view, projection, dir);
        }
        BufferUploader.drawWithShader((MeshData)bb.buildOrThrow());
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    private static void emitFace(BufferBuilder bb, Matrix4f model, Matrix4f view, Matrix4f projection, Direction dir) {
        float[][] corners;
        float x0 = 0.0f;
        float x1 = 1.0f;
        float y0 = 0.0f;
        float y1 = 1.0f;
        float z0 = 0.0f;
        float z1 = 1.0f;
        switch (dir) {
            case NORTH: {
                corners = new float[][]{{x0, y0, z0}, {x1, y0, z0}, {x1, y1, z0}, {x0, y1, z0}};
                break;
            }
            case SOUTH: {
                corners = new float[][]{{x1, y0, z1}, {x0, y0, z1}, {x0, y1, z1}, {x1, y1, z1}};
                break;
            }
            case WEST: {
                corners = new float[][]{{x0, y0, z1}, {x0, y0, z0}, {x0, y1, z0}, {x0, y1, z1}};
                break;
            }
            case EAST: {
                corners = new float[][]{{x1, y0, z0}, {x1, y0, z1}, {x1, y1, z1}, {x1, y1, z0}};
                break;
            }
            case DOWN: {
                corners = new float[][]{{x0, y0, z0}, {x1, y0, z0}, {x1, y0, z1}, {x0, y0, z1}};
                break;
            }
            case UP: {
                corners = new float[][]{{x0, y1, z1}, {x1, y1, z1}, {x1, y1, z0}, {x0, y1, z0}};
                break;
            }
            default: {
                return;
            }
        }
        for (float[] c : corners) {
            float x = c[0];
            float y = c[1];
            float z = c[2];
            float[] uv = AbyssPortalBlockRenderer.projectToUv(model, view, projection, x, y, z);
            bb.addVertex(model, x, y, z).setUv(uv[0], uv[1]).setColor(255, 255, 255, 255);
        }
    }

    private static float[] projectToUv(Matrix4f model, Matrix4f view, Matrix4f proj, float x, float y, float z) {
        Vector4f v = new Vector4f(x, y, z, 1.0f);
        v.mul((Matrix4fc)model).mul((Matrix4fc)view).mul((Matrix4fc)proj);
        float w = v.w != 0.0f ? v.w : 1.0E-6f;
        float ndcX = v.x / w;
        float ndcY = v.y / w;
        float u = 0.5f * (ndcX + 1.0f);
        float vtex = 0.5f * (1.0f - ndcY);
        if (u < 0.0f) {
            u = 0.0f;
        }
        if (u > 1.0f) {
            u = 1.0f;
        }
        if (vtex < 0.0f) {
            vtex = 0.0f;
        }
        if (vtex > 1.0f) {
            vtex = 1.0f;
        }
        return new float[]{u, vtex};
    }
}

