/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;
import wardentools.block.ContagionIncarnationSkullBlock;
import wardentools.blockentity.ContagionIncarnationSkullBlockEntity;
import wardentools.client.model.ContagionIncarnationSkull;

public class ContagionIncarnationSkullRenderer
implements BlockEntityRenderer<ContagionIncarnationSkullBlockEntity> {
    private static final ContagionIncarnationSkull model = new ContagionIncarnationSkull(ContagionIncarnationSkull.createBodyLayer().bakeRoot());
    private static final ResourceLocation INTERIOR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/models/contagion_incarnation_corpse_skull.png");

    public ContagionIncarnationSkullRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@NotNull ContagionIncarnationSkullBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        if (!level.getBlockState(blockEntity.getBlockPos()).is((Block)BlockRegistry.CONTAGION_INCARNATION_SKULL.get())) {
            return;
        }
        ContagionIncarnationSkullRenderer.renderModel(blockEntity, poseStack, level, buffer, packedOverlay);
    }

    private static void renderModel(ContagionIncarnationSkullBlockEntity skull, PoseStack poseStack, Level level, MultiBufferSource buffer, int packedOverlay) {
        BlockPos pos = skull.getBlockPos();
        BlockState state = level.getBlockState(pos);
        poseStack.pushPose();
        poseStack.translate(0.5, 1.5, 0.5);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        switch ((Direction)state.getValue((Property)ContagionIncarnationSkullBlock.FACING)) {
            case NORTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
        }
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)INTERIOR_TEXTURE));
        model.render(poseStack, vertexConsumer, LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, pos), (int)level.getBrightness(LightLayer.SKY, pos)), packedOverlay);
        poseStack.popPose();
    }
}

