/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.NotNull;
import wardentools.blockentity.DysfunctionningCatalystBlockEntity;
import wardentools.client.model.DysfunctionningCatalystInterior;

public class DysfunctionningCatalystRenderer
implements BlockEntityRenderer<DysfunctionningCatalystBlockEntity> {
    private static final float averageRotationSpeed = 3.0f;
    private static final float speedAmplifier = 10.0f;
    private static final float scaleAmplifier = 1.6f;
    private static final DysfunctionningCatalystInterior model = new DysfunctionningCatalystInterior(DysfunctionningCatalystInterior.createBodyLayer().bakeRoot());
    private static final ResourceLocation INTERIOR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/models/dysfunctionning_catalyst_interior.png");

    public DysfunctionningCatalystRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@NotNull DysfunctionningCatalystBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        DysfunctionningCatalystRenderer.renderInterior(blockEntity.getBlockPos(), poseStack, level, partialTick, buffer, packedOverlay);
    }

    private static void renderInterior(BlockPos pos, PoseStack poseStack, Level level, float partialTick, MultiBufferSource buffer, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        double relativeGameTime = (float)level.getGameTime() + partialTick;
        float speedX = Mth.sin((float)((float)relativeGameTime / 80.0f)) * 10.0f;
        float speedY = Mth.sin((float)((float)relativeGameTime / 100.0f)) * 10.0f;
        float speedZ = Mth.sin((float)((float)relativeGameTime / 130.0f)) * 10.0f;
        float rotationX = ((float)relativeGameTime + speedX) * 3.0f;
        float rotationY = ((float)relativeGameTime + speedY) * 3.0f;
        float rotationZ = ((float)relativeGameTime + speedZ) * 3.0f;
        poseStack.mulPose(Axis.XP.rotationDegrees(rotationX));
        poseStack.mulPose(Axis.YP.rotationDegrees(rotationY));
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotationZ));
        float scale = (Mth.sin((float)((float)relativeGameTime / 20.0f)) * Mth.sin((float)((float)relativeGameTime / 60.0f)) / 4.0f + 1.0f) * 1.6f;
        poseStack.scale(scale, scale, scale);
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)INTERIOR_TEXTURE));
        model.render(poseStack, vertexConsumer, LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, pos), (int)level.getBrightness(LightLayer.SKY, pos)), packedOverlay);
        poseStack.popPose();
    }
}

