/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;
import wardentools.block.GramophoneBlock;
import wardentools.blockentity.GramophoneBlockEntity;
import wardentools.client.model.DiscModel;

public class GramophoneRenderer
implements BlockEntityRenderer<GramophoneBlockEntity> {
    private static final DiscModel MODEL = new DiscModel(DiscModel.createBodyLayer().bakeRoot());
    private static final float SCALE = 0.8f;
    private static final float rotationSpeed = 1.5f;
    private float lastRot = 0.0f;
    private ItemStack cachedItem;
    private ResourceLocation cachedTexture;

    public GramophoneRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@NotNull GramophoneBlockEntity gramophone, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (gramophone.getLevel() == null) {
            return;
        }
        BlockState block = gramophone.getLevel().getBlockState(gramophone.getBlockPos());
        if (!block.is((Block)BlockRegistry.GRAMOPHONE.get())) {
            return;
        }
        if (block.getValue(GramophoneBlock.HALF) != DoubleBlockHalf.LOWER) {
            return;
        }
        if (!gramophone.isEmpty()) {
            if (this.cachedItem != gramophone.getTheItem()) {
                this.cachedItem = gramophone.getTheItem();
                this.cachedTexture = DiscModel.resourceForItem(this.cachedItem);
            }
            this.renderDisc(gramophone, partialTick, poseStack, buffer, packedOverlay);
        }
    }

    private void renderDisc(GramophoneBlockEntity gramophone, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedOverlay) {
        Level level = gramophone.getLevel();
        if (level == null) {
            return;
        }
        BlockPos pos = gramophone.getBlockPos();
        poseStack.pushPose();
        poseStack.translate(0.5f, -0.43f, 0.5f);
        poseStack.scale(0.8f, 0.8f, 0.8f);
        float relativeGameTime = (float)level.getGameTime() + partialTick;
        if (gramophone.isPlaying()) {
            this.lastRot = 1.5f * relativeGameTime;
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(this.lastRot));
        this.discModelRender(gramophone.getTheItem(), poseStack, buffer, packedOverlay, pos, level);
        poseStack.popPose();
    }

    private void discModelRender(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int packedOverlay, BlockPos pos, Level level) {
        int packedLight = LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, pos), (int)level.getBrightness(LightLayer.SKY, pos));
        VertexConsumer baseConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.cachedTexture));
        MODEL.render(poseStack, baseConsumer, packedLight, packedOverlay);
    }
}

