/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import wardentools.blockentity.LivingSproutBlockEntity;
import wardentools.client.model.LivingSproutCoreModel;

public class LivingSproutRenderer
implements BlockEntityRenderer<LivingSproutBlockEntity> {
    private static final LivingSproutCoreModel model = new LivingSproutCoreModel(LivingSproutCoreModel.createBodyLayer().bakeRoot());
    private static final ResourceLocation CORE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/models/living_sprout_core.png");
    public static final float sizeAtBeat = 0.5f;
    public static final float sizeBetweenBeats = 0.375f;
    public static final int HEART_BEAT_DURATION = 216;
    public static final int[] BEAT_TICKS = new int[]{11, 16, 25, 30, 40, 45, 55, 60, 69, 73, 83, 88, 99, 105, 117, 122, 136, 141, 155, 163, 180, 187, 204, 121};

    public LivingSproutRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@NotNull LivingSproutBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        LivingSproutRenderer.renderInterior(blockEntity.getBlockPos(), poseStack, level, partialTick, buffer, packedOverlay);
    }

    private static void renderInterior(BlockPos pos, PoseStack poseStack, Level level, float partialTick, MultiBufferSource buffer, int packedOverlay) {
        LivingSproutBlockEntity sprout;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LivingSproutBlockEntity && (sprout = (LivingSproutBlockEntity)blockEntity).isPulsing()) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5625f, 0.5f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            float scale = 3.0f * LivingSproutRenderer.getSizeAtTick(sprout.getLastTimeHeard(), (int)level.getGameTime(), partialTick);
            poseStack.scale(scale, scale, scale);
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)CORE_TEXTURE));
            model.render(poseStack, vertexConsumer, LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, pos), (int)level.getBrightness(LightLayer.SKY, pos)), packedOverlay);
            poseStack.popPose();
        }
    }

    private static float getSizeAtTick(int startTick, int tick, float partialTick) {
        float currentTick = (float)(tick - startTick) + partialTick;
        if (currentTick <= 0.0f || currentTick >= 226.0f) {
            return 0.375f;
        }
        float closestDistance = Float.MAX_VALUE;
        for (int beatTick : BEAT_TICKS) {
            float distance = Math.abs(currentTick - (float)beatTick);
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
        }
        float transitionRange = 2.0f;
        if (closestDistance <= transitionRange) {
            float factor = 1.0f - closestDistance / transitionRange;
            factor = (float)Math.sin((double)factor * Math.PI * 0.5);
            return 0.375f + 0.125f * factor;
        }
        return 0.375f;
    }
}

