/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import wardentools.blockentity.ProtectorInvokerBlockEntity;
import wardentools.items.ItemRegistry;

public class ProtectorInvokerRenderer
implements BlockEntityRenderer<ProtectorInvokerBlockEntity> {
    private final BlockEntityRendererProvider.Context context;
    private boolean sentParticle = false;
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private int time = 0;
    private float previouspTick = 0.0f;
    private static final int RAY_NUMBER = 5;
    private static final float RAY_SPEED = 0.2f;
    private static final float ITEM_SCALE = 0.3f;
    private static final float ITEM_OFFSET = 0.85f;
    private static final float TEXT_OFFSET = 1.25f;

    public ProtectorInvokerRenderer(BlockEntityRendererProvider.Context ctx) {
        this.context = ctx;
    }

    public void render(ProtectorInvokerBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packLight, int packedOverlay) {
        ItemStack stack = blockEntity.getInventory().getStackInSlot(0);
        if (!stack.isEmpty()) {
            Level level = blockEntity.getLevel();
            if (level == null) {
                return;
            }
            BlockPos pos = blockEntity.getBlockPos().above();
            double relativeGameTime = (float)level.getGameTime() + partialTick;
            double rotation = relativeGameTime / 0.8;
            if (stack.is((Item)ItemRegistry.PROTECTOR_HEART.get()) && blockEntity.protectorSuccessfullyInvoked) {
                this.animateLight(partialTick, buffer, poseStack, 0.85f);
            } else if (stack.is((Item)ItemRegistry.DYING_PROTECTOR_HEART.get())) {
                this.animateRedParticles(level, pos, 0.85f);
            }
            this.renderItem(level, poseStack, stack, buffer, 0.85f, 0.3f, rotation);
            this.renderText(level, pos, poseStack, 1.25, blockEntity, buffer);
        }
        this.previouspTick = partialTick;
    }

    private void renderItem(Level level, PoseStack poseStack, ItemStack stack, MultiBufferSource buffer, double offset, double scale, double rotation) {
        poseStack.pushPose();
        poseStack.translate(0.5, offset, 0.5);
        poseStack.scale((float)scale, (float)scale, (float)scale);
        poseStack.mulPose(Axis.YP.rotationDegrees((float)rotation));
        this.context.getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, 255, 10, poseStack, buffer, level, 0);
        poseStack.popPose();
    }

    private void renderText(Level level, BlockPos pos, PoseStack poseStack, double offset, ProtectorInvokerBlockEntity blockEntity, MultiBufferSource buffer) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            int packedLight = LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, pos), (int)level.getBrightness(LightLayer.SKY, pos));
            Vec3 playerPos = player.position();
            double dx = playerPos.x - (double)((float)pos.getX() + 0.5f);
            double dz = playerPos.z - (double)((float)pos.getZ() + 0.5f);
            float scaleTxt = 0.015f;
            poseStack.pushPose();
            poseStack.translate(0.5, offset, 0.5);
            poseStack.scale(scaleTxt, -scaleTxt, scaleTxt);
            if (dz < 0.0) {
                poseStack.mulPose(Axis.YP.rotation(3.1415f + (float)Math.atan(dx / dz)));
            } else {
                poseStack.mulPose(Axis.YP.rotation((float)Math.atan(dx / dz)));
            }
            Font font = this.context.getFont();
            String healthText = blockEntity.healthText();
            poseStack.translate((float)(-font.width(healthText)) / 2.0f, 0.0f, 0.0f);
            font.drawInBatch(healthText, 0.0f, 0.0f, 0xECECEC, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, packedLight);
            poseStack.popPose();
        }
    }

    private void animateRedParticles(Level level, BlockPos pos, double offset) {
        if (level.getGameTime() % 25L == 0L && !this.sentParticle) {
            this.sentParticle = true;
            double offsetX = (level.random.nextDouble() - 0.5) * 0.15;
            double offsetY = (level.random.nextDouble() - 0.5) * 0.15;
            double offsetZ = (level.random.nextDouble() - 0.5) * 0.15;
            level.addParticle((ParticleOptions)ParticleTypes.CRIMSON_SPORE, true, (double)pos.getX() + 0.5, (double)pos.getY() - offset + 1.0, (double)pos.getZ() + 0.5, offsetX, offsetY, offsetZ);
        } else {
            this.sentParticle = false;
        }
    }

    private void animateLight(float partialTick, MultiBufferSource buffer, PoseStack poseStack, double offset) {
        if (partialTick < this.previouspTick) {
            ++this.time;
        }
        RandomSource randomsource = RandomSource.create((long)432L);
        float lengthOfRay = 0.7f + randomsource.nextFloat() * 0.3f;
        float widthOfRay = 0.1f + randomsource.nextFloat() * 0.05f;
        float f5 = (float)this.time / 20.0f;
        float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
        VertexConsumer vertexconsumer2 = buffer.getBuffer(RenderType.lightning());
        poseStack.pushPose();
        poseStack.translate(0.5, offset, 0.5);
        for (int i = 0; i < 5; ++i) {
            poseStack.mulPose(Axis.XP.rotationDegrees(randomsource.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(randomsource.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(randomsource.nextFloat() * 360.0f + (float)this.time * 0.2f));
            poseStack.mulPose(Axis.XP.rotationDegrees(randomsource.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(randomsource.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(randomsource.nextFloat() * 360.0f + (float)this.time * 0.2f));
            float f3 = lengthOfRay + f7 * lengthOfRay / 4.0f;
            float f4 = widthOfRay + f7 * widthOfRay / 4.0f;
            Matrix4f matrix4f = poseStack.last().pose();
            int j = 200;
            ProtectorInvokerRenderer.vertex01(vertexconsumer2, matrix4f, j);
            ProtectorInvokerRenderer.vertex2(vertexconsumer2, matrix4f, f3, f4);
            ProtectorInvokerRenderer.vertex3(vertexconsumer2, matrix4f, f3, f4);
            ProtectorInvokerRenderer.vertex01(vertexconsumer2, matrix4f, j);
            ProtectorInvokerRenderer.vertex3(vertexconsumer2, matrix4f, f3, f4);
            ProtectorInvokerRenderer.vertex4(vertexconsumer2, matrix4f, f3, f4);
            ProtectorInvokerRenderer.vertex01(vertexconsumer2, matrix4f, j);
            ProtectorInvokerRenderer.vertex4(vertexconsumer2, matrix4f, f3, f4);
            ProtectorInvokerRenderer.vertex2(vertexconsumer2, matrix4f, f3, f4);
        }
        poseStack.popPose();
    }

    private static void vertex01(VertexConsumer vertexConsumer, Matrix4f mat, int alpha) {
        vertexConsumer.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(183, 208, 226, alpha);
    }

    private static void vertex2(VertexConsumer vertexConsumer, Matrix4f mat, float f1, float f2) {
        vertexConsumer.addVertex(mat, -HALF_SQRT_3 * f2, f1, -0.5f * f2).setColor(0, 255, 255, 0);
    }

    private static void vertex3(VertexConsumer vertexConsumer, Matrix4f mat, float f1, float f2) {
        vertexConsumer.addVertex(mat, HALF_SQRT_3 * f2, f1, -0.5f * f2).setColor(15, 195, 183, 0);
    }

    private static void vertex4(VertexConsumer vertexConsumer, Matrix4f mat, float f1, float f2) {
        vertexConsumer.addVertex(mat, 0.0f, f1, f2).setColor(117, 176, 216, 0);
    }
}

