/*
 * Decompiled with CFR 0.152.
 */
package wardentools.client;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;
import wardentools.gui.menu.RadianceCatalystMenu;

public class RadianceCatalystScreen
extends AbstractContainerScreen<RadianceCatalystMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/radiance_catalyst_menu.png");
    private static final Component CORRUPTED = Component.translatable((String)"gui.wardentools.radiance_catalyst_screen.hover.corrupted");
    private static final Component PURE = Component.translatable((String)"gui.wardentools.radiance_catalyst_screen.hover.pure");

    public RadianceCatalystScreen(RadianceCatalystMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int bar1Length1 = 36;
        int bar1Length2 = 7;
        int bar1Height = 15;
        int barTotalLength = bar1Length1 + bar1Length2 + bar1Height + 6;
        int energyScaleBar = (int)((float)((RadianceCatalystMenu)this.menu).getEnergy() / (float)((RadianceCatalystMenu)this.menu).getMaxEnergy() * (float)barTotalLength);
        if (energyScaleBar <= bar1Length1) {
            guiGraphics.fill(this.leftPos + 64, this.topPos + 43, this.leftPos + 65 + energyScaleBar, this.topPos + 45, -13378083);
        } else if (energyScaleBar == bar1Length1 + 1) {
            guiGraphics.fill(this.leftPos + 101, this.topPos + 44, this.leftPos + 102, this.topPos + 45, -13378083);
            guiGraphics.fill(this.leftPos + 64, this.topPos + 43, this.leftPos + 65 + bar1Length1, this.topPos + 45, -13378083);
        } else if (energyScaleBar == bar1Length1 + 2) {
            guiGraphics.fill(this.leftPos + 102, this.topPos + 44, this.leftPos + 103, this.topPos + 45, -13378083);
            guiGraphics.fill(this.leftPos + 64, this.topPos + 43, this.leftPos + 66 + bar1Length1, this.topPos + 45, -13378083);
        } else if (energyScaleBar <= bar1Length1 + bar1Height + 3) {
            guiGraphics.fill(this.leftPos + 101, this.topPos + 43, this.leftPos + 103, this.topPos + 43 - (energyScaleBar - (bar1Length1 + 3)), -13378083);
            guiGraphics.fill(this.leftPos + 64, this.topPos + 43, this.leftPos + 67 + bar1Length1, this.topPos + 45, -13378083);
        } else if (energyScaleBar == bar1Length1 + bar1Height + 4) {
            guiGraphics.fill(this.leftPos + 101, this.topPos + 27, this.leftPos + 102, this.topPos + 28, -13378083);
            guiGraphics.fill(this.leftPos + 101, this.topPos + 43, this.leftPos + 103, this.topPos + 43 - bar1Height, -13378083);
            guiGraphics.fill(this.leftPos + 64, this.topPos + 43, this.leftPos + 67 + bar1Length1, this.topPos + 45, -13378083);
        } else if (energyScaleBar == bar1Length1 + bar1Height + 5) {
            guiGraphics.fill(this.leftPos + 101, this.topPos + 26, this.leftPos + 102, this.topPos + 27, -13378083);
            guiGraphics.fill(this.leftPos + 101, this.topPos + 43, this.leftPos + 103, this.topPos + 42 - bar1Height, -13378083);
            guiGraphics.fill(this.leftPos + 64, this.topPos + 43, this.leftPos + 67 + bar1Length1, this.topPos + 45, -13378083);
        } else if (energyScaleBar <= barTotalLength) {
            guiGraphics.fill(this.leftPos + 103, this.topPos + 26, this.leftPos + 103 + energyScaleBar - (bar1Length1 + bar1Height + 6), this.topPos + 28, -13378083);
            guiGraphics.fill(this.leftPos + 101, this.topPos + 43, this.leftPos + 103, this.topPos + 41 - bar1Height, -13378083);
            guiGraphics.fill(this.leftPos + 64, this.topPos + 43, this.leftPos + 67 + bar1Length1, this.topPos + 45, -13378083);
        }
        int bar2Height = 17;
        int purifyScale = (int)((float)((RadianceCatalystMenu)this.menu).getPurifyingTime() / 200.0f * (float)bar2Height);
        guiGraphics.fill(this.leftPos + 118, this.topPos + 36 + purifyScale, this.leftPos + 120, this.topPos + 53, -7631989);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        if (this.customIsHovering(131, 22, 140, 31, mouseX, mouseY)) {
            graphics.renderTooltip(this.font, CORRUPTED, mouseX, mouseY);
        }
        if (this.customIsHovering(131, 57, 140, 66, mouseX, mouseY)) {
            graphics.renderTooltip(this.font, PURE, mouseX, mouseY);
        }
    }

    private boolean customIsHovering(int x1, int y1, int x2, int y2, int mouseX, int mouseY) {
        return this.leftPos + x1 <= mouseX && this.topPos + y1 <= mouseY && this.leftPos + x2 >= mouseX && this.topPos + y2 >= mouseY;
    }
}

