/*
 * Decompiled with CFR 0.152.
 */
package wardentools.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DiscModel
extends Model {
    private static final ResourceLocation DEFAULT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/models/disc_model/music_disc_default.png");
    private final ModelPart root;

    public DiscModel(ModelPart root) {
        super(RenderType::entityCutout);
        this.root = root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bb_main = partdefinition.addOrReplaceChild("bb_main", CubeListBuilder.create().texOffs(0, 0).addBox(-6.5f, -1.0f, -2.5f, 13.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(-5.5f, -1.0f, -4.5f, 11.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 12).addBox(-4.5f, -1.0f, -5.5f, 9.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-2.5f, -1.0f, -6.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 9).addBox(-5.5f, -1.0f, 2.5f, 11.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 14).addBox(-4.5f, -1.0f, 4.5f, 9.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(12, 16).addBox(-2.5f, -1.0f, 5.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int i) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
    }

    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public static ResourceLocation resourceForItem(ItemStack stack) {
        String name = stack.getItem().getDescriptionId().substring(stack.getItem().getDescriptionId().lastIndexOf(46) + 1);
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("textures/models/disc_model/" + name + ".png"));
        ResourceManager manager = Minecraft.getInstance().getResourceManager();
        return manager.getResource(location).isPresent() ? location : DEFAULT_TEXTURE;
    }
}

