/*
 * Decompiled with CFR 0.152.
 */
package wardentools.client.rendering;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import wardentools.client.rendering.LevelRendererUtils;

@OnlyIn(value=Dist.CLIENT)
public class AbyssPortalBuilder {
    public static final AbyssPortalBuilder INSTANCE = new AbyssPortalBuilder();
    private RenderTarget skyTarget;
    private long lastGameTime = -1L;
    private int lastPartialKey = -1;

    private AbyssPortalBuilder() {
    }

    public void updateSkyTexture(ClientLevel level, Camera camera, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        long gt = level.getGameTime();
        int pk = (int)(partialTicks * 1000.0f);
        if (gt == this.lastGameTime && pk == this.lastPartialKey) {
            return;
        }
        this.lastGameTime = gt;
        this.lastPartialKey = pk;
        if (this.skyTarget == null) {
            this.skyTarget = new TextureTarget(mc.getWindow().getWidth(), mc.getWindow().getHeight(), true, Minecraft.ON_OSX);
            this.skyTarget.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        } else if (this.skyTarget.width != mc.getWindow().getWidth() || this.skyTarget.height != mc.getWindow().getHeight()) {
            this.skyTarget.resize(mc.getWindow().getWidth(), mc.getWindow().getHeight(), Minecraft.ON_OSX);
        }
        this.skyTarget.bindWrite(true);
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.clear((int)17664, (boolean)Minecraft.ON_OSX);
        LevelRendererUtils.renderSky(level, AbyssPortalBuilder.view(camera), 255);
        mc.getMainRenderTarget().bindWrite(true);
    }

    public int getSkyTextureId() {
        return this.skyTarget != null ? this.skyTarget.getColorTextureId() : 0;
    }

    public static Matrix4f view(Camera camera) {
        Quaternionf q = camera.rotation().conjugate(new Quaternionf());
        return new Matrix4f().rotate((Quaternionfc)q);
    }
}

