/*
 * Decompiled with CFR 0.152.
 */
package wardentools.client.rendering;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import wardentools.misc.Star;

@OnlyIn(value=Dist.CLIENT)
public class LevelRendererUtils {
    public static final ResourceLocation STAR_0 = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/environment/star_0.png");
    public static final ResourceLocation STAR_1 = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/environment/star_1.png");
    public static final ResourceLocation STAR_2 = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/environment/star_2.png");
    public static final ResourceLocation STAR_3 = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/environment/star_3.png");
    public static final ResourceLocation STAR_4 = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/environment/star_4.png");
    public static final List<ResourceLocation> STAR_TEXTURES = List.of(STAR_0, STAR_1, STAR_2, STAR_3, STAR_4);
    public static final Vec3i SKYCOLOR = new Vec3i(0, 75, 85);

    public static void renderSky(ClientLevel level, Matrix4f pose, int brightness) {
        PoseStack posestack = new PoseStack();
        posestack.mulPose(pose);
        Tesselator tesselator = Tesselator.getInstance();
        VertexBuffer.unbind();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        LevelRendererUtils.renderSkyBackGround(posestack, tesselator, brightness);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float alpha = (float)brightness / 255.0f;
        if (alpha > 0.0f) {
            LevelRendererUtils.renderMultipleStarLayers(level, alpha, posestack, tesselator);
        }
        RenderSystem.defaultBlendFunc();
        posestack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }

    public static void renderSkyBackGround(PoseStack posestack, Tesselator tesselator, int brightness) {
        posestack.pushPose();
        posestack.mulPose(Axis.XP.rotationDegrees(90.0f));
        float red = (float)SKYCOLOR.getX() / 255.0f;
        float blue = (float)SKYCOLOR.getY() / 255.0f;
        float green = (float)SKYCOLOR.getZ() / 255.0f;
        float alpha = (float)brightness / 255.0f;
        Matrix4f matrix4f = posestack.last().pose();
        posestack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        bufferbuilder.addVertex(matrix4f, 0.0f, 90.0f, 0.0f).setColor(0.0f, 0.1f, 0.1f, alpha);
        int N = 32;
        for (int j = 0; j <= N; ++j) {
            float azimuth = (float)j * ((float)Math.PI * 2) / (float)N;
            float x = 90.0f * Mth.cos((float)azimuth);
            float y = -10.0f;
            float z = 90.0f * Mth.sin((float)azimuth);
            bufferbuilder.addVertex(matrix4f, x, y, z).setColor(red, green, blue, 0.0f);
        }
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        posestack.popPose();
    }

    public static void renderMultipleStarLayers(ClientLevel level, float alpha, PoseStack posestack, Tesselator tesselator) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)alpha, (float)alpha, (float)alpha, (float)alpha);
        FogRenderer.setupNoFog();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        RandomSource rand = RandomSource.create((long)1337L);
        LevelRendererUtils.renderStars(level, tesselator, rand, posestack, 60, List.of(Axis.XP, Axis.YP), new float[]{1.2f, 0.1f}, 1.0f);
        LevelRendererUtils.renderStars(level, tesselator, rand, posestack, 60, List.of(Axis.XP, Axis.YP, Axis.ZP), new float[]{-1.1f, 0.1f, 0.3f}, 1.0f);
        LevelRendererUtils.renderStars(level, tesselator, rand, posestack, 120, List.of(Axis.YP, Axis.ZP), new float[]{-1.0f, 0.3f}, 0.9f);
        LevelRendererUtils.renderStars(level, tesselator, rand, posestack, 140, List.of(Axis.XP, Axis.ZP), new float[]{0.4f, -0.7f}, 0.8f);
        LevelRendererUtils.renderStars(level, tesselator, rand, posestack, 160, List.of(Axis.XP, Axis.YP, Axis.ZP), new float[]{0.2f, -0.3f, 0.4f}, 0.7f);
        LevelRendererUtils.renderStars(level, tesselator, rand, posestack, 180, List.of(Axis.XP, Axis.YP, Axis.ZP), new float[]{-0.4f, 0.5f, -0.2f}, 0.6f);
        RenderSystem.enableCull();
    }

    public static void renderStars(ClientLevel level, Tesselator tesselator, RandomSource rand, PoseStack posestack, int starCount, List<Axis> rotationAxis, float[] rotationSpeeds, float averageSize) {
        posestack.pushPose();
        for (int i = 0; i < rotationAxis.size(); ++i) {
            posestack.mulPose(rotationAxis.get(i).rotationDegrees((float)level.getGameTime() * rotationSpeeds[i] / 20.0f / 60.0f / 20.0f * 360.0f));
        }
        Matrix4f mat = posestack.last().pose();
        float minLen2 = 0.010000001f;
        float maxLen2 = 1.0f;
        float radius = 140.0f;
        HashMap starsByTex = new HashMap();
        for (ResourceLocation tex : STAR_TEXTURES) {
            starsByTex.put(tex, new ArrayList());
        }
        int placed = 0;
        while (placed < starCount) {
            float f3;
            float f2;
            ResourceLocation tex;
            tex = STAR_TEXTURES.get(rand.nextInt(STAR_TEXTURES.size()));
            float f1 = rand.nextFloat() * 2.0f - 1.0f;
            float len2 = Mth.lengthSquared((float)f1, (float)(f2 = rand.nextFloat() * 2.0f - 1.0f), (float)(f3 = rand.nextFloat() * 2.0f - 1.0f));
            if (len2 <= minLen2 || len2 >= maxLen2) continue;
            Vector3f pos = new Vector3f(f1, f2, f3).normalize(radius);
            float size = averageSize * (rand.nextFloat() + 0.5f);
            float rot = (float)(rand.nextDouble() * Math.PI * 2.0);
            ((List)starsByTex.get(tex)).add(new Star(pos, size, rot));
            ++placed;
        }
        for (ResourceLocation tex : STAR_TEXTURES) {
            List stars = (List)starsByTex.get(tex);
            if (stars.isEmpty()) continue;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex);
            BufferBuilder starBuf = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            for (Star star : stars) {
                Quaternionf q = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f), (Vector3fc)new Vector3f((Vector3fc)star.pos())).rotateZ(star.rot());
                Vector3f c0 = new Vector3f(star.size(), -star.size(), 0.0f).rotate((Quaternionfc)q).add((Vector3fc)star.pos());
                Vector3f c1 = new Vector3f(star.size(), star.size(), 0.0f).rotate((Quaternionfc)q).add((Vector3fc)star.pos());
                Vector3f c2 = new Vector3f(-star.size(), star.size(), 0.0f).rotate((Quaternionfc)q).add((Vector3fc)star.pos());
                Vector3f c3 = new Vector3f(-star.size(), -star.size(), 0.0f).rotate((Quaternionfc)q).add((Vector3fc)star.pos());
                starBuf.addVertex(mat, c0.x(), c0.y(), c0.z()).setUv(1.0f, 0.0f);
                starBuf.addVertex(mat, c1.x(), c1.y(), c1.z()).setUv(1.0f, 1.0f);
                starBuf.addVertex(mat, c2.x(), c2.y(), c2.z()).setUv(0.0f, 1.0f);
                starBuf.addVertex(mat, c3.x(), c3.y(), c3.z()).setUv(0.0f, 0.0f);
            }
            BufferUploader.drawWithShader((MeshData)starBuf.buildOrThrow());
        }
        posestack.popPose();
    }
}

