/*
 * Decompiled with CFR 0.152.
 */
package wardentools.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wardentools.advancement.ModAdvancementProvider;
import wardentools.datagen.ModBlockStateProvider;
import wardentools.datagen.ModBlockTagGenerator;
import wardentools.datagen.ModDataBuilderProvider;
import wardentools.datagen.ModItemModelProvider;
import wardentools.datagen.ModItemTagGenerator;
import wardentools.datagen.ModRecipesGenerator;
import wardentools.datagen.loot.ModGlobalLootModifiersProvider;
import wardentools.datagen.loot.ModLootTableProvider;
import wardentools.worldgen.biome.ModBiomeTagGenerator;

@Mod.EventBusSubscriber(modid="wardentools", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ModBlockTagGenerator blockTagGenerator = (ModBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipesGenerator(packOutput, lookupProvider));
        ModDataBuilderProvider dataBuilder = new ModDataBuilderProvider(packOutput, lookupProvider);
        generator.addProvider(event.includeServer(), (DataProvider)dataBuilder);
        CompletableFuture combinedLookup = dataBuilder.getFullRegistries();
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)ModAdvancementProvider.create(packOutput, combinedLookup, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBiomeTagGenerator(packOutput, dataBuilder.getRegistryProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(packOutput, combinedLookup));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifiersProvider(packOutput, combinedLookup));
    }
}

