/*
 * Decompiled with CFR 0.152.
 */
package wardentools.datagen;

import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import wardentools.block.BlockRegistry;
import wardentools.block.BlueBush;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "wardentools", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerBlockWithItem(BlockRegistry.DARKTREE_PLANKS);
        this.registerBlockWithItem(BlockRegistry.WHITETREE_PLANKS);
        this.registerBlockWithItem(BlockRegistry.DEEPBLOCK);
        this.registerBlockWithItem(BlockRegistry.DARKDIRT);
        this.registerBlockWithItem(BlockRegistry.PALE_CRISTAL_BLOCK);
        this.registerBlockWithItem(BlockRegistry.CITRINE_BLOCK);
        this.registerBlockWithItem(BlockRegistry.ECHO_BLOCK);
        this.registerBlockWithItem(BlockRegistry.RUBY_BLOCK);
        this.registerBlockWithItem(BlockRegistry.MALACHITE_BLOCK);
        this.registerBlockWithItem(BlockRegistry.SOLID_CORRUPTION);
        this.registerTopBottomSideBlock(BlockRegistry.CHISELED_ABYSSALITE, "chiseled_abyssalite", "chiseled_abyssalite_top", "chiseled_abyssalite_top");
        this.registerTopBottomSideBlock(BlockRegistry.ABYSSALITE, "abyssalite", "abyssalite_top", "abyssalite_top");
        this.registerTopBottomSideBlock(BlockRegistry.ABYSSALITE_COAL_ORE, "abyssalite_coal_ore", "abyssalite_coal_ore_top", "abyssalite_coal_ore_top");
        this.registerTopBottomSideBlock(BlockRegistry.ABYSSALITE_LAPIS_ORE, "abyssalite_lapis_ore", "abyssalite_lapis_ore_top", "abyssalite_lapis_ore_top");
        this.registerTopBottomSideBlock(BlockRegistry.ABYSSALITE_DIAMOND_ORE, "abyssalite_diamond_ore", "abyssalite_diamond_ore_top", "abyssalite_diamond_ore_top");
        this.registerTopBottomSideBlock(BlockRegistry.ABYSSALITE_DEEP_ORE, "abyssalite_deep_ore", "abyssalite_deep_ore_top", "abyssalite_deep_ore_top");
        this.registerTopBottomSideBlock(BlockRegistry.ABYSSALITE_REDSTONE_ORE, "abyssalite_redstone_ore", "abyssalite_redstone_ore_top", "abyssalite_redstone_ore_top");
        this.registerTopBottomSideBlock(BlockRegistry.ABYSSALITE_BRICKS, "abyssalite_bricks", "abyssalite_bricks_top", "abyssalite_bricks_top");
        this.registerTopBottomSideBlock(BlockRegistry.CRACKED_ABYSSALITE_BRICKS, "cracked_abyssalite_bricks", "cracked_abyssalite_bricks_top", "cracked_abyssalite_bricks_top");
        this.registerTopBottomSideBlock(BlockRegistry.CORRUPTED_ABYSSALITE, "corrupted_abyssalite", "corrupted_abyssalite_top", "corrupted_abyssalite_top");
        this.registerCutoutBlock(BlockRegistry.SOUL_SPAWNER);
        this.registerTranslucentBlock(BlockRegistry.REINFORCED_GLASS);
        this.registerLeavesBlock(BlockRegistry.DARKTREE_LEAVES);
        this.registerLeavesBlock(BlockRegistry.WHITETREE_LEAVES);
        this.registerCrossCutoutBlock(BlockRegistry.DARKTREE_SAPLING);
        this.registerCrossCutoutBlock(BlockRegistry.WHITETREE_SAPLING);
        this.registerCrossCutoutBlock(BlockRegistry.WHITE_GRASS);
        this.registerCrossCutoutBlock(BlockRegistry.WHITE_TORCHFLOWER);
        this.registerCrossCutoutBlock(BlockRegistry.DARK_GRASS);
        this.simpleBlockWithItem((Block)BlockRegistry.POTTED_WHITE_TORCHFLOWER.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_white_torchflower", ResourceLocation.withDefaultNamespace((String)"flower_pot_cross"), "plant", this.blockTexture((Block)BlockRegistry.WHITE_TORCHFLOWER.get()))).renderType("cutout"));
        this.registerBlueBushBlock(BlockRegistry.BLUE_BUSH);
        this.registerCustomSidesDirectionalPoweredBlock(BlockRegistry.SONIC_BLASTER, "sonic_blaster_left", "sonic_blaster_right", "sonic_blaster_top", "sonic_blaster_top", "sonic_blaster_top", "sonic_blaster_front", "sonic_blaster_left_off", "sonic_blaster_left_off", "sonic_blaster_top_off", "sonic_blaster_top_off", "sonic_blaster_top_off", "sonic_blaster_front_off");
        this.registerCrossCutoutBlockWithBerries(BlockRegistry.DEPTH_VINES, "depth_vines", "depth_vines_lit");
        this.registerCrossCutoutBlockWithBerries(BlockRegistry.DEPTH_VINES_PLANT, "depth_vines_plant", "depth_vines_plant_lit");
        this.horizontalBlock((Block)BlockRegistry.GOLEM_STONE.get(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/abyssalite_bricks"), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/abyssalite_bricks"), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/golem_stone_top"));
        this.registerFromLocation(BlockRegistry.DARKTREE_WOOD, "block/darktree_log");
        this.registerFromLocation(BlockRegistry.STRIPPED_DARKTREE_WOOD, "block/stripped_darktree_log");
        this.registerFromLocation(BlockRegistry.WHITETREE_WOOD, "block/whitetree_log");
        this.registerFromLocation(BlockRegistry.STRIPPED_WHITETREE_WOOD, "block/stripped_whitetree_log");
        this.logBlock((RotatedPillarBlock)BlockRegistry.DARKTREE_LOG.get());
        this.logBlock((RotatedPillarBlock)BlockRegistry.STRIPPED_DARKTREE_LOG.get());
        this.logBlock((RotatedPillarBlock)BlockRegistry.WHITETREE_LOG.get());
        this.logBlock((RotatedPillarBlock)BlockRegistry.STRIPPED_WHITETREE_LOG.get());
        this.stairsBlock((StairBlock)BlockRegistry.DARKTREE_STAIR.get(), this.blockTexture((Block)BlockRegistry.DARKTREE_PLANKS.get()));
        this.slabBlock((SlabBlock)BlockRegistry.DARKTREE_SLAB.get(), this.blockTexture((Block)BlockRegistry.DARKTREE_PLANKS.get()), this.blockTexture((Block)BlockRegistry.DARKTREE_PLANKS.get()));
        this.buttonBlock((ButtonBlock)BlockRegistry.DARKTREE_BUTTON.get(), this.blockTexture((Block)BlockRegistry.DARKTREE_PLANKS.get()));
        this.pressurePlateBlock((PressurePlateBlock)BlockRegistry.DARKTREE_PRESSURE_PLATE.get(), this.blockTexture((Block)BlockRegistry.DARKTREE_PLANKS.get()));
        this.fenceBlock((FenceBlock)BlockRegistry.DARKTREE_FENCE.get(), this.blockTexture((Block)BlockRegistry.DARKTREE_PLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)BlockRegistry.DARKTREE_FENCE_GATE.get(), this.blockTexture((Block)BlockRegistry.DARKTREE_PLANKS.get()));
        this.doorBlockWithRenderType((DoorBlock)BlockRegistry.DARKTREE_DOOR.get(), this.modLoc("block/darktree_door_bottom"), this.modLoc("block/darktree_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)BlockRegistry.DARKTREE_TRAPDOOR.get(), this.modLoc("block/darktree_trap_door"), true, "cutout");
        this.stairsBlock((StairBlock)BlockRegistry.WHITETREE_STAIR.get(), this.blockTexture((Block)BlockRegistry.WHITETREE_PLANKS.get()));
        this.slabBlock((SlabBlock)BlockRegistry.WHITETREE_SLAB.get(), this.blockTexture((Block)BlockRegistry.WHITETREE_PLANKS.get()), this.blockTexture((Block)BlockRegistry.WHITETREE_PLANKS.get()));
        this.buttonBlock((ButtonBlock)BlockRegistry.WHITETREE_BUTTON.get(), this.blockTexture((Block)BlockRegistry.WHITETREE_PLANKS.get()));
        this.pressurePlateBlock((PressurePlateBlock)BlockRegistry.WHITETREE_PRESSURE_PLATE.get(), this.blockTexture((Block)BlockRegistry.WHITETREE_PLANKS.get()));
        this.fenceBlock((FenceBlock)BlockRegistry.WHITETREE_FENCE.get(), this.blockTexture((Block)BlockRegistry.WHITETREE_PLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)BlockRegistry.WHITETREE_FENCE_GATE.get(), this.blockTexture((Block)BlockRegistry.WHITETREE_PLANKS.get()));
        this.doorBlockWithRenderType((DoorBlock)BlockRegistry.WHITETREE_DOOR.get(), this.modLoc("block/whitetree_door_bottom"), this.modLoc("block/whitetree_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)BlockRegistry.WHITETREE_TRAPDOOR.get(), this.modLoc("block/whitetree_trap_door"), true, "cutout");
        this.stairsBlock((StairBlock)BlockRegistry.ABYSSALITE_BRICKS_STAIRS.get(), this.blockTexture((Block)BlockRegistry.ABYSSALITE_BRICKS.get()));
        this.slabBlock((SlabBlock)BlockRegistry.ABYSSALITE_BRICKS_SLAB.get(), this.blockTexture((Block)BlockRegistry.ABYSSALITE_BRICKS.get()), this.blockTexture((Block)BlockRegistry.ABYSSALITE_BRICKS.get()));
        this.wallBlock((WallBlock)BlockRegistry.ABYSSALITE_BRICKS_WALL.get(), this.blockTexture((Block)BlockRegistry.ABYSSALITE_BRICKS.get()));
        this.stairsBlock((StairBlock)BlockRegistry.CRACKED_ABYSSALITE_BRICKS_STAIR.get(), this.blockTexture((Block)BlockRegistry.CRACKED_ABYSSALITE_BRICKS.get()));
        this.slabBlock((SlabBlock)BlockRegistry.CRACKED_ABYSSALITE_BRICKS_SLAB.get(), this.blockTexture((Block)BlockRegistry.CRACKED_ABYSSALITE_BRICKS.get()), this.blockTexture((Block)BlockRegistry.CRACKED_ABYSSALITE_BRICKS.get()));
        this.wallBlock((WallBlock)BlockRegistry.CRACKED_ABYSSALITE_BRICKS_WALL.get(), this.blockTexture((Block)BlockRegistry.CRACKED_ABYSSALITE_BRICKS.get()));
    }

    private void registerCrossCutoutBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cross(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath(), this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    private void registerCutoutBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath(), this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)blockRegistryObject.get())));
    }

    public void registerBlueBushBlock(RegistryObject<Block> blockRegistryObject) {
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with(BlueBush.BERRY_STATE, (Comparable)((Object)BlueBush.BerryState.NONE)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath(), this.modLoc("block/blue_bush"))).renderType("cutout")).addModel()).partialState().with(BlueBush.BERRY_STATE, (Comparable)((Object)BlueBush.BerryState.BLUE_BERRY)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath() + "_berry", this.modLoc("block/blue_bush_berry"))).renderType("cutout")).addModel();
    }

    private void registerTranslucentBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath(), this.blockTexture((Block)blockRegistryObject.get()))).renderType("translucent"));
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)blockRegistryObject.get())));
    }

    private void registerLeavesBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath(), ResourceLocation.withDefaultNamespace((String)"block/leaves"), "all", this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    private void registerBlockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private void registerTopBottomSideBlock(RegistryObject<? extends Block> blockRegistryObject, String side, String top, String bottom) {
        ResourceLocation sideTexture = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + side));
        ResourceLocation topTexture = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + top));
        ResourceLocation bottomTexture = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + bottom));
        ModelBuilder modelFile = this.models().cubeBottomTop(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath(), sideTexture, bottomTexture, topTexture);
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)modelFile);
    }

    private void registerCustomSidesDirectionalBlock(RegistryObject<? extends Block> block, String left, String right, String top, String bottom, String back, String front) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath();
        ResourceLocation leftTex = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + left));
        ResourceLocation rightTex = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + right));
        ResourceLocation topTex = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + top));
        ResourceLocation bottomTex = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + bottom));
        ResourceLocation backTex = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + back));
        ResourceLocation frontTex = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + front));
        ModelBuilder model = ((BlockModelBuilder)this.models().cube(name, bottomTex, topTex, frontTex, backTex, leftTex, rightTex)).texture("particle", frontTex);
        this.getVariantBuilder((Block)block.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$registerCustomSidesDirectionalBlock$0((ModelFile)model, arg_0));
        this.itemModels().withExistingParent(name, this.modLoc("block/" + name));
    }

    private void registerCrossCutoutBlockWithBerries(RegistryObject<Block> blockRegistryObject, String noBerriesTexture, String berriesTexture) {
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)BlockStateProperties.BERRIES, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath(), this.modLoc("block/" + noBerriesTexture))).renderType("cutout")).addModel()).partialState().with((Property)BlockStateProperties.BERRIES, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath() + "_berries", this.modLoc("block/" + berriesTexture))).renderType("cutout")).addModel();
    }

    private void registerCustomSidesDirectionalPoweredBlock(RegistryObject<? extends Block> block, String left, String right, String top, String bottom, String back, String front, String left_off, String right_off, String top_off, String bottom_off, String back_off, String front_off) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath();
        ResourceLocation leftTex = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + left));
        ResourceLocation rightTex = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + right));
        ResourceLocation topTex = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + top));
        ResourceLocation bottomTex = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + bottom));
        ResourceLocation backTex = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + back));
        ResourceLocation frontTex = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + front));
        ResourceLocation leftTex_off = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + left_off));
        ResourceLocation rightTex_off = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + right_off));
        ResourceLocation topTex_off = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + top_off));
        ResourceLocation bottomTex_off = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + bottom_off));
        ResourceLocation backTex_off = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + back_off));
        ResourceLocation frontTex_off = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + front_off));
        ModelBuilder model = ((BlockModelBuilder)this.models().cube(name, bottomTex, topTex, frontTex, backTex, leftTex, rightTex)).texture("particle", frontTex);
        ModelBuilder model_off = ((BlockModelBuilder)this.models().cube(name + "_off", bottomTex_off, topTex_off, frontTex_off, backTex_off, leftTex_off, rightTex_off)).texture("particle", frontTex_off);
        this.getVariantBuilder((Block)block.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$registerCustomSidesDirectionalPoweredBlock$1((ModelFile)model, (ModelFile)model_off, arg_0));
        this.itemModels().withExistingParent(name, this.modLoc("block/" + name));
    }

    private void registerFromLocation(RegistryObject<Block> blockRegistryObject, String location) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)this.models().cubeAll(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)location)));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerCustomSidesDirectionalPoweredBlock$1(ModelFile model, ModelFile model_off, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        boolean powered = (Boolean)state.getValue((Property)BlockStateProperties.POWERED);
        int xRot = 0;
        int yRot = 0;
        switch (facing) {
            case DOWN: {
                xRot = 90;
                break;
            }
            case UP: {
                xRot = -90;
                break;
            }
            case NORTH: {
                yRot = 0;
                break;
            }
            case SOUTH: {
                yRot = 180;
                break;
            }
            case WEST: {
                yRot = 270;
                break;
            }
            case EAST: {
                yRot = 90;
            }
        }
        return ConfiguredModel.builder().modelFile(powered ? model : model_off).rotationX(xRot).rotationY(yRot).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerCustomSidesDirectionalBlock$0(ModelFile model, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        int xRot = 0;
        int yRot = 0;
        switch (facing) {
            case DOWN: {
                xRot = 90;
                break;
            }
            case UP: {
                xRot = -90;
                break;
            }
            case NORTH: {
                yRot = 0;
                break;
            }
            case SOUTH: {
                yRot = 180;
                break;
            }
            case WEST: {
                yRot = 270;
                break;
            }
            case EAST: {
                yRot = 90;
            }
        }
        return ConfiguredModel.builder().modelFile(model).rotationX(xRot).rotationY(yRot).build();
    }
}

