/*
 * Decompiled with CFR 0.152.
 */
package wardentools.datagen;

import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import wardentools.block.BlockRegistry;
import wardentools.items.ItemRegistry;
import wardentools.items.armors.ArmorRegistry;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "wardentools", existingFileHelper);
    }

    protected void registerModels() {
        this.trimmedArmorItem(ArmorRegistry.DEEPCRISTAL_HELMET);
        this.trimmedArmorItem(ArmorRegistry.DEEPCRISTAL_CHESTPLATE);
        this.trimmedArmorItem(ArmorRegistry.DEEPCRISTAL_LEGGINGS);
        this.trimmedArmorItem(ArmorRegistry.DEEPCRISTAL_BOOTS);
        this.trimmedArmorItem(ArmorRegistry.RADIANCE_CRISTAL_HELMET);
        this.trimmedArmorItem(ArmorRegistry.RADIANCE_CRISTAL_CHESTPLATE);
        this.trimmedArmorItem(ArmorRegistry.RADIANCE_CRISTAL_LEGGINGS);
        this.trimmedArmorItem(ArmorRegistry.RADIANCE_CRISTAL_BOOTS);
        this.simpleItem(ItemRegistry.DEEPINGOTS);
        this.simpleItem(ItemRegistry.WARDEN_HEART);
        this.simpleItem(ItemRegistry.DEEP_FRUIT);
        this.simpleItem(ItemRegistry.WIND_WHISPERER);
        this.simpleItem(ItemRegistry.RADIANCE_FRAGMENT);
        this.simpleItem(ItemRegistry.CORRUPTED_ESSENCE);
        this.simpleItem(ItemRegistry.CORRUPTED_VESSEL);
        this.simpleItem(ItemRegistry.DARK_STICK);
        this.simpleItem(ItemRegistry.PURE_ESSENCE);
        this.simpleItem(ItemRegistry.WHITE_SEED);
        this.simpleItem(ItemRegistry.RADIANT_CORE);
        this.simpleItem(ItemRegistry.PURE_VESSEL);
        this.simpleItem(ItemRegistry.PROTECTOR_HEART);
        this.simpleItem(ItemRegistry.DYING_PROTECTOR_HEART);
        this.simpleItem(ItemRegistry.DARKTREE_BOAT);
        this.simpleItem(ItemRegistry.DARKTREE_CHEST_BOAT);
        this.simpleItem(ItemRegistry.WHITETREE_BOAT);
        this.simpleItem(ItemRegistry.WHITETREE_CHEST_BOAT);
        this.simpleItem(ItemRegistry.DEEP_FRAGMENT);
        this.simpleItem(ItemRegistry.CITRINE_FRAGMENT);
        this.simpleItem(ItemRegistry.RUBY_FRAGMENT);
        this.simpleItem(ItemRegistry.MALACHITE_FRAGMENT);
        this.simpleItem(ItemRegistry.PALE_SHARD);
        this.simpleItem(ItemRegistry.RADIANCE_INGOTS);
        this.simpleItem(ItemRegistry.BLUE_GLOW_BERRIES);
        this.simpleItem(ItemRegistry.NOCTILURE_TREAT);
        this.simpleItem(ItemRegistry.ABYSS_MUSIC_DISC);
        this.simpleItem(ItemRegistry.DEEP_FOREST_MUSIC_DISC);
        this.simpleItem(ItemRegistry.WHITE_FOREST_MUSIC_DISC);
        this.simpleItem(ItemRegistry.INCARNATION_MUSIC_DISC);
        this.simpleItem(ItemRegistry.REFLECTION_MUSIC_DISC);
        this.simpleItem(ItemRegistry.WIND_JOURNAL);
        this.simpleItem(ItemRegistry.NOCTILURE_FEATHER);
        this.simpleItem(ItemRegistry.DEPTH_BERRIES);
        this.simpleItem(ItemRegistry.WANDERER_PAW);
        this.simpleItem(ItemRegistry.LURKER_EYE);
        this.simpleItem(ItemRegistry.MIND_TIARA);
        this.simpleItem(ItemRegistry.RING_OF_WILL);
        this.simpleItem(ItemRegistry.STRENGTH_BRACELET);
        this.simpleItem(ItemRegistry.PENDANT_OF_BALANCE);
        this.simpleItem(ItemRegistry.SHADOW_ORNAMENT);
        this.simpleItem(ItemRegistry.LIGHT_ORNAMENT);
        this.simpleItem(ItemRegistry.ANCIENT_CITADEL_MAP);
        this.blockItemWithItemModel(BlockRegistry.BLUE_BUSH);
        this.blockItemWithItemModel(BlockRegistry.DEEP_CRISTAL);
        this.blockItemWithItemModel(BlockRegistry.RADIANCE_CRISTAL);
        this.blockItemWithItemModel(BlockRegistry.DARKTREE_SAPLING);
        this.blockItemWithItemModel(BlockRegistry.DARKTREE_DOOR);
        this.blockItemWithItemModel(BlockRegistry.WHITETREE_SAPLING);
        this.blockItemWithItemModel(BlockRegistry.WHITETREE_DOOR);
        this.blockItemWithItemModel(BlockRegistry.WHITE_GRASS);
        this.blockItemWithItemModel(BlockRegistry.TALL_WHITE_GRASS);
        this.blockItemWithItemModel(BlockRegistry.WHITE_TORCHFLOWER);
        this.blockItemWithItemModel(BlockRegistry.DEEPFLOWER);
        this.blockItemWithItemModel(BlockRegistry.TALL_DARK_GRASS);
        this.blockItemWithItemModel(BlockRegistry.DARK_GRASS);
        this.blockItemWithItemModel(BlockRegistry.PROTECTOR_INVOKER);
        this.blockItemWithItemModel(BlockRegistry.CITRINE);
        this.blockItemWithItemModel(BlockRegistry.ECHO_CRISTAL);
        this.blockItemWithItemModel(BlockRegistry.RUBY);
        this.blockItemWithItemModel(BlockRegistry.MALACHITE);
        this.blockItemWithItemModel(BlockRegistry.PALE_CRISTAL);
        this.blockItemWithItemModel(BlockRegistry.CONTAGION_INCARNATION_SKULL);
        this.blockItemWithItemModel(BlockRegistry.GRAMOPHONE);
        this.withExistingParent(BlockRegistry.DARKTREE_WOOD.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/darktree_wood"));
        this.withExistingParent(BlockRegistry.STRIPPED_DARKTREE_WOOD.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/stripped_darktree_wood"));
        this.withExistingParent(BlockRegistry.STRIPPED_DARKTREE_LOG.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/stripped_darktree_log"));
        this.withExistingParent(BlockRegistry.DARKTREE_LOG.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/darktree_log"));
        this.withExistingParent(BlockRegistry.DARKTREE_STAIR.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/darktree_stair"));
        this.withExistingParent(BlockRegistry.DARKTREE_SLAB.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/darktree_slab"));
        this.withExistingParent(BlockRegistry.DARKTREE_PRESSURE_PLATE.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/darktree_pressure_plate"));
        this.withExistingParent(BlockRegistry.DARKTREE_FENCE_GATE.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/darktree_fence_gate"));
        this.withExistingParent(BlockRegistry.WHITETREE_WOOD.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/whitetree_wood"));
        this.withExistingParent(BlockRegistry.STRIPPED_WHITETREE_WOOD.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/stripped_whitetree_wood"));
        this.withExistingParent(BlockRegistry.STRIPPED_WHITETREE_LOG.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/stripped_whitetree_log"));
        this.withExistingParent(BlockRegistry.WHITETREE_LOG.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/whitetree_log"));
        this.withExistingParent(BlockRegistry.WHITETREE_STAIR.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/whitetree_stair"));
        this.withExistingParent(BlockRegistry.WHITETREE_SLAB.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/whitetree_slab"));
        this.withExistingParent(BlockRegistry.WHITETREE_PRESSURE_PLATE.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/whitetree_pressure_plate"));
        this.withExistingParent(BlockRegistry.WHITETREE_FENCE_GATE.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/whitetree_fence_gate"));
        this.withExistingParent(BlockRegistry.RADIANCE_CATALYST.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/radiance_catalyst"));
        this.withExistingParent(BlockRegistry.CHISELED_ABYSSALITE.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/chiseled_abyssalite"));
        this.withExistingParent(BlockRegistry.ABYSSALITE_BRICKS_STAIRS.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/abyssalite_bricks_stair"));
        this.withExistingParent(BlockRegistry.ABYSSALITE_BRICKS_SLAB.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/abyssalite_bricks_slab"));
        this.withExistingParent(BlockRegistry.DYSFUNCTIONNING_CATALYST.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/dysfunctionning_catalyst"));
        this.withExistingParent(BlockRegistry.BLACK_LANTERN.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/black_lantern"));
        this.withExistingParent(BlockRegistry.CRACKED_ABYSSALITE_BRICKS_STAIR.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/cracked_abyssalite_bricks_stair"));
        this.withExistingParent(BlockRegistry.CRACKED_ABYSSALITE_BRICKS_SLAB.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/cracked_abyssalite_bricks_slab"));
        this.withExistingParent(BlockRegistry.LIVING_SPROUT.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/living_sprout"));
        this.withExistingParent(BlockRegistry.CRYSTAL_INFUSER.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/crystal_infuser"));
        this.withExistingParent(BlockRegistry.GOLEM_STONE.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"block/golem_stone"));
        this.fenceItem(BlockRegistry.DARKTREE_FENCE, BlockRegistry.DARKTREE_PLANKS);
        this.buttonItem(BlockRegistry.DARKTREE_BUTTON, BlockRegistry.DARKTREE_PLANKS);
        this.trapdoorItem(BlockRegistry.DARKTREE_TRAPDOOR);
        this.fenceItem(BlockRegistry.WHITETREE_FENCE, BlockRegistry.WHITETREE_PLANKS);
        this.buttonItem(BlockRegistry.WHITETREE_BUTTON, BlockRegistry.WHITETREE_PLANKS);
        this.trapdoorItem(BlockRegistry.WHITETREE_TRAPDOOR);
        this.wallItem(BlockRegistry.ABYSSALITE_BRICKS_WALL, BlockRegistry.ABYSSALITE_BRICKS);
        this.wallItem(BlockRegistry.CRACKED_ABYSSALITE_BRICKS_WALL, BlockRegistry.CRACKED_ABYSSALITE_BRICKS);
    }

    private <T extends Block> void blockItemWithItemModel(RegistryObject<T> item) {
        ((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("item/" + item.getId().getPath())));
    }

    private void simpleItem(RegistryObject<Item> item) {
        ((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("item/" + item.getId().getPath())));
    }

    public void trapdoorItem(RegistryObject<Block> block) {
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath() + "_bottom"));
    }

    public void fenceItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.mcLoc("block/fence_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).getPath())));
    }

    public void buttonItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.mcLoc("block/button_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).getPath())));
    }

    public void wallItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).getPath())));
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "wardentools";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.forEach((trimMaterial, value) -> {
                float trimValue = value.floatValue();
                String armorType = switch (armorItem.getEquipmentSlot()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = armorItem.toString();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.parse((String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.parse((String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath())).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc.getNamespace() + ":item/" + trimNameResLoc.getPath())).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)("item/" + itemRegistryObject.getId().getPath())));
            });
        }
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

