/*
 * Decompiled with CFR 0.152.
 */
package wardentools.datagen.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import wardentools.items.enchantment.EnchantmentRegistry;

public class AddStealthBookModifier
extends LootModifier
implements IGlobalLootModifier {
    public static final MapCodec<AddStealthBookModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> AddStealthBookModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, AddStealthBookModifier::new));

    public AddStealthBookModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.getRandom().nextFloat() < 0.5f) {
            ItemStack enchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            Holder.Reference stealthEnchantment = context.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(EnchantmentRegistry.STEALTH);
            enchantedBook.enchant((Holder)stealthEnchantment, 1);
            generatedLoot.add((Object)enchantedBook);
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

