/*
 * Decompiled with CFR 0.152.
 */
package wardentools.datagen.loot;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wardentools.items.ItemRegistry;

@Mod.EventBusSubscriber(modid="wardentools")
public class LootTableModifiers {
    private static final ResourceLocation wardenLootTable = ResourceLocation.withDefaultNamespace((String)"entities/warden");

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)wardenLootTable)) {
            LootTableModifiers.addToWardenLootTable(event.getTable());
        }
    }

    private static void addToWardenLootTable(LootTable table) {
        LootPool.Builder poolBuilder1 = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.WARDEN_HEART.get())).setWeight(7)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(3));
        LootPool.Builder poolBuilder2 = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.DEEPBLOCK.get())).setWeight(5)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(5));
        LootPool.Builder poolBuilder3 = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.DEEPCRISTAL.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))));
        table.addPool(poolBuilder1.build());
        table.addPool(poolBuilder2.build());
        table.addPool(poolBuilder3.build());
    }
}

