/*
 * Decompiled with CFR 0.152.
 */
package wardentools.datagen.loot;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;
import wardentools.block.BlueBush;
import wardentools.items.ItemRegistry;

public class ModBlockLootTables
extends BlockLootSubProvider {
    public ModBlockLootTables(HolderLookup.Provider lookupProvider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), lookupProvider);
    }

    protected void generate() {
        this.addDropSelf(BlockRegistry.DEEPBLOCK);
        this.addDropSelf(BlockRegistry.DARKDIRT);
        this.addDropSelf(BlockRegistry.DARKGRASS_BLOCK);
        this.addDropSelf(BlockRegistry.ABYSSALITE);
        this.addDropSelf(BlockRegistry.CHISELED_ABYSSALITE);
        this.addDropSelf(BlockRegistry.ABYSSALITE_BRICKS);
        this.addDropSelf(BlockRegistry.ABYSSALITE_BRICKS_STAIRS);
        this.addDropSelf(BlockRegistry.ABYSSALITE_BRICKS_SLAB);
        this.addDropSelf(BlockRegistry.ABYSSALITE_BRICKS_WALL);
        this.addDropSelf(BlockRegistry.CRACKED_ABYSSALITE_BRICKS);
        this.addDropSelf(BlockRegistry.CRACKED_ABYSSALITE_BRICKS_STAIR);
        this.addDropSelf(BlockRegistry.CRACKED_ABYSSALITE_BRICKS_WALL);
        this.addDropSelf(BlockRegistry.PALE_CRISTAL_BLOCK);
        this.addDropSelf(BlockRegistry.CITRINE_BLOCK);
        this.addDropSelf(BlockRegistry.ECHO_BLOCK);
        this.addDropSelf(BlockRegistry.RUBY_BLOCK);
        this.addDropSelf(BlockRegistry.MALACHITE_BLOCK);
        this.addDropSelf(BlockRegistry.SOLID_CORRUPTION);
        this.addDropSelf(BlockRegistry.WIND_WHISPERER);
        this.addDropSelf(BlockRegistry.DARKTREE_LOG);
        this.addDropSelf(BlockRegistry.DARKTREE_PLANKS);
        this.addDropSelf(BlockRegistry.DARKTREE_SAPLING);
        this.addDropSelf(BlockRegistry.DARKTREE_WOOD);
        this.addDropSelf(BlockRegistry.STRIPPED_DARKTREE_LOG);
        this.addDropSelf(BlockRegistry.STRIPPED_DARKTREE_WOOD);
        this.addDropSelf(BlockRegistry.DARKTREE_STAIR);
        this.addDropSelf(BlockRegistry.DARKTREE_BUTTON);
        this.addDropSelf(BlockRegistry.DARKTREE_PRESSURE_PLATE);
        this.addDropSelf(BlockRegistry.DARKTREE_FENCE);
        this.addDropSelf(BlockRegistry.DARKTREE_FENCE_GATE);
        this.addDropSelf(BlockRegistry.DARKTREE_TRAPDOOR);
        this.addDropSelf(BlockRegistry.WHITETREE_LOG);
        this.addDropSelf(BlockRegistry.WHITETREE_SAPLING);
        this.addDropSelf(BlockRegistry.WHITETREE_WOOD);
        this.addDropSelf(BlockRegistry.STRIPPED_WHITETREE_LOG);
        this.addDropSelf(BlockRegistry.STRIPPED_WHITETREE_WOOD);
        this.addDropSelf(BlockRegistry.WHITETREE_PLANKS);
        this.addDropSelf(BlockRegistry.WHITETREE_STAIR);
        this.addDropSelf(BlockRegistry.WHITETREE_BUTTON);
        this.addDropSelf(BlockRegistry.WHITETREE_PRESSURE_PLATE);
        this.addDropSelf(BlockRegistry.WHITETREE_FENCE);
        this.addDropSelf(BlockRegistry.WHITETREE_FENCE_GATE);
        this.addDropSelf(BlockRegistry.WHITETREE_TRAPDOOR);
        this.addDropSelf(BlockRegistry.WHITE_TORCHFLOWER);
        this.addDropSelf(BlockRegistry.PROTECTOR_INVOKER);
        this.addDropSelf(BlockRegistry.CONTAGION_INCARNATION_SKULL);
        this.addDropSelf(BlockRegistry.GRAMOPHONE);
        this.addDropSelf(BlockRegistry.SONIC_BLASTER);
        this.addDropSelf(BlockRegistry.CORRUPTED_ABYSSALITE);
        this.add((Block)BlockRegistry.LIVING_SPROUT.get(), this.createSilkTouchOnlyTable((ItemLike)BlockRegistry.LIVING_SPROUT.get()));
        this.add((Block)BlockRegistry.SCULK_TENDRIL_BLOCK.get(), this.createSilkTouchOnlyTable((ItemLike)BlockRegistry.SCULK_TENDRIL_BLOCK.get()));
        this.add((Block)BlockRegistry.DARKTREE_SLAB.get(), block -> this.createSlabItemTable((Block)BlockRegistry.DARKTREE_SLAB.get()));
        this.add((Block)BlockRegistry.DARKTREE_DOOR.get(), block -> this.createDoorTable((Block)BlockRegistry.DARKTREE_DOOR.get()));
        this.add((Block)BlockRegistry.WHITETREE_SLAB.get(), block -> this.createSlabItemTable((Block)BlockRegistry.WHITETREE_SLAB.get()));
        this.add((Block)BlockRegistry.WHITETREE_DOOR.get(), block -> this.createDoorTable((Block)BlockRegistry.WHITETREE_DOOR.get()));
        this.add((Block)BlockRegistry.CRACKED_ABYSSALITE_BRICKS_SLAB.get(), block -> this.createSlabItemTable((Block)BlockRegistry.CRACKED_ABYSSALITE_BRICKS_SLAB.get()));
        this.add((Block)BlockRegistry.TALL_WHITE_GRASS.get(), block -> this.createDoublePlantShearsDrop((Block)BlockRegistry.WHITE_GRASS.get()));
        this.add((Block)BlockRegistry.WHITE_GRASS.get(), block -> ModBlockLootTables.createShearsOnlyDrop((ItemLike)((ItemLike)BlockRegistry.WHITE_GRASS.get())));
        this.add((Block)BlockRegistry.DEEPFLOWER.get(), block -> this.createDoubleBlockSingleItemDrop(ItemRegistry.DEEPFLOWER));
        this.add((Block)BlockRegistry.TALL_DARK_GRASS.get(), block -> this.createDoublePlantShearsDrop((Block)BlockRegistry.DARK_GRASS.get()));
        this.add((Block)BlockRegistry.DARK_GRASS.get(), block -> ModBlockLootTables.createShearsOnlyDrop((ItemLike)((ItemLike)BlockRegistry.DARK_GRASS.get())));
        this.add((Block)BlockRegistry.ABYSSALITE_COAL_ORE.get(), block -> this.createOreDrop((Block)BlockRegistry.ABYSSALITE_COAL_ORE.get(), Items.COAL));
        this.add((Block)BlockRegistry.ABYSSALITE_LAPIS_ORE.get(), block -> this.createLapisOreDrops((Block)BlockRegistry.ABYSSALITE_LAPIS_ORE.get()));
        this.add((Block)BlockRegistry.ABYSSALITE_DIAMOND_ORE.get(), block -> this.createOreDrop((Block)BlockRegistry.ABYSSALITE_DIAMOND_ORE.get(), Items.DIAMOND));
        this.add((Block)BlockRegistry.ABYSSALITE_DEEP_ORE.get(), block -> this.createNumberBasedOreDrop((Block)BlockRegistry.ABYSSALITE_DEEP_ORE.get(), (ItemLike)ItemRegistry.DEEP_FRAGMENT.get(), 1.0f, 3.0f));
        this.add((Block)BlockRegistry.ABYSSALITE_REDSTONE_ORE.get(), block -> this.createRedstoneOreDrops((Block)BlockRegistry.ABYSSALITE_REDSTONE_ORE.get()));
        this.add((Block)BlockRegistry.CITRINE.get(), block -> this.cristalLoot((Block)BlockRegistry.CITRINE.get(), (ItemLike)ItemRegistry.CITRINE_FRAGMENT.get()));
        this.add((Block)BlockRegistry.ECHO_CRISTAL.get(), block -> this.cristalLoot((Block)BlockRegistry.ECHO_CRISTAL.get(), (ItemLike)Items.ECHO_SHARD));
        this.add((Block)BlockRegistry.RUBY.get(), block -> this.cristalLoot((Block)BlockRegistry.RUBY.get(), (ItemLike)ItemRegistry.RUBY_FRAGMENT.get()));
        this.add((Block)BlockRegistry.MALACHITE.get(), block -> this.cristalLoot((Block)BlockRegistry.MALACHITE.get(), (ItemLike)ItemRegistry.MALACHITE_FRAGMENT.get()));
        this.add((Block)BlockRegistry.PALE_CRISTAL.get(), block -> this.cristalLoot((Block)BlockRegistry.PALE_CRISTAL.get(), (ItemLike)ItemRegistry.PALE_SHARD.get()));
        this.add((Block)BlockRegistry.DEEP_CRISTAL.get(), block -> this.cristalLoot((Block)BlockRegistry.DEEP_CRISTAL.get(), (ItemLike)ItemRegistry.DEEP_FRAGMENT.get()));
        this.add((Block)BlockRegistry.RADIANCE_CRISTAL.get(), block -> this.cristalLoot((Block)BlockRegistry.RADIANCE_CRISTAL.get(), (ItemLike)ItemRegistry.RADIANCE_FRAGMENT.get()));
        this.add((Block)BlockRegistry.DARKTREE_LEAVES.get(), block -> this.createCustomLeaveDrop((Block)BlockRegistry.DARKTREE_LEAVES.get(), (Block)BlockRegistry.DARKTREE_SAPLING.get(), (ItemLike)ItemRegistry.DEEP_FRUIT.get(), 0.05f));
        this.add((Block)BlockRegistry.WHITETREE_LEAVES.get(), block -> this.createCustomLeaveDrop((Block)BlockRegistry.WHITETREE_LEAVES.get(), (Block)BlockRegistry.WHITETREE_SAPLING.get(), (ItemLike)ItemRegistry.WHITE_SEED.get(), 0.05f));
        this.add((Block)BlockRegistry.POTTED_WHITE_TORCHFLOWER.get(), this.createPotFlowerItemTable((ItemLike)BlockRegistry.WHITE_TORCHFLOWER.get()));
        this.add((Block)BlockRegistry.BLACK_LANTERN.get(), block -> this.createBlackLanternItemDrop(BlockRegistry.BLACK_LANTERN));
        this.add((Block)BlockRegistry.REINFORCED_GLASS.get(), block -> this.createReinforcedGlassItemDrop(BlockRegistry.REINFORCED_GLASS));
        this.add((Block)BlockRegistry.BLUE_BUSH.get(), block -> this.createBlueBushLoot(BlockRegistry.BLUE_BUSH, ItemRegistry.BLUE_GLOW_BERRIES));
    }

    private void addDropSelf(RegistryObject<Block> block) {
        if (block.isPresent()) {
            this.dropSelf((Block)block.get());
        }
    }

    private LootTable.Builder createDoubleBlockSingleItemDrop(RegistryObject<Item> item) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)item.get())).when(LootItemRandomChanceCondition.randomChance((float)0.5f))));
    }

    private LootTable.Builder createBlueBushLoot(RegistryObject<Block> bushBlock, RegistryObject<Item> berryItem) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)bushBlock.get()))).when(HAS_SHEARS)).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)berryItem.get()))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)bushBlock.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(BlueBush.BERRY_STATE, (Comparable)((Object)BlueBush.BerryState.BLUE_BERRY)))));
    }

    private LootTable.Builder createBlackLanternItemDrop(RegistryObject<Block> block) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)block.get())).when(this.hasSilkTouch()))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.PALE_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))).when(this.doesNotHaveSilkTouch()))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ECHO_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))).when(this.doesNotHaveSilkTouch()));
    }

    private LootTable.Builder createReinforcedGlassItemDrop(RegistryObject<Block> block) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)block.get())).when(this.hasSilkTouch()))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.PALE_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))).when(this.doesNotHaveSilkTouch())).add(LootItem.lootTableItem((ItemLike)Items.ECHO_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))).when(this.doesNotHaveSilkTouch()))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_NUGGET).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))).when(this.doesNotHaveSilkTouch()));
    }

    protected LootTable.Builder createNumberBasedOreDrop(Block block, ItemLike drop, float min, float max) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)drop).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    private LootTable.Builder cristalLoot(Block block, ItemLike cristal) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)cristal).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createCustomLeaveDrop(Block leave, Block sapling, ItemLike fruit, float ... f) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createLeavesDrops(leave, sapling, f).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)leave, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)fruit))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    private LootItemCondition.Builder hasShearsOrSilkTouch() {
        return HAS_SHEARS.or(this.hasSilkTouch());
    }

    private LootItemCondition.Builder doesNotHaveShearsOrSilkTouch() {
        return this.hasShearsOrSilkTouch().invert();
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        Set<Block> blocksToIgnore = Set.of((Block)BlockRegistry.RADIANCE_CATALYST.get(), (Block)BlockRegistry.LIQUID_CORRUPTION_BLOCK.get(), (Block)BlockRegistry.ABYSS_PORTAL_BLOCK.get(), (Block)BlockRegistry.DYSFUNCTIONNING_CATALYST.get(), (Block)BlockRegistry.SOUL_SPAWNER.get(), (Block)BlockRegistry.DEPTH_VINES.get(), (Block)BlockRegistry.DEPTH_VINES_PLANT.get());
        List<Block> knownBlocks = BlockRegistry.REGISTAR.getEntries().stream().map(RegistryObject::get).filter(block -> !blocksToIgnore.contains(block)).collect(Collectors.toList());
        return knownBlocks;
    }
}

