/*
 * Decompiled with CFR 0.152.
 */
package wardentools.effect;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import wardentools.effect.ModEffects;
import wardentools.misc.CustomDamageType;

public class CorruptedEffect
extends MobEffect {
    protected CorruptedEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(@NotNull LivingEntity entity, int amplifier) {
        if (ModEffects.PURIFIED.getHolder().isPresent() && entity.hasEffect((Holder)ModEffects.PURIFIED.getHolder().get())) {
            return super.applyEffectTick(entity, amplifier);
        }
        Holder.Reference corruptedDamageHolder = entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(CustomDamageType.CORRUPTED_KEY);
        entity.hurt(new DamageSource((Holder)corruptedDamageHolder, null, (Entity)entity, null), (float)(1 + amplifier));
        return super.applyEffectTick(entity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }
}

