/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import wardentools.block.BlockRegistry;
import wardentools.entity.client.ContagionIncarnation;
import wardentools.entity.client.ContagionIncarnationEmissiveLayer;
import wardentools.entity.client.ContagionIncarnationShellLayer;
import wardentools.entity.custom.ContagionIncarnationEntity;
import wardentools.particle.ParticleRegistry;

public class ContagionIncarnationRenderer
extends MobRenderer<ContagionIncarnationEntity, ContagionIncarnation> {
    private static final ResourceLocation CONTAGION_INCARNATION_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/entity/contagion_incarnation/contagion_incarnation.png");
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private static final float PARTICLE_DEATH_RADIUS = 2.0f;
    private static final float PARTICLE_SPAWN_RADIUS = 4.0f;
    private static final BlockParticleOption SOLID_CORRUPTION_PARTICLE = new BlockParticleOption(ParticleTypes.BLOCK, ((Block)BlockRegistry.SOLID_CORRUPTION.get()).defaultBlockState());

    public ContagionIncarnationRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ContagionIncarnation(context.bakeLayer(ContagionIncarnation.LAYER_LOCATION)), 3.0f);
        this.addLayer(new ContagionIncarnationShellLayer((RenderLayerParent<ContagionIncarnationEntity, ContagionIncarnation>)this));
        this.addLayer(new ContagionIncarnationEmissiveLayer((RenderLayerParent<ContagionIncarnationEntity, ContagionIncarnation>)this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ContagionIncarnationEntity pEntity) {
        return CONTAGION_INCARNATION_TEXTURE;
    }

    public void render(ContagionIncarnationEntity pEntity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        if (pEntity.getTickSpawn() >= 149) {
            return;
        }
        int blockLight = pPackedLight >> 4 & 0xF;
        int skyLight = pPackedLight >> 20 & 0xF;
        float reductionFactor = (200.0f - (float)pEntity.contagionIncarnationDeathTime) / 200.0f;
        int decreasingBlockLight = (int)((float)blockLight * reductionFactor);
        int decreasingSkyLight = (int)((float)skyLight * reductionFactor);
        int decreasingLight = LightTexture.pack((int)decreasingSkyLight, (int)decreasingBlockLight);
        super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, decreasingLight);
        this.deathLightEffect(pEntity, pPartialTicks, pMatrixStack, pBuffer);
        this.deathParticleEffect(pEntity);
        this.spawnParticleEffect(pEntity);
    }

    private void spawnParticleEffect(ContagionIncarnationEntity entity) {
        if (entity.getTickSpawn() > 75) {
            double centerX = entity.getX();
            double centerY = entity.getY() + (double)entity.getBbHeight() / 2.0;
            double centerZ = entity.getZ();
            int particleCount = 30;
            for (int j = 0; j < particleCount; ++j) {
                double x = centerX + (double)(4.0f * (entity.getRandom().nextFloat() - 0.5f));
                double y = centerY + (double)(4.0f * (entity.getRandom().nextFloat() - 0.5f));
                double z = centerZ + (double)(4.0f * (entity.getRandom().nextFloat() - 0.5f));
                entity.level().addParticle((ParticleOptions)SOLID_CORRUPTION_PARTICLE, x, y, z, 0.0, 0.1, 0.0);
            }
        }
    }

    private void deathParticleEffect(ContagionIncarnationEntity entity) {
        if ((float)entity.contagionIncarnationDeathTime > 180.0f) {
            double centerX = entity.getX();
            double centerY = entity.getY() + (double)entity.getBbHeight() / 2.0;
            double centerZ = entity.getZ();
            int particleCount = 100;
            for (int j = 0; j < particleCount; ++j) {
                double theta = Math.PI * 2 * entity.getRandom().nextDouble();
                double phi = Math.acos(2.0 * entity.getRandom().nextDouble() - 1.0);
                double x = centerX + 2.0 * Math.sin(phi) * Math.cos(theta);
                double y = centerY + 2.0 * Math.sin(phi) * Math.sin(theta);
                double z = centerZ + 2.0 * Math.cos(phi);
                double norm = Math.sqrt((x - centerX) * (x - centerX) + (y - centerY) * (y - centerY) + (z - centerZ) * (z - centerZ));
                entity.level().addParticle((ParticleOptions)ParticleRegistry.CORRUPTION.get(), x, y, z, (x - centerX) / norm, (y - centerY) / norm, (z - centerZ) / norm);
            }
        } else if (entity.contagionIncarnationDeathTime > 0) {
            double centerX = entity.getX();
            double centerY = entity.getY() + (double)entity.getBbHeight() / 2.0;
            double centerZ = entity.getZ();
            double theta = Math.PI * 2 * entity.getRandom().nextDouble();
            double phi = Math.acos(2.0 * entity.getRandom().nextDouble() - 1.0);
            double x = centerX + 6.0 * Math.sin(phi) * Math.cos(theta);
            double y = centerY + 6.0 * Math.sin(phi) * Math.sin(theta);
            double z = centerZ + 6.0 * Math.cos(phi);
            double norm = Math.sqrt((x - centerX) * (x - centerX) + (y - centerY) * (y - centerY) + (z - centerZ) * (z - centerZ));
            entity.level().addParticle((ParticleOptions)ParticleRegistry.CORRUPTION.get(), x, y, z, -(x - centerX) / norm, -(y - centerY) / norm, -(z - centerZ) / norm);
        }
    }

    private void deathLightEffect(ContagionIncarnationEntity pEntity, float pPartialTicks, PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer) {
        if (pEntity.contagionIncarnationDeathTime > 0) {
            float f5 = ((float)pEntity.contagionIncarnationDeathTime + pPartialTicks) / 200.0f;
            float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
            RandomSource randomsource = RandomSource.create((long)432L);
            VertexConsumer vertexconsumer2 = pBuffer.getBuffer(RenderType.lightning());
            pMatrixStack.pushPose();
            pMatrixStack.translate(0.0f, 1.0f, 0.0f);
            int i = 0;
            while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
                pMatrixStack.mulPose(Axis.XP.rotationDegrees(randomsource.nextFloat() * 360.0f));
                pMatrixStack.mulPose(Axis.YP.rotationDegrees(randomsource.nextFloat() * 360.0f));
                pMatrixStack.mulPose(Axis.ZP.rotationDegrees(randomsource.nextFloat() * 360.0f));
                pMatrixStack.mulPose(Axis.XP.rotationDegrees(randomsource.nextFloat() * 360.0f));
                pMatrixStack.mulPose(Axis.YP.rotationDegrees(randomsource.nextFloat() * 360.0f));
                pMatrixStack.mulPose(Axis.ZP.rotationDegrees(randomsource.nextFloat() * 360.0f + f5 * 90.0f));
                float f3 = randomsource.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
                float f4 = randomsource.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
                Matrix4f matrix4f = pMatrixStack.last().pose();
                int j = (int)(255.0f * (1.0f - f7));
                ContagionIncarnationRenderer.vertex01(vertexconsumer2, matrix4f, j);
                ContagionIncarnationRenderer.vertex2(vertexconsumer2, matrix4f, f3, f4);
                ContagionIncarnationRenderer.vertex3(vertexconsumer2, matrix4f, f3, f4);
                ContagionIncarnationRenderer.vertex01(vertexconsumer2, matrix4f, j);
                ContagionIncarnationRenderer.vertex3(vertexconsumer2, matrix4f, f3, f4);
                ContagionIncarnationRenderer.vertex4(vertexconsumer2, matrix4f, f3, f4);
                ContagionIncarnationRenderer.vertex01(vertexconsumer2, matrix4f, j);
                ContagionIncarnationRenderer.vertex4(vertexconsumer2, matrix4f, f3, f4);
                ContagionIncarnationRenderer.vertex2(vertexconsumer2, matrix4f, f3, f4);
                ++i;
            }
            pMatrixStack.popPose();
        }
    }

    private static void vertex01(VertexConsumer consumer, Matrix4f matrix, int alpha) {
        consumer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(0, 55, 70, alpha);
    }

    private static void vertex2(VertexConsumer consumer, Matrix4f matrix, float f1, float f2) {
        consumer.addVertex(matrix, -HALF_SQRT_3 * f2, f1, -0.5f * f2).setColor(0, 55, 70, 0);
    }

    private static void vertex3(VertexConsumer consumer, Matrix4f matrix, float f1, float f2) {
        consumer.addVertex(matrix, HALF_SQRT_3 * f2, f1, -0.5f * f2).setColor(0, 55, 70, 0);
    }

    private static void vertex4(VertexConsumer consumer, Matrix4f matrix, float f1, float f2) {
        consumer.addVertex(matrix, 0.0f, f1, f2).setColor(0, 55, 70, 0);
    }

    protected void scale(@NotNull ContagionIncarnationEntity entity, @NotNull PoseStack stack, float v) {
        stack.scale(2.0f, 2.0f, 2.0f);
        super.scale((LivingEntity)entity, stack, v);
    }
}

