/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.animations.CrystalGolemAnimation;
import wardentools.entity.custom.CrystalGolemEntity;

public class CrystalGolem
extends HierarchicalModel<CrystalGolemEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"crystal_golem"), "main");
    private final ModelPart FULL;
    private final ModelPart leg_r;
    private final ModelPart leg_l;
    private final ModelPart top;
    private final ModelPart torso;
    private final ModelPart arm_r;
    private final ModelPart arm_l;
    private final ModelPart head;
    private final ModelPart ear_l;
    private final ModelPart ear_r;

    public CrystalGolem(ModelPart root) {
        this.FULL = root.getChild("FULL");
        this.leg_r = this.FULL.getChild("leg_r");
        this.leg_l = this.FULL.getChild("leg_l");
        this.top = this.FULL.getChild("top");
        this.torso = this.top.getChild("torso");
        this.arm_r = this.torso.getChild("arm_r");
        this.arm_l = this.torso.getChild("arm_l");
        this.head = this.top.getChild("head");
        this.ear_l = this.head.getChild("ear_l");
        this.ear_r = this.head.getChild("ear_r");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition FULL = partdefinition.addOrReplaceChild("FULL", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition leg_r = FULL.addOrReplaceChild("leg_r", CubeListBuilder.create().texOffs(32, 40).addBox(-2.0f, 0.5f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-5.5f, (float)0.0f));
        PartDefinition leg_l = FULL.addOrReplaceChild("leg_l", CubeListBuilder.create().texOffs(14, 41).addBox(-2.0f, 0.5f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-5.5f, (float)0.0f));
        PartDefinition top = FULL.addOrReplaceChild("top", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition torso = top.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, -2.5f, 10.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(14, 31).addBox(-4.0f, 2.0f, -3.0f, 8.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 49).addBox(-1.0f, 2.25f, 1.75f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(48, 23).addBox(-1.5f, 5.25f, 2.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(6, 49).addBox(-1.0f, 9.25f, 1.75f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f));
        PartDefinition cube_r1 = torso.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(48, 49).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)9.5f, (float)-2.75f, (float)0.0f, (float)-0.1745f, (float)0.4363f));
        PartDefinition cube_r2 = torso.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(42, 49).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)9.5f, (float)-2.75f, (float)0.0f, (float)0.1745f, (float)-0.4363f));
        PartDefinition cube_r3 = torso.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(36, 49).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)3.5f, (float)-2.75f, (float)0.0f, (float)0.1745f, (float)0.4363f));
        PartDefinition cube_r4 = torso.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(30, 49).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)3.5f, (float)-2.75f, (float)0.0f, (float)-0.1745f, (float)-0.4363f));
        PartDefinition cube_r5 = torso.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(48, 43).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.25f, (float)5.5f, (float)-2.75f, (float)0.0f, (float)-0.1745f, (float)-0.1745f));
        PartDefinition cube_r6 = torso.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(48, 47).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.25f, (float)7.5f, (float)-2.75f, (float)0.0f, (float)-0.1745f, (float)0.1745f));
        PartDefinition cube_r7 = torso.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(48, 45).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.25f, (float)7.5f, (float)-2.75f, (float)0.0f, (float)0.1745f, (float)-0.1745f));
        PartDefinition cube_r8 = torso.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(48, 41).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.25f, (float)5.5f, (float)-2.75f, (float)0.0f, (float)0.1745f, (float)0.1745f));
        PartDefinition arm_r = torso.addOrReplaceChild("arm_r", CubeListBuilder.create().texOffs(30, 0).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 12).addBox(-2.5f, -1.5f, -1.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)2.25f, (float)0.0f));
        PartDefinition arm_l = torso.addOrReplaceChild("arm_l", CubeListBuilder.create().texOffs(0, 31).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 6).addBox(0.5f, -1.5f, -1.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)2.25f, (float)0.0f));
        PartDefinition head = top.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 18).addBox(-5.5f, -8.0f, -2.0f, 11.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(48, 27).addBox(4.5f, -7.0f, -3.0f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(48, 34).addBox(-5.5f, -7.0f, -3.0f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 0).addBox(-4.5f, -8.0f, -3.0f, 9.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 3).addBox(-4.5f, -2.0f, -3.0f, 9.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(48, 18).addBox(-1.5f, -6.0f, -3.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f));
        PartDefinition ear_l = head.addOrReplaceChild("ear_l", CubeListBuilder.create().texOffs(32, 18).addBox(-2.0f, -8.0f, 0.0f, 8.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)-7.0f, (float)0.0f));
        PartDefinition ear_r = head.addOrReplaceChild("ear_r", CubeListBuilder.create().texOffs(32, 29).addBox(-6.0f, -9.0f, 0.0f, 8.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.5f, (float)-6.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int i) {
        this.FULL.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
    }

    @NotNull
    public ModelPart root() {
        return this.FULL;
    }

    public void setupAnim(@NotNull CrystalGolemEntity golem, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(golem.deactivatedState1, CrystalGolemAnimation.deactivate_1, ageInTicks);
        this.animate(golem.deactivatedState2, CrystalGolemAnimation.deactivate_2, ageInTicks);
        this.animate(golem.lightingState, CrystalGolemAnimation.lighting_candle, ageInTicks);
        this.animate(golem.randomLookAround, CrystalGolemAnimation.look_around, ageInTicks);
        this.animate(golem.reactivateFrom2, CrystalGolemAnimation.rise, ageInTicks);
        this.animate(golem.reactivateFrom1, CrystalGolemAnimation.reactivate, ageInTicks);
        this.animateWalk(CrystalGolemAnimation.walking, limbSwing * 11.0f, limbSwingAmount * 11.0f, 1.0f, 2.5f);
        float attackProgress = golem.getAttackAnim(ageInTicks);
        if (attackProgress > 0.0f) {
            float f = (float)Math.sin((double)attackProgress * Math.PI);
            float f1 = (float)Math.sin((double)(1.0f - (1.0f - attackProgress) * (1.0f - attackProgress)) * Math.PI);
            this.arm_r.xRot -= f * 1.2f + f1 * 0.4f;
            this.arm_r.yRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
            this.arm_r.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        }
        this.head.xRot += headPitch * ((float)Math.PI / 180);
        this.head.yRot += netHeadYaw * ((float)Math.PI / 180);
    }
}

