/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import wardentools.client.rendering.RenderingUtils;
import wardentools.entity.client.CrystalGolem;
import wardentools.entity.client.CrystalGolemCrystalLayer;
import wardentools.entity.client.CrystalGolemRustLayer;
import wardentools.entity.client.CrystalGolemSculkLayer;
import wardentools.entity.custom.CrystalGolemEntity;

public class CrystalGolemRenderer
extends MobRenderer<CrystalGolemEntity, CrystalGolem> {
    private static final ResourceLocation CRYSTAL_GOLEM_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/entity/crystal_golem/crystal_golem.png");
    private static final float MIN_CUBE_SIZE = 0.2f;
    private static final float MAX_CUBE_SIZE = 0.5f;

    public CrystalGolemRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CrystalGolem(context.bakeLayer(CrystalGolem.LAYER_LOCATION)), 0.5f);
        this.addLayer(new CrystalGolemRustLayer((RenderLayerParent<CrystalGolemEntity, CrystalGolem>)this));
        this.addLayer(new CrystalGolemSculkLayer((RenderLayerParent<CrystalGolemEntity, CrystalGolem>)this));
        this.addLayer(new CrystalGolemCrystalLayer((RenderLayerParent<CrystalGolemEntity, CrystalGolem>)this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull CrystalGolemEntity pEntity) {
        return CRYSTAL_GOLEM_TEXTURE;
    }

    public void render(@NotNull CrystalGolemEntity golem, float yaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        super.render((LivingEntity)golem, yaw, partialTicks, poseStack, buffer, packedLight);
        if (golem.getLaserTick() > 0) {
            poseStack.pushPose();
            poseStack.translate(0.0f, golem.getLaserChargingPosition(), 0.0f);
            float a = 0.3f;
            float r = golem.getCrystal().getRed();
            float g = golem.getCrystal().getGreen();
            float b = golem.getCrystal().getBlue();
            VertexConsumer consumer = buffer.getBuffer(RenderingUtils.COLORED_CUBE);
            float progress = (80.0f - (float)golem.getLaserTick()) / 80.0f;
            float baseSize = 0.2f + 0.3f * progress;
            for (int i = 0; i < 3; ++i) {
                poseStack.pushPose();
                float scale = baseSize + (float)i * baseSize / 2.0f;
                poseStack.scale(scale, scale, scale);
                float rotation = ((float)golem.tickCount + partialTicks) * (5.0f + (float)i * 10.0f);
                if (i == 1) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(rotation / 2.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(rotation / 3.0f));
                } else if (i == 2) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-rotation / 3.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(-rotation / 2.0f));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(-rotation));
                } else {
                    poseStack.mulPose(Axis.XP.rotationDegrees(rotation));
                    poseStack.mulPose(Axis.YP.rotationDegrees(rotation / 3.0f));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(-rotation / 2.0f));
                }
                CrystalGolemRenderer.renderCube(poseStack, consumer, r, g, b, a);
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }

    private static void renderCube(PoseStack poseStack, VertexConsumer consumer, float r, float g, float b, float a) {
        PoseStack.Pose entry = poseStack.last();
        int ri = Math.max(0, Math.min(255, (int)(r * 255.0f)));
        int gi = Math.max(0, Math.min(255, (int)(g * 255.0f)));
        int bi = Math.max(0, Math.min(255, (int)(b * 255.0f)));
        int ai = Math.max(0, Math.min(255, (int)(a * 255.0f)));
        float s = 0.3f;
        consumer.addVertex(entry.pose(), -s, -s, -s).setColor(ri, gi, bi, ai).setNormal(0.0f, -1.0f, 0.0f);
        consumer.addVertex(entry.pose(), s, -s, -s).setColor(ri, gi, bi, ai).setNormal(0.0f, -1.0f, 0.0f);
        consumer.addVertex(entry.pose(), s, -s, s).setColor(ri, gi, bi, ai).setNormal(0.0f, -1.0f, 0.0f);
        consumer.addVertex(entry.pose(), -s, -s, s).setColor(ri, gi, bi, ai).setNormal(0.0f, -1.0f, 0.0f);
        consumer.addVertex(entry.pose(), -s, s, -s).setColor(ri, gi, bi, ai).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(entry.pose(), -s, s, s).setColor(ri, gi, bi, ai).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(entry.pose(), s, s, s).setColor(ri, gi, bi, ai).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(entry.pose(), s, s, -s).setColor(ri, gi, bi, ai).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(entry.pose(), -s, -s, -s).setColor(ri, gi, bi, ai).setNormal(0.0f, 0.0f, -1.0f);
        consumer.addVertex(entry.pose(), -s, s, -s).setColor(ri, gi, bi, ai).setNormal(0.0f, 0.0f, -1.0f);
        consumer.addVertex(entry.pose(), s, s, -s).setColor(ri, gi, bi, ai).setNormal(0.0f, 0.0f, -1.0f);
        consumer.addVertex(entry.pose(), s, -s, -s).setColor(ri, gi, bi, ai).setNormal(0.0f, 0.0f, -1.0f);
        consumer.addVertex(entry.pose(), -s, -s, s).setColor(ri, gi, bi, ai).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(entry.pose(), s, -s, s).setColor(ri, gi, bi, ai).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(entry.pose(), s, s, s).setColor(ri, gi, bi, ai).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(entry.pose(), -s, s, s).setColor(ri, gi, bi, ai).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(entry.pose(), -s, -s, -s).setColor(ri, gi, bi, ai).setNormal(-1.0f, 0.0f, 0.0f);
        consumer.addVertex(entry.pose(), -s, -s, s).setColor(ri, gi, bi, ai).setNormal(-1.0f, 0.0f, 0.0f);
        consumer.addVertex(entry.pose(), -s, s, s).setColor(ri, gi, bi, ai).setNormal(-1.0f, 0.0f, 0.0f);
        consumer.addVertex(entry.pose(), -s, s, -s).setColor(ri, gi, bi, ai).setNormal(-1.0f, 0.0f, 0.0f);
        consumer.addVertex(entry.pose(), s, -s, -s).setColor(ri, gi, bi, ai).setNormal(1.0f, 0.0f, 0.0f);
        consumer.addVertex(entry.pose(), s, s, -s).setColor(ri, gi, bi, ai).setNormal(1.0f, 0.0f, 0.0f);
        consumer.addVertex(entry.pose(), s, s, s).setColor(ri, gi, bi, ai).setNormal(1.0f, 0.0f, 0.0f);
        consumer.addVertex(entry.pose(), s, -s, s).setColor(ri, gi, bi, ai).setNormal(1.0f, 0.0f, 0.0f);
    }
}

