/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.animations.ShadowAnimation;
import wardentools.entity.custom.ShadowEntity;
import wardentools.entity.utils.RenderToBufferFunction;

public class Shadow
extends HierarchicalModel<ShadowEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"shadow"), "main");
    private RenderToBufferFunction renderToBufferFunction;
    private final ModelPart FULL;
    private final ModelPart HEAD;
    private final ModelPart BODY;
    private final ModelPart TORSO;
    private final ModelPart LEG_R;
    private final ModelPart LEG_L;
    private final ModelPart ARM_L;
    private final ModelPart ARM_R;

    public Shadow(ModelPart root) {
        this.FULL = root.getChild("FULL");
        this.HEAD = this.FULL.getChild("HEAD");
        this.BODY = this.FULL.getChild("BODY");
        this.TORSO = this.BODY.getChild("TORSO");
        this.LEG_R = this.BODY.getChild("LEG_R");
        this.LEG_L = this.BODY.getChild("LEG_L");
        this.ARM_L = this.BODY.getChild("ARM_L");
        this.ARM_R = this.BODY.getChild("ARM_R");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition FULL = partdefinition.addOrReplaceChild("FULL", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)24.0f, (float)0.0f));
        PartDefinition HEAD = FULL.addOrReplaceChild("HEAD", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-24.0f, (float)1.0f));
        PartDefinition BODY = FULL.addOrReplaceChild("BODY", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-24.0f, (float)1.0f));
        PartDefinition TORSO = BODY.addOrReplaceChild("TORSO", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LEG_R = BODY.addOrReplaceChild("LEG_R", CubeListBuilder.create().texOffs(16, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition LEG_L = BODY.addOrReplaceChild("LEG_L", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition ARM_L = BODY.addOrReplaceChild("ARM_L", CubeListBuilder.create().texOffs(40, 16).addBox(0.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)2.0f, (float)0.0f));
        PartDefinition ARM_R = BODY.addOrReplaceChild("ARM_R", CubeListBuilder.create().texOffs(32, 48).addBox(-4.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int i) {
        if (this.renderToBufferFunction == null) {
            this.FULL.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
        } else {
            this.renderToBufferFunction.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay);
        }
    }

    @NotNull
    public ModelPart root() {
        return this.FULL;
    }

    public void setupAnim(@NotNull ShadowEntity shadow, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderToBufferFunction = shadow.getRenderToBufferFunction();
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (shadow.getSetUpAnimFunction() != null) {
            shadow.getSetUpAnimFunction().setupAnim(shadow.getMimicEntity(), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        } else {
            this.HEAD.xRot += headPitch * ((float)Math.PI / 180);
            this.HEAD.yRot += netHeadYaw * ((float)Math.PI / 180);
            this.animate(shadow.idleAnimation, ShadowAnimation.idle, ageInTicks);
            this.animate(shadow.stasisAnimation, ShadowAnimation.stasis, ageInTicks);
            this.animateWalk(ShadowAnimation.walking, limbSwing * 13.0f, limbSwingAmount * 13.0f, 1.0f, 2.5f);
        }
    }
}

