/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.custom;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.custom.ContagionIncarnationPart;
import wardentools.entity.custom.ProtectorEntity;
import wardentools.entity.interfaces.CorruptionMonster;

public class ContagionIncarnationPartManager
extends CorruptionMonster
implements Enemy {
    public final ContagionIncarnationPart[] subEntities;
    public final ContagionIncarnationPart head = new ContagionIncarnationPart(this, "head", 2.4f, 1.5f);
    public final ContagionIncarnationPart body = new ContagionIncarnationPart(this, "body", 1.5f, 2.0f);
    public final ContagionIncarnationPart tail1 = new ContagionIncarnationPart(this, "tail1", 3.0f, 1.6f);
    public final ContagionIncarnationPart tail2 = new ContagionIncarnationPart(this, "tail2", 1.5f, 1.5f);
    public final ContagionIncarnationPart tail3 = new ContagionIncarnationPart(this, "tail3", 1.3f, 1.3f);
    private static final float HEAD_HITBOX_X = 2.0f;
    private static final float HEAD_HITBOX_Y = 4.0f;
    private static final float TAIL1_HITBOX_X = -3.1f;
    private static final float TAIL1_HITBOX_Y = 0.0f;
    private static final float TAIL2_HITBOX_X = -5.4f;
    private static final float TAIL2_HITBOX_Y = 0.0f;
    private static final float TAIL3_HITBOX_X = -6.7f;
    private static final float TAIL3_HITBOX_Y = 0.0f;
    private static final float BODY_HITBOX_X = 0.0f;
    private static final float BODY_HITBOX_Y = 2.0f;
    private static final EntityDataAccessor<Float> section_6_rotX = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_6_rotY = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_7_rotX = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_7_rotY = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_8_rotX = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_8_rotY = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_9_rotX = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_9_rotY = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_10_rotX = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_10_rotY = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_11_rotX = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_11_rotY = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_12_rotX = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_12_rotY = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_13_rotX = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_13_rotY = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_14_rotX = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_14_rotY = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_15_rotX = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_15_rotY = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_16_rotX = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_16_rotY = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_17_rotX = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_17_rotY = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_18_rotX = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> section_18_rotY = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> end_rotX = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> end_rotY = SynchedEntityData.defineId(ContagionIncarnationPartManager.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final float rad = (float)Math.PI / 180;
    private Vec3 oldPos = null;
    private float refAngleTail = 0.0f;
    private static final float UNFOLD_TAIL_MULTIPLICATOR = 0.4f;
    private static final float TAIL_LENGTH = 90.0f;
    private float traveledLength = 0.0f;
    private final Section section_6;
    private final Section section_7;
    private final Section section_8;
    private final Section section_9;
    private final Section section_10;
    private final Section section_11;
    private final Section section_12;
    private final Section section_13;
    private final Section section_14;
    private final Section section_15;
    private final Section section_16;
    private final Section section_17;
    private final Section section_18;
    private final Section end;

    public ContagionIncarnationPartManager(EntityType<? extends Monster> entity, Level level) {
        super(entity, level);
        this.subEntities = new ContagionIncarnationPart[]{this.head, this.body, this.tail1, this.tail2, this.tail3};
        this.end = new Section(5.0f, null);
        this.section_18 = new Section(5.0f, this.end);
        this.section_17 = new Section(6.0f, this.section_18);
        this.section_16 = new Section(6.0f, this.section_17);
        this.section_15 = new Section(6.0f, this.section_16);
        this.section_14 = new Section(6.0f, this.section_15);
        this.section_13 = new Section(6.0f, this.section_14);
        this.section_12 = new Section(6.0f, this.section_13);
        this.section_11 = new Section(6.0f, this.section_12);
        this.section_10 = new Section(6.0f, this.section_11);
        this.section_9 = new Section(6.0f, this.section_10);
        this.section_8 = new Section(13.0f, this.section_9);
        this.section_7 = new Section(13.0f, this.section_8);
        this.section_6 = new Section(8.0f, this.section_7);
    }

    public void setId(int id) {
        super.setId(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].setId(id + i + 1);
        }
    }

    public void tick() {
        if (!this.level().isClientSide) {
            if (this.oldPos == null) {
                this.oldPos = this.position();
            }
            this.resetTail();
            this.animateTail(this.yBodyRot, this.oldPos, this.position());
            this.oldPos = this.position();
            this.setSection_6_rotX(this.section_6.getRotationX());
            this.setSection_6_rotY(this.section_6.getRotationY());
            this.setSection_7_rotX(this.section_7.getRotationX());
            this.setSection_7_rotY(this.section_7.getRotationY());
            this.setSection_8_rotX(this.section_8.getRotationX());
            this.setSection_8_rotY(this.section_8.getRotationY());
            this.setSection_9_rotX(this.section_9.getRotationX());
            this.setSection_9_rotY(this.section_9.getRotationY());
            this.setSection_10_rotX(this.section_10.getRotationX());
            this.setSection_10_rotY(this.section_10.getRotationY());
            this.setSection_11_rotX(this.section_11.getRotationX());
            this.setSection_11_rotY(this.section_11.getRotationY());
            this.setSection_12_rotX(this.section_12.getRotationX());
            this.setSection_12_rotY(this.section_12.getRotationY());
            this.setSection_13_rotX(this.section_13.getRotationX());
            this.setSection_13_rotY(this.section_13.getRotationY());
            this.setSection_14_rotX(this.section_14.getRotationX());
            this.setSection_14_rotY(this.section_14.getRotationY());
            this.setSection_15_rotX(this.section_15.getRotationX());
            this.setSection_15_rotY(this.section_15.getRotationY());
            this.setSection_16_rotX(this.section_16.getRotationX());
            this.setSection_16_rotY(this.section_16.getRotationY());
            this.setSection_17_rotX(this.section_17.getRotationX());
            this.setSection_17_rotY(this.section_17.getRotationY());
            this.setSection_18_rotX(this.section_18.getRotationX());
            this.setSection_18_rotY(this.section_18.getRotationY());
            this.setEnd_rotX(this.end.getRotationX());
            this.setEnd_rotY(this.end.getRotationY());
        }
        super.tick();
    }

    public void aiStep() {
        super.aiStep();
        this.handleTailSubParts();
    }

    public void handleTailSubParts() {
        this.yBodyRot = this.getYRot();
        for (ContagionIncarnationPart subEntity : this.subEntities) {
            subEntity.xo = subEntity.getX();
            subEntity.yo = subEntity.getY();
            subEntity.zo = subEntity.getZ();
            subEntity.xOld = subEntity.getX();
            subEntity.yOld = subEntity.getY();
            subEntity.zOld = subEntity.getZ();
        }
        this.tickPart(this.body, -0.0f * Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), 2.0, 0.0f * Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))));
        this.tickPart(this.head, -2.0f * Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), 4.0, 2.0f * Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))));
        float r1 = (this.getSection_6_rotY() + this.getSection_7_rotY() + this.getSection_8_rotY()) / 2.0f;
        float r2 = r1 + (this.getSection_9_rotY() + this.getSection_10_rotY() + this.getSection_11_rotY()) / 2.2f;
        float r3 = r2 + (this.getSection_12_rotY() + this.getSection_13_rotY() + this.getSection_14_rotY()) / 2.2f;
        this.tickPart(this.tail1, 3.1f * Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180) + r1)), 0.0, -3.1f * Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180) + r1)));
        this.tickPart(this.tail2, 5.4f * Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180) + r2)), 0.0, -5.4f * Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180) + r2)));
        float length_factor = 1.0f;
        if (this.getSection_12_rotY() != 0.0f) {
            length_factor = 1.0f - Math.max(Mth.abs((float)((this.getSection_12_rotY() + this.getSection_13_rotY() + this.getSection_14_rotY()) / ((float)Math.PI / 180))) % 360.0f / 60.0f, 0.0f);
            length_factor = (length_factor + 3.0f) / 4.0f;
        }
        this.tickPart(this.tail3, -length_factor * -6.7f * Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180) + r3)), 0.0, length_factor * -6.7f * Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180) + r3)));
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder entityData) {
        super.defineSynchedData(entityData);
        entityData.define(section_6_rotX, (Object)Float.valueOf(0.0f));
        entityData.define(section_6_rotY, (Object)Float.valueOf(0.0f));
        entityData.define(section_7_rotX, (Object)Float.valueOf(0.0f));
        entityData.define(section_7_rotY, (Object)Float.valueOf(0.0f));
        entityData.define(section_8_rotX, (Object)Float.valueOf(0.0f));
        entityData.define(section_8_rotY, (Object)Float.valueOf(0.0f));
        entityData.define(section_9_rotX, (Object)Float.valueOf(0.0f));
        entityData.define(section_9_rotY, (Object)Float.valueOf(0.0f));
        entityData.define(section_10_rotX, (Object)Float.valueOf(0.0f));
        entityData.define(section_10_rotY, (Object)Float.valueOf(0.0f));
        entityData.define(section_11_rotX, (Object)Float.valueOf(0.0f));
        entityData.define(section_11_rotY, (Object)Float.valueOf(0.0f));
        entityData.define(section_12_rotX, (Object)Float.valueOf(0.0f));
        entityData.define(section_12_rotY, (Object)Float.valueOf(0.0f));
        entityData.define(section_13_rotX, (Object)Float.valueOf(0.0f));
        entityData.define(section_13_rotY, (Object)Float.valueOf(0.0f));
        entityData.define(section_14_rotX, (Object)Float.valueOf(0.0f));
        entityData.define(section_14_rotY, (Object)Float.valueOf(0.0f));
        entityData.define(section_15_rotX, (Object)Float.valueOf(0.0f));
        entityData.define(section_15_rotY, (Object)Float.valueOf(0.0f));
        entityData.define(section_16_rotX, (Object)Float.valueOf(0.0f));
        entityData.define(section_16_rotY, (Object)Float.valueOf(0.0f));
        entityData.define(section_17_rotX, (Object)Float.valueOf(0.0f));
        entityData.define(section_17_rotY, (Object)Float.valueOf(0.0f));
        entityData.define(section_18_rotX, (Object)Float.valueOf(0.0f));
        entityData.define(section_18_rotY, (Object)Float.valueOf(0.0f));
        entityData.define(end_rotX, (Object)Float.valueOf(0.0f));
        entityData.define(end_rotY, (Object)Float.valueOf(0.0f));
    }

    public float getSection_6_rotX() {
        return ((Float)this.entityData.get(section_6_rotX)).floatValue();
    }

    public float getSection_6_rotY() {
        return ((Float)this.entityData.get(section_6_rotY)).floatValue();
    }

    public float getSection_7_rotX() {
        return ((Float)this.entityData.get(section_7_rotX)).floatValue();
    }

    public float getSection_7_rotY() {
        return ((Float)this.entityData.get(section_7_rotY)).floatValue();
    }

    public float getSection_8_rotX() {
        return ((Float)this.entityData.get(section_8_rotX)).floatValue();
    }

    public float getSection_8_rotY() {
        return ((Float)this.entityData.get(section_8_rotY)).floatValue();
    }

    public float getSection_9_rotX() {
        return ((Float)this.entityData.get(section_9_rotX)).floatValue();
    }

    public float getSection_9_rotY() {
        return ((Float)this.entityData.get(section_9_rotY)).floatValue();
    }

    public float getSection_10_rotX() {
        return ((Float)this.entityData.get(section_10_rotX)).floatValue();
    }

    public float getSection_10_rotY() {
        return ((Float)this.entityData.get(section_10_rotY)).floatValue();
    }

    public float getSection_11_rotX() {
        return ((Float)this.entityData.get(section_11_rotX)).floatValue();
    }

    public float getSection_11_rotY() {
        return ((Float)this.entityData.get(section_11_rotY)).floatValue();
    }

    public float getSection_12_rotX() {
        return ((Float)this.entityData.get(section_12_rotX)).floatValue();
    }

    public float getSection_12_rotY() {
        return ((Float)this.entityData.get(section_12_rotY)).floatValue();
    }

    public float getSection_13_rotX() {
        return ((Float)this.entityData.get(section_13_rotX)).floatValue();
    }

    public float getSection_13_rotY() {
        return ((Float)this.entityData.get(section_13_rotY)).floatValue();
    }

    public float getSection_14_rotX() {
        return ((Float)this.entityData.get(section_14_rotX)).floatValue();
    }

    public float getSection_14_rotY() {
        return ((Float)this.entityData.get(section_14_rotY)).floatValue();
    }

    public float getSection_15_rotX() {
        return ((Float)this.entityData.get(section_15_rotX)).floatValue();
    }

    public float getSection_15_rotY() {
        return ((Float)this.entityData.get(section_15_rotY)).floatValue();
    }

    public float getSection_16_rotX() {
        return ((Float)this.entityData.get(section_16_rotX)).floatValue();
    }

    public float getSection_16_rotY() {
        return ((Float)this.entityData.get(section_16_rotY)).floatValue();
    }

    public float getSection_17_rotX() {
        return ((Float)this.entityData.get(section_17_rotX)).floatValue();
    }

    public float getSection_17_rotY() {
        return ((Float)this.entityData.get(section_17_rotY)).floatValue();
    }

    public float getSection_18_rotX() {
        return ((Float)this.entityData.get(section_18_rotX)).floatValue();
    }

    public float getSection_18_rotY() {
        return ((Float)this.entityData.get(section_18_rotY)).floatValue();
    }

    public float getEnd_rotX() {
        return ((Float)this.entityData.get(end_rotX)).floatValue();
    }

    public float getEnd_rotY() {
        return ((Float)this.entityData.get(end_rotY)).floatValue();
    }

    public void setSection_6_rotX(float value) {
        this.entityData.set(section_6_rotX, (Object)Float.valueOf(value));
    }

    public void setSection_6_rotY(float value) {
        this.entityData.set(section_6_rotY, (Object)Float.valueOf(value));
    }

    public void setSection_7_rotX(float value) {
        this.entityData.set(section_7_rotX, (Object)Float.valueOf(value));
    }

    public void setSection_7_rotY(float value) {
        this.entityData.set(section_7_rotY, (Object)Float.valueOf(value));
    }

    public void setSection_8_rotX(float value) {
        this.entityData.set(section_8_rotX, (Object)Float.valueOf(value));
    }

    public void setSection_8_rotY(float value) {
        this.entityData.set(section_8_rotY, (Object)Float.valueOf(value));
    }

    public void setSection_9_rotX(float value) {
        this.entityData.set(section_9_rotX, (Object)Float.valueOf(value));
    }

    public void setSection_9_rotY(float value) {
        this.entityData.set(section_9_rotY, (Object)Float.valueOf(value));
    }

    public void setSection_10_rotX(float value) {
        this.entityData.set(section_10_rotX, (Object)Float.valueOf(value));
    }

    public void setSection_10_rotY(float value) {
        this.entityData.set(section_10_rotY, (Object)Float.valueOf(value));
    }

    public void setSection_11_rotX(float value) {
        this.entityData.set(section_11_rotX, (Object)Float.valueOf(value));
    }

    public void setSection_11_rotY(float value) {
        this.entityData.set(section_11_rotY, (Object)Float.valueOf(value));
    }

    public void setSection_12_rotX(float value) {
        this.entityData.set(section_12_rotX, (Object)Float.valueOf(value));
    }

    public void setSection_12_rotY(float value) {
        this.entityData.set(section_12_rotY, (Object)Float.valueOf(value));
    }

    public void setSection_13_rotX(float value) {
        this.entityData.set(section_13_rotX, (Object)Float.valueOf(value));
    }

    public void setSection_13_rotY(float value) {
        this.entityData.set(section_13_rotY, (Object)Float.valueOf(value));
    }

    public void setSection_14_rotX(float value) {
        this.entityData.set(section_14_rotX, (Object)Float.valueOf(value));
    }

    public void setSection_14_rotY(float value) {
        this.entityData.set(section_14_rotY, (Object)Float.valueOf(value));
    }

    public void setSection_15_rotX(float value) {
        this.entityData.set(section_15_rotX, (Object)Float.valueOf(value));
    }

    public void setSection_15_rotY(float value) {
        this.entityData.set(section_15_rotY, (Object)Float.valueOf(value));
    }

    public void setSection_16_rotX(float value) {
        this.entityData.set(section_16_rotX, (Object)Float.valueOf(value));
    }

    public void setSection_16_rotY(float value) {
        this.entityData.set(section_16_rotY, (Object)Float.valueOf(value));
    }

    public void setSection_17_rotX(float value) {
        this.entityData.set(section_17_rotX, (Object)Float.valueOf(value));
    }

    public void setSection_17_rotY(float value) {
        this.entityData.set(section_17_rotY, (Object)Float.valueOf(value));
    }

    public void setSection_18_rotX(float value) {
        this.entityData.set(section_18_rotX, (Object)Float.valueOf(value));
    }

    public void setSection_18_rotY(float value) {
        this.entityData.set(section_18_rotY, (Object)Float.valueOf(value));
    }

    public void setEnd_rotX(float value) {
        this.entityData.set(end_rotX, (Object)Float.valueOf(value));
    }

    public void setEnd_rotY(float value) {
        this.entityData.set(end_rotY, (Object)Float.valueOf(value));
    }

    private void tickPart(ContagionIncarnationPart part, double x, double y, double z) {
        part.setPos(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public boolean hurt(ContagionIncarnationPart part, DamageSource source, float damage) {
        if (this.isDeadOrDying() || source.getMsgId().equals("corrupted")) {
            return false;
        }
        if (source.getEntity() instanceof Player || source.getEntity() instanceof ProtectorEntity) {
            return this.reallyHurt(source, damage);
        }
        return true;
    }

    protected boolean reallyHurt(DamageSource source, float damage) {
        return super.hurt(source, damage);
    }

    public ContagionIncarnationPart[] getSubEntities() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    private void resetTail() {
        this.section_6.absoluteRotateX(0.0f);
        this.section_6.absoluteRotateY(0.0f);
        this.section_7.absoluteRotateX(0.0f);
        this.section_7.absoluteRotateY(0.0f);
        this.section_8.absoluteRotateX(0.0f);
        this.section_8.absoluteRotateY(0.0f);
        this.section_9.absoluteRotateX(0.0f);
        this.section_9.absoluteRotateY(0.0f);
        this.section_10.absoluteRotateX(0.0f);
        this.section_10.absoluteRotateY(0.0f);
        this.section_11.absoluteRotateX(0.0f);
        this.section_11.absoluteRotateY(0.0f);
        this.section_12.absoluteRotateX(0.0f);
        this.section_12.absoluteRotateY(0.0f);
        this.section_13.absoluteRotateX(0.0f);
        this.section_13.absoluteRotateY(0.0f);
        this.section_14.absoluteRotateX(0.0f);
        this.section_14.absoluteRotateY(0.0f);
        this.section_15.absoluteRotateX(0.0f);
        this.section_15.absoluteRotateY(0.0f);
        this.section_16.absoluteRotateX(0.0f);
        this.section_16.absoluteRotateY(0.0f);
        this.section_17.absoluteRotateX(0.0f);
        this.section_17.absoluteRotateY(0.0f);
        this.section_18.absoluteRotateX(0.0f);
        this.section_18.absoluteRotateY(0.0f);
        this.end.absoluteRotateX(0.0f);
        this.end.absoluteRotateY(0.0f);
    }

    private void animateTail(float bodyRot, Vec3 oldPos, Vec3 newPos) {
        this.tailLie();
        this.tailFolding(bodyRot, oldPos, newPos);
    }

    private void tailLie() {
        this.section_8.rotateX(-2.5f);
        this.section_9.rotateX(-7.5f);
        this.section_10.rotateX(-5.0f);
        this.section_11.rotateX(10.0f);
        this.section_12.rotateX(2.5f);
        this.section_13.rotateX(2.5f);
        this.section_14.rotateX(-2.5f);
        this.section_15.rotateX(-2.5f);
        this.section_16.rotateX(2.5f);
        this.section_17.rotateX(0.0f);
        this.section_18.rotateX(-5.0f);
        this.end.rotateX(7.5f);
    }

    private void tailFolding(float bodyRot, Vec3 oldPos, Vec3 newPos) {
        float speed = (float)Math.sqrt((newPos.x - oldPos.x) * (newPos.x - oldPos.x) + (newPos.z - oldPos.z) * (newPos.z - oldPos.z));
        this.traveledLength += speed * 0.4f;
        if (this.traveledLength >= 90.0f) {
            this.traveledLength = 0.0f;
        }
        float speedCompensationFactor = (90.0f - this.traveledLength) / 90.0f;
        this.refAngleTail = this.section_7.compensateRotation(bodyRot, this.refAngleTail);
        if (speed > 0.0f) {
            this.refAngleTail = this.refAngleTail * speedCompensationFactor + bodyRot * (1.0f - speedCompensationFactor);
        }
    }

    private static class Section {
        public static final float MAX_ANGLE = 20.0f;
        public float length;
        private float rotX;
        private float rotY;
        private final Section nextSection;
        private float rotYOld = 0.0f;

        public Section(float length, Section nextSection) {
            this.length = length;
            this.nextSection = nextSection;
            this.rotYOld = this.getRotationY();
        }

        public float compensateRotation(float previousPartRot, float refAngleTail) {
            float rotDiff = previousPartRot - refAngleTail;
            float rotToDo = -rotDiff;
            if (!(Math.abs(rotDiff) < 20.0f)) {
                rotToDo = -20.0f * (float)Mth.sign((double)rotDiff);
                this.absoluteRotateY(rotToDo);
                if (this.nextSection != null) {
                    return this.nextSection.compensateRotation(previousPartRot + rotToDo, refAngleTail);
                }
                return previousPartRot + rotToDo;
            }
            this.absoluteRotateY(rotToDo);
            return refAngleTail;
        }

        public void homogeneousRotation(float yaw, float pitch) {
            this.rotateX(pitch);
            this.rotateY(yaw);
            if (this.nextSection != null) {
                this.nextSection.homogeneousRotation(yaw, pitch);
            }
        }

        public float getCumulativeAngleY() {
            if (this.nextSection == null) {
                return this.getRotationY();
            }
            return this.getRotationY() + this.nextSection.getCumulativeAngleY();
        }

        public float getRotationX() {
            return this.rotX;
        }

        public float getRotationY() {
            return this.rotY;
        }

        public void absoluteRotateX(float angle) {
            this.rotX = angle * ((float)Math.PI / 180);
        }

        public void absoluteRotateY(float angle) {
            this.rotYOld = this.getRotationY();
            this.rotY = angle * ((float)Math.PI / 180);
        }

        public void rotateX(float angle) {
            this.rotX += angle * ((float)Math.PI / 180);
        }

        public void rotateY(float angle) {
            this.rotYOld = this.getRotationY();
            this.rotY += angle * ((float)Math.PI / 180);
        }
    }
}

