/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.custom;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;
import wardentools.entity.ModEntities;
import wardentools.entity.custom.CrystalLaserEntity;
import wardentools.entity.utils.CrystalGolemNavigation;
import wardentools.entity.utils.goal.CrystalGolemAttackGoal;
import wardentools.entity.utils.goal.LightCandleGoal;
import wardentools.misc.Crystal;
import wardentools.particle.ModParticleUtils;
import wardentools.particle.options.GlyphParticleOptions;
import wardentools.particle.options.ShineParticleOptions;
import wardentools.sounds.ModSounds;
import wardentools.utils.SaveUtils;

public class CrystalGolemEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Integer> CRYSTAL = SynchedEntityData.defineId(CrystalGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(CrystalGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<BlockPos> CURRENT_CANDLE_TARGET = SynchedEntityData.defineId(CrystalGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<Integer> LASER_TICK = SynchedEntityData.defineId(CrystalGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> SYNC_Y_ROT = SynchedEntityData.defineId(CrystalGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> GRIEF = SynchedEntityData.defineId(CrystalGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SCULK = SynchedEntityData.defineId(CrystalGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final float NEARBY_ALLIED_RANGE = 20.0f;
    private final List<BlockPos> unlitCandles = new ArrayList<BlockPos>();
    private static final int CANDLE_CHECKS_PER_TICKS = 5;
    private static final int CANDLE_RADIUS = 10;
    private static final int CANDLE_HEIGHT = 4;
    private static final int CHANCE_TO_UNLIT_CANDLE = 400;
    public final AnimationState deactivatedState1 = new AnimationState();
    public final AnimationState deactivatedState2 = new AnimationState();
    public final AnimationState lightingState = new AnimationState();
    public final AnimationState randomLookAround = new AnimationState();
    public final AnimationState reactivateFrom2 = new AnimationState();
    public final AnimationState reactivateFrom1 = new AnimationState();
    @Nullable
    private BlockPos golemStonePos = null;
    private int currentCheckIndex = 0;
    private static final List<BlockPos> relativePosToCheck = new ArrayList<BlockPos>();
    private static final int LOOK_AROUND_DURATION = 77;
    private static final int LOOK_TICK_PER_PROB = 60;
    private int lookAroundTickDown = 0;
    private static final int TURNING_ON_DURATION = 110;
    private int turningOnTick = 0;
    private boolean flickerState = false;
    private int nextFlickerScheduledTick = 0;
    private static final int FADING_DURATION = 60;
    private int turningOffTick = 0;
    private static final float PARTICLE_SPEED = 0.2f;
    private GolemState previousState = GolemState.DEACTIVATED_2;
    private GolemState previousDeactivatedState = GolemState.DEACTIVATED_2;
    private static final int MAX_TIME_AWAKE_WITHOUT_GOAL = 1200;
    private int timeAwakeWithoutGoal = 0;
    public static final int LASER_DURATION = 80;
    private static final float LASER_POSITION_MIN = 1.875f;
    private static final float LASER_POSITION_MAX = 2.25f;

    public CrystalGolemEntity(EntityType<? extends PathfinderMob> entity, Level level) {
        super(entity, level);
        this.navigation = new CrystalGolemNavigation((Mob)this, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new CrystalGolemAttackGoal(this, 2.0));
        this.goalSelector.addGoal(2, (Goal)new LightCandleGoal(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean canUse() {
                return super.canUse() && CrystalGolemEntity.this.hasGrief();
            }
        });
    }

    public static AttributeSupplier.Builder createAttribute() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.12).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CRYSTAL, (Object)Crystal.getDefault().getIndex());
        builder.define(STATE, (Object)GolemState.DEACTIVATED_2.getId());
        builder.define(CURRENT_CANDLE_TARGET, (Object)BlockPos.ZERO);
        builder.define(LASER_TICK, (Object)0);
        builder.define(SYNC_Y_ROT, (Object)Float.valueOf(0.0f));
        builder.define(GRIEF, (Object)false);
        builder.define(SCULK, (Object)false);
    }

    public void tick() {
        if (!this.level().isClientSide) {
            this.handleTimeAwake();
            this.handleCandleCheck();
            this.laserTick();
            if (LightCandleGoal.wouldLikeToStart(this) && !this.isActive() && !LightCandleGoal.surroundingGolemHasSameTarget(this)) {
                this.setState(GolemState.TURNING_ON);
            }
        } else {
            this.handleAnimationStates();
            this.animationTickDownAndRandomTrigger();
            if (this.getState() == GolemState.LIGHT) {
                this.lightingCandleParticleEffect();
            }
            if (this.getLaserTick() > 0) {
                this.laserChargingParticleEffect();
            }
        }
        this.updateSwingTime();
        this.handleTurningOffTick();
        this.handleTurningOnTick();
        super.tick();
    }

    private void laserTick() {
        if (this.getState() == GolemState.CHARGING_LASER) {
            if (this.getLaserTick() == 0) {
                this.setLaserTick(80);
                this.makeSound((SoundEvent)ModSounds.LASER_CHARGE.get());
            } else {
                this.setLaserTick(this.getLaserTick() - 1);
                if (this.getLaserTick() == 0 && !this.level().isClientSide()) {
                    this.shootLaser();
                    this.setState(GolemState.TRAVELING);
                }
            }
        } else {
            this.setLaserTick(0);
        }
    }

    public void shootLaser() {
        CrystalLaserEntity laser = new CrystalLaserEntity((EntityType<? extends CrystalLaserEntity>)((EntityType)ModEntities.CRYSTAL_LASER.get()), this.level());
        laser.setPos(this.getLaserFirePosition());
        laser.setCrystalType(this.getCrystal());
        laser.buildCrystalChain();
        this.level().addFreshEntity((Entity)laser);
    }

    private void handleTimeAwake() {
        if (this.isActive() && !LightCandleGoal.wouldLikeToStart(this) && this.getTarget() == null) {
            ++this.timeAwakeWithoutGoal;
            if (this.timeAwakeWithoutGoal > 1200) {
                this.setState(GolemState.DEACTIVATED_1);
                this.timeAwakeWithoutGoal = 0;
            }
        } else {
            this.timeAwakeWithoutGoal = 0;
        }
    }

    private void handleCandleCheck() {
        if (this.golemStonePos == null) {
            this.golemStonePos = this.getOnPos();
        }
        for (int i = 0; i < 5; ++i) {
            if (this.isCurrentCandlePosUnlit()) {
                this.addUnlitCandle(this.getCurrentCheckBlockPos());
            } else if (this.isCurrentCandlePosLit() && this.level().getRandom().nextInt(400) == 0) {
                this.turnOffCandleAtPos(this.getCurrentCheckBlockPos());
            }
            this.nextPosCheck();
        }
    }

    private void handleTurningOnTick() {
        if (this.turningOnTick > 0) {
            --this.turningOnTick;
            if (this.turningOnTick == 0 && !this.level().isClientSide()) {
                this.setState(GolemState.TRAVELING);
            }
        }
        if (this.turningOnTick > 0) {
            if (this.nextFlickerScheduledTick <= this.tickCount) {
                boolean bl = this.flickerState = !this.flickerState;
                if (this.flickerState) {
                    int flickerNumber = (110 - this.turningOnTick) / 5;
                    int onDuration = this.level().getRandom().nextInt(1, 3) + flickerNumber * this.level().getRandom().nextInt(1, 3);
                    this.nextFlickerScheduledTick = this.tickCount + onDuration;
                } else {
                    this.nextFlickerScheduledTick = this.tickCount + 3;
                }
            }
        } else {
            this.flickerState = this.isActive() || this.turningOffTick > 0;
        }
    }

    private void handleTurningOffTick() {
        if (this.turningOffTick > 0) {
            --this.turningOffTick;
        }
    }

    private void handleAnimationStates() {
        this.deactivatedState1.animateWhen(this.getState() == GolemState.DEACTIVATED_1, this.tickCount);
        this.deactivatedState2.animateWhen(this.getState() == GolemState.DEACTIVATED_2, this.tickCount);
        this.lightingState.animateWhen(this.getState() == GolemState.LIGHT, this.tickCount);
        this.randomLookAround.animateWhen(this.lookAroundTickDown > 0 && this.isActive(), this.tickCount);
        if (this.getState() == GolemState.DEACTIVATED_2 || this.getState() == GolemState.DEACTIVATED_1) {
            this.previousDeactivatedState = this.getState();
        }
        this.reactivateFrom2.animateWhen(this.previousDeactivatedState == GolemState.DEACTIVATED_2 && this.getState() == GolemState.TURNING_ON, this.tickCount);
        this.reactivateFrom1.animateWhen(this.previousDeactivatedState == GolemState.DEACTIVATED_1 && this.getState() == GolemState.TURNING_ON, this.tickCount);
    }

    private void animationTickDownAndRandomTrigger() {
        if (this.lookAroundTickDown > 0) {
            --this.lookAroundTickDown;
        }
        if (this.isActive() && this.getState() != GolemState.CHARGING_LASER && !this.hasGrief() && this.level().getRandom().nextInt(60) == 0) {
            this.lookAroundTickDown = 77;
        }
    }

    public void laserChargingParticleEffect() {
        if (this.level().isClientSide) {
            Vec3 emissionPos = this.position().add(0.0, (double)this.getLaserChargingPosition(), 0.0);
            RandomSource random = this.level().getRandom();
            for (int i = 0; i < (80 - this.getLaserTick()) / 7; ++i) {
                Vec3 direction = emissionPos.subtract(emissionPos.offsetRandom(random, 1.0f)).normalize().scale((double)0.3f);
                ModParticleUtils.addClientParticle(this.level(), new ShineParticleOptions(direction, this.getCrystal().getColorARGB()), emissionPos, direction);
            }
            if (this.getLaserTick() == 77) {
                ModParticleUtils.particleCircle(this.level(), new GlyphParticleOptions(Vec3.ZERO, this.getCrystal().getColorARGB()), emissionPos, 0.5f, 15, new Vec3(this.getLookAngle().x, 0.0, this.getLookAngle().z), new Vec3(0.0, (double)0.0065f, 0.0));
            }
        }
    }

    public void lightingCandleParticleEffect() {
        BlockPos targetPos;
        if (this.level().isClientSide && !(targetPos = this.getCurrentCandleTarget()).equals((Object)BlockPos.ZERO)) {
            Vec3 target = targetPos.getCenter();
            target = target.offsetRandom(this.level().getRandom(), 0.1f);
            target.add(0.0, (double)-0.1f, 0.0);
            Vec3 emissionPos = this.position().add(0.0, (double)0.7f, 0.0);
            emissionPos = emissionPos.offsetRandom(this.level().getRandom(), 0.2f);
            target = target.add(target.subtract(emissionPos).scale((double)0.15f));
            emissionPos = emissionPos.add(target.subtract(emissionPos).scale((double)0.15f));
            ModParticleUtils.addClientParticle(this.level(), new ShineParticleOptions(target, this.getCrystal().getColorARGB()), emissionPos, target, 0.2f);
        }
    }

    public int getFadedColor() {
        if (this.turningOffTick > 0) {
            float progress = (float)(60 - this.turningOffTick) / 60.0f;
            int alpha = (int)(255.0f * (1.0f - progress));
            return this.getCrystal().getColorARGB() & 0xFFFFFF | alpha << 24;
        }
        return this.getCrystal().getColorARGB();
    }

    public float getLaserChargingPosition() {
        return (80.0f - (float)this.getLaserTick()) / 80.0f * 0.375f + 1.875f;
    }

    public Vec3 getLaserFirePosition() {
        return this.position().add(0.0, 2.25, 0.0);
    }

    public boolean getFlickerState() {
        return this.flickerState;
    }

    public void onTurningOff() {
        this.turningOffTick = 60;
        this.nextFlickerScheduledTick = 0;
        this.turningOnTick = 0;
        this.setGrief(false);
        this.makeSound((SoundEvent)ModSounds.CRYSTAL_GOLEM_TURNING_OFF.get());
    }

    public void onTurningOn() {
        this.turningOnTick = 110;
        this.turningOffTick = 0;
        this.flickerState = true;
        this.nextFlickerScheduledTick = this.tickCount + 1;
        this.makeSound((SoundEvent)ModSounds.CRYSTAL_GOLEM_TURNING_ON.get());
    }

    public List<BlockPos> getUnlitCandles() {
        return this.unlitCandles;
    }

    public void addUnlitCandle(BlockPos pos) {
        if (!this.unlitCandles.contains(pos)) {
            if (this.unlitCandles.isEmpty()) {
                this.setCurrentCandleTarget(pos.immutable());
            }
            this.unlitCandles.add(pos.immutable());
        }
    }

    public void pollUnlitCandle() {
        if (!this.unlitCandles.isEmpty()) {
            this.unlitCandles.removeFirst();
            if (!this.unlitCandles.isEmpty()) {
                this.setCurrentCandleTarget(this.unlitCandles.getFirst());
            } else {
                this.setCurrentCandleTarget(BlockPos.ZERO);
            }
        }
    }

    public BlockPos peekUnlitCandle() {
        return this.unlitCandles.isEmpty() ? BlockPos.ZERO : this.unlitCandles.getFirst();
    }

    public float distanceToTarget() {
        BlockPos targetPos = this.peekUnlitCandle();
        if (targetPos != BlockPos.ZERO) {
            Vec3 target = targetPos.getCenter();
            return (float)this.position().distanceTo(target);
        }
        return Float.MAX_VALUE;
    }

    public List<CrystalGolemEntity> getNearbyGolems() {
        if (this.level().isClientSide) {
            return List.of();
        }
        AABB box = this.getBoundingBox().inflate(20.0, 4.0, 20.0);
        return this.level().getEntitiesOfClass(CrystalGolemEntity.class, box, golem -> golem != this && golem.isAlive());
    }

    public boolean isActive() {
        return !CrystalGolemEntity.isDeactivated(this.getState()) && this.getState() != GolemState.TURNING_ON;
    }

    public static boolean isDeactivated(GolemState state) {
        return state == GolemState.DEACTIVATED_1 || state == GolemState.DEACTIVATED_2;
    }

    public BlockPos getGolemStonePos() {
        return this.golemStonePos == null ? BlockPos.ZERO : this.golemStonePos;
    }

    public void setCurrentCandleTarget(BlockPos pos) {
        this.entityData.set(CURRENT_CANDLE_TARGET, (Object)pos);
    }

    public BlockPos getCurrentCandleTarget() {
        return (BlockPos)this.entityData.get(CURRENT_CANDLE_TARGET);
    }

    public void setLaserTick(int tick) {
        this.entityData.set(LASER_TICK, (Object)tick);
    }

    public int getLaserTick() {
        return (Integer)this.entityData.get(LASER_TICK);
    }

    public void setSyncedYRot(float rot) {
        this.entityData.set(SYNC_Y_ROT, (Object)Float.valueOf(rot));
    }

    public float getSyncedYRot() {
        return ((Float)this.entityData.get(SYNC_Y_ROT)).floatValue();
    }

    public void setState(GolemState state) {
        this.entityData.set(STATE, (Object)state.getId());
    }

    public GolemState getState() {
        return GolemState.fromId((Integer)this.entityData.get(STATE));
    }

    public boolean hasGrief() {
        return (Boolean)this.entityData.get(GRIEF);
    }

    public void setGrief(boolean grief) {
        this.entityData.set(GRIEF, (Object)grief);
    }

    public boolean hasSculk() {
        return (Boolean)this.entityData.get(SCULK);
    }

    public void setSculk(boolean sculk) {
        this.entityData.set(SCULK, (Object)sculk);
    }

    public void forceYRot(float rot) {
        this.setYRot(rot);
        this.yRotO = rot;
        this.yBodyRot = rot;
        this.yBodyRotO = rot;
        this.yHeadRot = rot;
        this.yHeadRotO = rot;
    }

    private void nextPosCheck() {
        this.currentCheckIndex = (this.currentCheckIndex + 1) % relativePosToCheck.size();
    }

    private boolean isCurrentCandlePosUnlit() {
        if (this.golemStonePos == null) {
            return false;
        }
        BlockPos pos = this.getCurrentCheckBlockPos();
        BlockState state = this.level().getBlockState(pos);
        if (state.is(BlockTags.CANDLES) && state.hasProperty((Property)CandleBlock.LIT)) {
            return (Boolean)state.getValue((Property)CandleBlock.LIT) == false;
        }
        return false;
    }

    private boolean isCurrentCandlePosLit() {
        if (this.golemStonePos == null) {
            return false;
        }
        BlockPos pos = this.getCurrentCheckBlockPos();
        BlockState state = this.level().getBlockState(pos);
        if (state.is(BlockTags.CANDLES) && state.hasProperty((Property)CandleBlock.LIT)) {
            return (Boolean)state.getValue((Property)CandleBlock.LIT);
        }
        return false;
    }

    public BlockPos getCurrentCheckBlockPos() {
        if (this.golemStonePos == null) {
            return BlockPos.ZERO;
        }
        BlockPos relativePos = relativePosToCheck.get(this.currentCheckIndex);
        return this.golemStonePos.offset(relativePos.getX(), relativePos.getY(), relativePos.getZ());
    }

    public void lightCandleAtPos() {
        BlockState state;
        if (this.level().isClientSide) {
            return;
        }
        if (!this.unlitCandles.isEmpty() && !((Boolean)(state = this.level().getBlockState(this.unlitCandles.getFirst())).getValue((Property)CandleBlock.LIT)).booleanValue()) {
            this.level().setBlock(this.unlitCandles.getFirst(), (BlockState)state.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            this.playSound(SoundEvents.FIRECHARGE_USE, 0.2f, 1.0f);
        }
    }

    public void turnOffCandleAtPos(BlockPos pos) {
        if (this.level().isClientSide) {
            return;
        }
        BlockState state = this.level().getBlockState(pos);
        if (state.is(BlockTags.CANDLES) && state.hasProperty((Property)CandleBlock.LIT) && ((Boolean)state.getValue((Property)CandleBlock.LIT)).booleanValue()) {
            this.level().setBlock(pos, (BlockState)state.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public Crystal getCrystal() {
        return Crystal.fromIndex((Integer)this.entityData.get(CRYSTAL));
    }

    public void setCrystalType(Crystal crystal) {
        this.entityData.set(CRYSTAL, (Object)crystal.getIndex());
    }

    public void setGolemStonePos(@Nullable BlockPos pos) {
        this.golemStonePos = pos;
    }

    public int finalizeReturnToStone() {
        if (this.level().isClientSide) {
            return 30;
        }
        if (this.golemStonePos == null) {
            return 1;
        }
        BlockState state = this.level().getBlockState(this.golemStonePos);
        if (!state.is((Block)BlockRegistry.GOLEM_STONE.get())) {
            return 1;
        }
        this.moveTo(this.golemStonePos.getCenter().add(0.0, 0.5, 0.0));
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        this.syncRotToFacing(facing);
        return 30;
    }

    private void syncRotToFacing(Direction facing) {
        if (this.level().isClientSide) {
            return;
        }
        float yaw = switch (facing) {
            case Direction.NORTH -> 180.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
        this.setYRot(yaw);
        this.setXRot(0.0f);
        this.yHeadRot = yaw;
        this.yHeadRotO = yaw;
        this.yBodyRot = yaw;
        ServerLevel server = (ServerLevel)this.level();
        byte yawByte = (byte)(yaw * 256.0f / 360.0f);
        byte pitchByte = 0;
        server.getChunkSource().broadcast((Entity)this, (Packet)new ClientboundRotateHeadPacket((Entity)this, yawByte));
        server.getChunkSource().broadcast((Entity)this, (Packet)new ClientboundMoveEntityPacket.Rot(this.getId(), yawByte, pitchByte, this.onGround()));
    }

    public void choseViolence() {
        this.setGrief(true);
        this.setState(GolemState.TURNING_ON);
        this.playSound((SoundEvent)ModSounds.CRYSTAL_GOLEM_AGGRESSION.get(), this.getSoundVolume(), this.level().getRandom().nextFloat() * 0.2f + 0.9f);
    }

    private void alertOthers() {
        for (CrystalGolemEntity golem : this.getNearbyGolems()) {
            if (golem == this || golem.isActive()) continue;
            golem.choseViolence();
        }
    }

    public boolean hurt(@NotNull DamageSource source, float damage) {
        Player player;
        Entity entity = source.getEntity();
        if (entity instanceof Player && (player = (Player)entity).isCreative()) {
            return super.hurt(source, damage);
        }
        if (!this.hasGrief()) {
            this.choseViolence();
            this.alertOthers();
            this.setState(GolemState.TRAVELING);
        }
        return super.hurt(source, damage);
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> key) {
        float newRot;
        GolemState newState;
        super.onSyncedDataUpdated(key);
        if (key.equals(STATE) && (newState = this.getState()) != this.previousState) {
            if (CrystalGolemEntity.isDeactivated(newState) && !CrystalGolemEntity.isDeactivated(this.previousState)) {
                this.onTurningOff();
            }
            if (newState == GolemState.TURNING_ON && CrystalGolemEntity.isDeactivated(this.previousState)) {
                this.onTurningOn();
            }
            this.previousState = newState;
        }
        if (key.equals(SYNC_Y_ROT) && (newRot = this.getSyncedYRot()) != this.getYRot()) {
            this.forceYRot(newRot);
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        tag.putInt("crystal_type", ((Integer)this.entityData.get(CRYSTAL)).intValue());
        tag.putInt("state", this.getState().getId());
        tag.putInt("laser_tick", this.getLaserTick());
        if (this.golemStonePos != null) {
            SaveUtils.putBlockPos(tag, "golem_stone_pos", this.golemStonePos);
        }
        tag.putBoolean("has_grief", this.hasGrief());
        tag.putBoolean("has_sculk", this.hasSculk());
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        if (tag.contains("crystal_type")) {
            this.setCrystalType(Crystal.fromIndex(tag.getInt("crystal_type")));
        }
        if (tag.contains("state")) {
            this.previousState = GolemState.fromId(tag.getInt("state"));
            this.setState(this.previousState);
        }
        if (tag.contains("laser_tick")) {
            this.setLaserTick(tag.getInt("laser_tick"));
        }
        if (tag.contains("golem_stone_pos")) {
            this.golemStonePos = SaveUtils.readBlockPos(tag, "golem_stone_pos");
        }
        if (tag.contains("has_grief")) {
            this.setGrief(tag.getBoolean("has_grief"));
        }
        if (tag.contains("has_sculk")) {
            this.setSculk(tag.getBoolean("has_sculk"));
        }
        super.readAdditionalSaveData(tag);
        this.flickerState = this.isActive();
    }

    public static boolean canSpawn(EntityType<CrystalGolemEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos).isAir();
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.playSound((SoundEvent)ModSounds.CRYSTAL_GOLEM_STEP.get(), this.getSoundVolume(), this.level().getRandom().nextFloat() * 0.2f + 0.9f);
    }

    public void playAmbientSound() {
        if (this.isActive()) {
            super.playAmbientSound();
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.CRYSTAL_GOLEM_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)ModSounds.CRYSTAL_GOLEM_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.CRYSTAL_GOLEM_DEATH.get();
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    static {
        for (int x = -10; x <= 10; ++x) {
            for (int y = 0; y <= 4; ++y) {
                for (int z = -10; z <= 10; ++z) {
                    relativePosToCheck.add(new BlockPos(x, y, z));
                }
            }
        }
    }

    public static enum GolemState {
        DEACTIVATED_1(0),
        DEACTIVATED_2(1),
        LIGHT(2),
        TRAVELING(3),
        TURNING_ON(4),
        CHARGING_LASER(5);

        private final int id;

        private GolemState(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static GolemState fromId(int id) {
            for (GolemState s : GolemState.values()) {
                if (s.id != id) continue;
                return s;
            }
            return TRAVELING;
        }
    }
}

