/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.custom;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wardentools.entity.ModEntities;
import wardentools.entity.utils.CustomFlyingPathNavigation;
import wardentools.entity.utils.NoctilureFlyingMoveControl;
import wardentools.entity.utils.goal.JoinOwnerGoal;
import wardentools.entity.utils.goal.LandGoal;
import wardentools.entity.utils.goal.RandomFlyGoal;
import wardentools.entity.utils.goal.TakeOffGoal;
import wardentools.items.ItemRegistry;
import wardentools.sounds.ModSounds;

public class NoctilureEntity
extends TamableAnimal
implements NeutralMob,
OwnableEntity {
    public static final float FLYING_SPEED = 0.2f;
    private static final int CHANCE_TO_LAND = 2000;
    private static final int CHANCE_TO_TAKE_OFF = 2000;
    private static final int LANDING_ANIMATION_DURATION = 30;
    private static final int IDLE_FLY_TO_FLY_DURATION = 15;
    private static final float FLYING_INERTIA = 0.8f;
    public static final int MAX_SPRINT_ENERGY = 2000;
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(NoctilureEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TARGETED_HEIGHT_ON_TAKE_OFF = SynchedEntityData.defineId(NoctilureEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_FLYING = SynchedEntityData.defineId(NoctilureEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> WANTS_TO_LAND = SynchedEntityData.defineId(NoctilureEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> WANTS_TO_TAKE_OFF = SynchedEntityData.defineId(NoctilureEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> was_idle_flying = SynchedEntityData.defineId(NoctilureEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> landingTick = SynchedEntityData.defineId(NoctilureEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> idleFlyToFlyTick = SynchedEntityData.defineId(NoctilureEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> flightSprinting = SynchedEntityData.defineId(NoctilureEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> sprintEnergy = SynchedEntityData.defineId(NoctilureEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(NoctilureEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> WANTS_TO_JOIN_OWNER = SynchedEntityData.defineId(NoctilureEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    public final AnimationState standing = new AnimationState();
    public final AnimationState walking = new AnimationState();
    public final AnimationState flying = new AnimationState();
    public final AnimationState landing = new AnimationState();
    public final AnimationState idleFlying = new AnimationState();
    public final AnimationState idleFlyToFly = new AnimationState();
    protected CustomFlyingPathNavigation flyingNavigation;
    protected PathNavigation groundNavigation;
    protected NoctilureFlyingMoveControl flyingMoveControl;
    protected MoveControl groundMoveControl;
    private Vec3 previousMovement = Vec3.ZERO;
    private boolean energyWasZero = false;
    @Nullable
    private UUID persistentAngerTarget;

    public NoctilureEntity(EntityType<? extends TamableAnimal> entity, Level level) {
        super(entity, level);
        this.flyingNavigation = new CustomFlyingPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
        this.flyingMoveControl = new NoctilureFlyingMoveControl(this);
        this.groundMoveControl = new MoveControl((Mob)this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new JoinOwnerGoal(this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(4, (Goal)new LandGoal(this));
        this.goalSelector.addGoal(5, (Goal)new TakeOffGoal(this));
        this.goalSelector.addGoal(6, (Goal)new RandomFlyGoal(this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                return !NoctilureEntity.this.getIsFlying() && !NoctilureEntity.this.getWantsToJoinOwner() && super.canUse();
            }
        });
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
    }

    public static AttributeSupplier.Builder createAttribute() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FLYING_SPEED, 0.1);
    }

    public void tick() {
        this.handleTickers();
        if (this.level().isClientSide) {
            this.handleAnimation();
        } else if (!this.isVehicle() && !this.getWantsToJoinOwner()) {
            this.handleRandomFlyingLogic();
        }
        if (this.isVehicle()) {
            this.handlePlayerControl();
        }
        super.tick();
    }

    private void handleRandomFlyingLogic() {
        if (this.getIsFlying()) {
            if (!this.getWantsToLand() && !this.getWantsToTakeOff() && this.getRandom().nextInt(2000) == 0) {
                this.setWantsToLand(true);
            }
            if (this.getHeightAboveGround() <= 1.0 && !this.getWantsToTakeOff() && !this.getWantsToLand()) {
                this.land();
            }
        } else if (!this.getWantsToTakeOff() && !this.getWantsToLand() && this.getRandom().nextInt(2000) == 0) {
            this.takeOff();
        }
    }

    private void handlePlayerControl() {
        if (this.getWantsToLand()) {
            this.setWantsToLand(false);
        }
        if (this.getWantsToTakeOff()) {
            this.setWantsToTakeOff(false);
        }
        if (Minecraft.getInstance().options.keyDown.isDown() && this.getIsFlying() && this.getHeightAboveGround() <= 1.0) {
            this.land();
        }
        if (this.getIsFlying()) {
            if (Minecraft.getInstance().options.keySprint.isDown()) {
                if (Minecraft.getInstance().options.keyUp.isDown()) {
                    this.lowerEnergy(10);
                }
                if (this.energyWasZero) {
                    this.setFlightSprinting(this.getSprintEnergy() > 10);
                } else {
                    this.setFlightSprinting(this.getSprintEnergy() > 0);
                }
            } else {
                this.setFlightSprinting(false);
            }
            if (this.getSprintEnergy() < 2000) {
                if (!Minecraft.getInstance().options.keyUp.isDown()) {
                    this.increaseEnergy(2);
                } else if (!Minecraft.getInstance().options.keySprint.isDown()) {
                    this.increaseEnergy(1);
                }
            }
        } else if (this.getSprintEnergy() < 2000) {
            this.increaseEnergy(20);
        }
    }

    private void handleAnimation() {
        this.standing.animateWhen(!this.walkAnimation.isMoving() && !this.getIsFlying() && this.noSecondaryAnimation(), this.tickCount);
        this.walking.animateWhen(this.walkAnimation.isMoving() && !this.getIsFlying() && this.noSecondaryAnimation(), this.tickCount);
        this.flying.animateWhen(this.getIsFlying() && !this.isAlmostIdle() && this.noSecondaryAnimation(), this.tickCount);
        this.landing.animateWhen(this.getLandingTick() > 0, this.tickCount);
        this.idleFlying.animateWhen(this.getIsFlying() && this.isAlmostIdle() && this.noSecondaryAnimation(), this.tickCount);
        this.idleFlyToFly.animateWhen(this.getIdleFlyToFlyTick() > 0 && this.getLandingTick() == 0 && this.getIsFlying(), this.tickCount);
    }

    private void handleTickers() {
        if (this.getWasIdleFlying() && !this.isAlmostIdle() && this.getIsFlying()) {
            this.setWasIdleFlying(false);
            this.setIdleFlyToFlyTick(15);
        }
        if (this.isAlmostIdle() && !this.getWasIdleFlying()) {
            this.setWasIdleFlying(true);
        }
        if (this.getLandingTick() > 0) {
            this.setLandingTick(this.getLandingTick() - 1);
        }
        if (this.getIdleFlyToFlyTick() > 0) {
            this.setIdleFlyToFlyTick(this.getIdleFlyToFlyTick() - 1);
        }
    }

    public void increaseEnergy(int energy) {
        int newEnergy = Math.min(this.getSprintEnergy() + energy, 2000);
        this.setSprintEnergy(newEnergy);
        if (this.getSprintEnergy() >= 10) {
            this.energyWasZero = false;
        }
    }

    public void lowerEnergy(int energy) {
        int newEnergy = Math.max(this.getSprintEnergy() - energy, 0);
        this.setSprintEnergy(newEnergy);
        if (this.getSprintEnergy() <= 0) {
            this.energyWasZero = true;
        }
    }

    public void call() {
        if (this.getWantsToJoinOwner()) {
            this.playSound((SoundEvent)ModSounds.NOCTILURE_AMBIENT.get(), this.getSoundVolume() * 2.0f, this.getVoicePitch());
        }
        this.setWantsToJoinOwner(true);
    }

    public void playAmbientSound() {
        super.playAmbientSound();
    }

    public void takeOff() {
        this.setWantsToTakeOff(true);
        this.setIsFlying(true);
        this.setNoGravity(true);
        this.updateMovementLogic();
        this.setTargetedHeightOnTakeOff(this.getRandom().nextInt(10, 30));
    }

    public void land() {
        this.setLandingTick(30);
        this.setWantsToLand(false);
        this.setIsFlying(false);
        this.setNoGravity(false);
        this.updateMovementLogic();
    }

    public void resetRandomFlyingLogic() {
        this.setWantsToLand(false);
        this.setWantsToTakeOff(false);
    }

    public double getHeightAboveGround() {
        BlockPos groundPos = this.blockPosition();
        while (groundPos.getY() > this.level().getMinBuildHeight() && this.level().getBlockState(groundPos).isAir()) {
            groundPos = groundPos.below();
        }
        return this.getY() - (double)groundPos.getY();
    }

    @NotNull
    public PathNavigation getNavigation() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return mob.getNavigation();
        }
        return this.getIsFlying() ? this.flyingNavigation : this.navigation;
    }

    @NotNull
    public MoveControl getMoveControl() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return mob.getMoveControl();
        }
        return this.getIsFlying() ? this.flyingMoveControl : this.groundMoveControl;
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.isVehicle()) {
            if (this.isTamed() && player.getItemInHand(hand).getItem() == ItemRegistry.NOCTILURE_TREAT.get() && this.getHealth() < this.getMaxHealth()) {
                this.heal(4.0f);
                player.getItemInHand(hand).shrink(1);
                return InteractionResult.SUCCESS;
            }
            if (this.isTamed() && player.getUUID().equals(this.getOwnerUUID())) {
                if (!this.level().isClientSide) {
                    player.startRiding((Entity)this);
                    Minecraft.getInstance().options.setCameraType(CameraType.THIRD_PERSON_BACK);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (!this.isTamed() && player.getItemInHand(InteractionHand.MAIN_HAND).is((Item)ItemRegistry.NOCTILURE_TREAT.get())) {
            this.tryToTame(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void tryToTame(Player player) {
        player.getItemInHand(InteractionHand.MAIN_HAND).shrink(1);
        if (!this.level().isClientSide && this.level().random.nextInt(0, 4) == 0) {
            this.tame(player);
            this.setOwnerUUID(player.getUUID());
        }
        this.spawnTamingParticles(this.isTamed());
    }

    public void updateMoveControl() {
        this.moveControl = this.getMoveControl();
    }

    public void updateNavigation() {
        this.navigation = this.getNavigation();
    }

    public void updateMovementLogic() {
        this.updateMoveControl();
        this.updateNavigation();
    }

    public static boolean canSpawn(EntityType<NoctilureEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON);
    }

    public void travel(@NotNull Vec3 travelVector) {
        LivingEntity livingEntity;
        if (this.isVehicle() && (livingEntity = this.getControllingPassenger()) instanceof Player) {
            Player player = (Player)livingEntity;
            this.setYRot(player.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(player.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yHeadRot = this.yBodyRot = this.getYRot();
            if (this.getIsFlying() && Minecraft.getInstance().options.keyUp.isDown()) {
                this.flyingTravel(player.getViewVector(1.0f).scale(this.getFlightSprinting() ? (double)1.1f : 0.5).scale(this.isInWater() ? (double)0.1f : 1.0));
            } else if (!this.getIsFlying()) {
                float forward = player.zza;
                float strafe = player.xxa;
                this.moveRelative(0.1f, new Vec3((double)strafe, travelVector.y, (double)forward).scale(this.isInWater() ? (double)0.1f : 1.0));
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.91f));
                super.travel(travelVector);
            } else {
                this.flyingTravel(travelVector);
            }
        } else if (this.getIsFlying()) {
            this.flyingTravel(travelVector);
        } else {
            super.travel(travelVector);
        }
    }

    public void flyingTravel(Vec3 travelVector) {
        if (this.isControlledByLocalInstance() && this.isVehicle()) {
            Vec3 desiredMovement;
            double scale = this.isInWater() ? 0.3 : (this.isInLava() ? 0.1 : 0.8);
            this.previousMovement = desiredMovement = travelVector.scale(0.19999998807907104).add(this.previousMovement.scale((double)0.8f));
            this.setDeltaMovement(desiredMovement);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(scale));
        } else {
            this.flyingAutoTravel(travelVector);
        }
        this.calculateEntityAnimation(false);
    }

    public void flyingAutoTravel(Vec3 vec3) {
        if (this.isControlledByLocalInstance()) {
            if (this.isInWater()) {
                this.moveRelative(0.02f, vec3);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
            } else if (this.isInLava()) {
                this.moveRelative(0.02f, vec3);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            } else {
                BlockPos ground = this.getBlockPosBelowThatAffectsMyMovement();
                float f = 0.91f;
                if (this.onGround()) {
                    f = this.level().getBlockState(ground).getFriction((LevelReader)this.level(), ground, (Entity)this) * 0.91f;
                }
                float f1 = 0.16277137f / (f * f * f);
                f = 0.91f;
                if (this.onGround()) {
                    f = this.level().getBlockState(ground).getFriction((LevelReader)this.level(), ground, (Entity)this) * 0.91f;
                }
                this.moveRelative(this.onGround() ? 0.1f * f1 : 0.02f, vec3);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)f));
            }
        }
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder entityData) {
        super.defineSynchedData(entityData);
        entityData.define(DATA_REMAINING_ANGER_TIME, (Object)0);
        entityData.define(TARGETED_HEIGHT_ON_TAKE_OFF, (Object)0);
        entityData.define(IS_FLYING, (Object)false);
        entityData.define(WANTS_TO_LAND, (Object)false);
        entityData.define(WANTS_TO_TAKE_OFF, (Object)false);
        entityData.define(landingTick, (Object)0);
        entityData.define(idleFlyToFlyTick, (Object)0);
        entityData.define(was_idle_flying, (Object)false);
        entityData.define(flightSprinting, (Object)false);
        entityData.define(sprintEnergy, (Object)2000);
        entityData.define(OWNER_UUID, Optional.empty());
        entityData.define(WANTS_TO_JOIN_OWNER, (Object)false);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.addPersistentAngerSaveData(tag);
        tag.putBoolean("is_flying", this.getIsFlying());
        tag.putBoolean("wants_to_land", this.getWantsToLand());
        tag.putBoolean("wants_to_take_off", this.getWantsToTakeOff());
        tag.putInt("landing_tick", this.getLandingTick());
        tag.putBoolean("was_idle_flying", this.getWasIdleFlying());
        tag.putInt("sprint_energy", this.getSprintEnergy());
        if (this.getOwnerUUID() != null) {
            tag.putUUID("owner", this.getOwnerUUID());
        }
        tag.putBoolean("wants_to_join_owner", ((Boolean)this.entityData.get(WANTS_TO_JOIN_OWNER)).booleanValue());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readPersistentAngerSaveData(this.level(), tag);
        this.setIsFlying(tag.getBoolean("is_flying"));
        this.setWantsToLand(tag.getBoolean("wants_to_land"));
        this.setWantsToTakeOff(tag.getBoolean("wants_to_take_off"));
        this.setLandingTick(tag.getInt("landing_tick"));
        this.setWasIdleFlying(tag.getBoolean("was_idle_flying"));
        this.setSprintEnergy(tag.getInt("sprint_energy"));
        if (tag.hasUUID("owner")) {
            this.setOwnerUUID(tag.getUUID("owner"));
        }
        this.setWantsToJoinOwner(tag.getBoolean("wants_to_join_owner"));
    }

    public int getTargetHeightOnTakeOff() {
        return (Integer)this.entityData.get(TARGETED_HEIGHT_ON_TAKE_OFF);
    }

    public void setTargetedHeightOnTakeOff(int height) {
        this.entityData.set(TARGETED_HEIGHT_ON_TAKE_OFF, (Object)height);
    }

    public boolean getIsFlying() {
        return (Boolean)this.entityData.get(IS_FLYING);
    }

    public void setIsFlying(boolean flying) {
        this.entityData.set(IS_FLYING, (Object)flying);
    }

    public boolean getWantsToLand() {
        return (Boolean)this.entityData.get(WANTS_TO_LAND);
    }

    public void setWantsToLand(boolean land) {
        this.entityData.set(WANTS_TO_LAND, (Object)land);
    }

    public boolean getWantsToTakeOff() {
        return (Boolean)this.entityData.get(WANTS_TO_TAKE_OFF);
    }

    public void setWantsToTakeOff(boolean takeOff) {
        this.entityData.set(WANTS_TO_TAKE_OFF, (Object)takeOff);
    }

    public int getLandingTick() {
        return (Integer)this.entityData.get(landingTick);
    }

    public void setLandingTick(int tick) {
        this.entityData.set(landingTick, (Object)tick);
    }

    public int getIdleFlyToFlyTick() {
        return (Integer)this.entityData.get(idleFlyToFlyTick);
    }

    public void setIdleFlyToFlyTick(int tick) {
        this.entityData.set(idleFlyToFlyTick, (Object)tick);
    }

    public boolean getWasIdleFlying() {
        return (Boolean)this.entityData.get(was_idle_flying);
    }

    public void setWasIdleFlying(boolean wasIdleFlying) {
        this.entityData.set(was_idle_flying, (Object)wasIdleFlying);
    }

    public boolean getFlightSprinting() {
        return (Boolean)this.entityData.get(flightSprinting);
    }

    public void setFlightSprinting(boolean sprinting) {
        this.entityData.set(flightSprinting, (Object)sprinting);
    }

    public int getSprintEnergy() {
        return (Integer)this.entityData.get(sprintEnergy);
    }

    public void setSprintEnergy(int energy) {
        this.entityData.set(sprintEnergy, (Object)energy);
    }

    public boolean getWantsToJoinOwner() {
        return (Boolean)this.entityData.get(WANTS_TO_JOIN_OWNER);
    }

    public void setWantsToJoinOwner(boolean wantsToJoinOwner) {
        this.entityData.set(WANTS_TO_JOIN_OWNER, (Object)wantsToJoinOwner);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int tick) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)tick);
    }

    @javax.annotation.Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public boolean checkSpawnRules(@NotNull LevelAccessor level, @NotNull MobSpawnType type) {
        return true;
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return (AgeableMob)((EntityType)ModEntities.NOCTILURE.get()).create((Level)level);
    }

    protected void checkFallDamage(double v, boolean b, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    @Nullable
    public UUID getOwnerUUID() {
        if (((Optional)this.entityData.get(OWNER_UUID)).isPresent()) {
            return (UUID)((Optional)this.entityData.get(OWNER_UUID)).get();
        }
        return null;
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public boolean isTamed() {
        return this.getOwnerUUID() != null;
    }

    public void onPlayerJump(Player player) {
        if (!this.getIsFlying()) {
            this.setIsFlying(true);
            this.setNoGravity(true);
            this.setIdleFlyToFlyTick(15);
            this.updateMovementLogic();
        }
    }

    public boolean isPushable() {
        return !this.isVehicle();
    }

    protected void positionRider(@NotNull Entity rider, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MoveFunction moveFunction) {
        super.positionRider(rider, moveFunction);
        if (rider instanceof LivingEntity) {
            ((LivingEntity)rider).yBodyRot = this.yBodyRot;
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return super.getControllingPassenger();
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 pos, LivingEntity passenger) {
        double d0 = this.getX() + pos.x;
        double d1 = this.getBoundingBox().minY;
        double d2 = this.getZ() + pos.z;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : passenger.getDismountPoses()) {
            blockpos$mutableblockpos.set(d0, d1, d2);
            double d3 = this.getBoundingBox().maxY + 0.75;
            do {
                double d4 = this.level().getBlockFloorHeight((BlockPos)blockpos$mutableblockpos);
                if ((double)blockpos$mutableblockpos.getY() + d4 > d3) continue block0;
                if (DismountHelper.isBlockFloorValid((double)d4)) {
                    AABB aabb = passenger.getLocalBoundsForPose(pose);
                    Vec3 vec3 = new Vec3(d0, (double)blockpos$mutableblockpos.getY() + d4, d2);
                    if (DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)passenger, (AABB)aabb.move(vec3))) {
                        passenger.setPose(pose);
                        return vec3;
                    }
                }
                blockpos$mutableblockpos.move(Direction.UP);
            } while ((double)blockpos$mutableblockpos.getY() < d3);
        }
        return null;
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Minecraft.getInstance().options.setCameraType(CameraType.FIRST_PERSON);
        Vec3 vec3 = NoctilureEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)passenger.getBbWidth(), (float)(this.getYRot() + (passenger.getMainArm() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vec31 = this.getDismountLocationInDirection(vec3, passenger);
        if (vec31 != null) {
            return vec31;
        }
        Vec3 vec32 = NoctilureEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)passenger.getBbWidth(), (float)(this.getYRot() + (passenger.getMainArm() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vec33 = this.getDismountLocationInDirection(vec32, passenger);
        return vec33 != null ? vec33 : this.position();
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(@NotNull Entity passenger, @NotNull EntityDimensions dimensions, float offset) {
        float rot = this.yBodyRot * ((float)Math.PI / 180) + 1.5707964f;
        return new Vec3((double)(-0.3f * offset * Mth.cos((float)rot)), (double)(this.getPassengersRidingOffsetY(dimensions, offset) + 0.1f * offset), (double)(-0.3f * offset * Mth.sin((float)rot)));
    }

    protected float getPassengersRidingOffsetY(EntityDimensions dimensions, float offset) {
        return dimensions.height() + (this.isBaby() ? 0.2f : -0.15f) * offset;
    }

    protected boolean canAddPassenger(@NotNull Entity entity) {
        return super.canAddPassenger(entity) && !this.isBaby();
    }

    public boolean dampensVibrations() {
        return true;
    }

    private boolean isAlmostIdle() {
        return this.getDeltaMovement().lengthSqr() < 0.01;
    }

    private boolean noSecondaryAnimation() {
        return this.getLandingTick() == 0 && this.getIdleFlyToFlyTick() == 0;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.NOCTILURE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)ModSounds.NOCTILURE_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.NOCTILURE_DEATH.get();
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
    }

    protected float getSoundVolume() {
        return 0.8f;
    }

    public boolean isFood(@NotNull ItemStack itemStack) {
        return itemStack.is((Item)ItemRegistry.NOCTILURE_TREAT.get());
    }
}

