/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.custom;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.ModEntities;
import wardentools.items.ItemRegistry;
import wardentools.sounds.ModSounds;

public class PaleWandererEntity
extends Animal {
    public final AnimationState calmAnimationState = new AnimationState();

    public PaleWandererEntity(EntityType<? extends Animal> entity, Level level) {
        super(entity, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new PanicGoal((PathfinderMob)this, 3.0));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 10.0));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 2.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITETREE_SAPLING.get()}), false));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 2.0));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttribute() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.12f).add(Attributes.FOLLOW_RANGE, 15.0).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public void tick() {
        if (this.level().isClientSide()) {
            this.calmAnimationState.animateWhen(!this.isInWaterOrBubble() && !this.walkAnimation.isMoving(), this.tickCount);
        }
        super.tick();
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, @NotNull DamageSource source) {
        return false;
    }

    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return (AgeableMob)((EntityType)ModEntities.PALE_WANDERER.get()).create((Level)level);
    }

    public boolean isFood(ItemStack pStack) {
        return pStack.is((Item)ItemRegistry.WHITE_SEED.get());
    }

    public boolean checkSpawnRules(@NotNull LevelAccessor accessor, @NotNull MobSpawnType spawnType) {
        return true;
    }

    public static boolean canSpawn(EntityType<PaleWandererEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.FOX_AMBIENT;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.PALE_WANDERER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.PALE_WANDERER_DEATH.get();
    }
}

