/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import wardentools.blockentity.ProtectorInvokerBlockEntity;
import wardentools.entity.utils.goal.ChooseMonsterTargetGoal;
import wardentools.entity.utils.goal.ReturnToInvokerGoal;
import wardentools.network.PacketHandler;
import wardentools.network.ParticulesSoundsEffects.ParticleRadianceImplosion;
import wardentools.network.ParticulesSoundsEffects.SynchronizeProtectorHeart;
import wardentools.sounds.ModSounds;
import wardentools.utils.SaveUtils;

public class ProtectorEntity
extends AbstractGolem {
    public int protectorDeathTime = 0;
    private static final int attackDurationTick = 10;
    public static final int invokerRadius = 20;
    public static final int dispawnCoolDown = 60;
    public static final int spawnCoolDown = 25;
    public static final int earTickleDuration = 20;
    private static final EntityDataAccessor<Integer> dispawnTick = SynchedEntityData.defineId(ProtectorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> spawnTick = SynchedEntityData.defineId(ProtectorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> attackAnimationTick = SynchedEntityData.defineId(ProtectorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> earTick = SynchedEntityData.defineId(ProtectorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState spawning = new AnimationState();
    public final AnimationState dispawning = new AnimationState();
    public final AnimationState earTickle = new AnimationState();
    public BlockPos invokerPos = null;
    public static final double MAX_HEALTH = 550.0;
    public static final int DEATH_DURATION = 60;

    public ProtectorEntity(EntityType<? extends AbstractGolem> entity, Level level) {
        super(entity, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 2.0, 32.0f));
        this.goalSelector.addGoal(3, (Goal)new ReturnToInvokerGoal(this, 1.0, true));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new ChooseMonsterTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createAttribute() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 550.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.ATTACK_DAMAGE, 30.0);
    }

    public void tick() {
        if (this.getAttackTick() > 0) {
            this.setAttackTick(this.getAttackTick() - 1);
        }
        if (this.getSpawnTick() > 0) {
            this.setSpawnTick(this.getSpawnTick() - 1);
        }
        if (this.getEarTick() == 0 && this.random.nextInt(200) == 0 && !this.isEarTickling()) {
            this.setEarTick(20);
        }
        if (this.isEarTickling()) {
            this.setEarTick(this.getEarTick() - 1);
        }
        if (this.level().isClientSide()) {
            this.attackAnimationState.animateWhen(this.getAttackTick() > 0, this.tickCount);
            this.earTickle.animateWhen(this.isEarTickling(), this.tickCount);
            this.spawning.animateWhen(this.isSpawning(), this.tickCount);
            this.dispawning.animateWhen(this.isDispawning(), this.tickCount);
        }
        this.dispawnTick();
        super.tick();
        if (this.isDispawning() || this.isSpawning()) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
    }

    public int getAttackTick() {
        return (Integer)this.entityData.get(attackAnimationTick);
    }

    public void setAttackTick(int tick) {
        this.entityData.set(attackAnimationTick, (Object)tick);
    }

    public int getSpawnTick() {
        return (Integer)this.entityData.get(spawnTick);
    }

    public void setSpawnTick(int tick) {
        this.entityData.set(spawnTick, (Object)tick);
    }

    public int getDispawnTick() {
        return (Integer)this.entityData.get(dispawnTick);
    }

    public void setDispawnTick(int tick) {
        this.entityData.set(dispawnTick, (Object)tick);
    }

    public int getEarTick() {
        return (Integer)this.entityData.get(earTick);
    }

    public void setEarTick(int tick) {
        this.entityData.set(earTick, (Object)tick);
    }

    public boolean isEarTickling() {
        return this.getEarTick() > 0;
    }

    public boolean isSpawning() {
        return this.getSpawnTick() > 0;
    }

    public boolean isDispawning() {
        return this.getDispawnTick() > 0;
    }

    public void makeSpawnAnimation() {
        this.setSpawnTick(25);
    }

    private void dispawnTick() {
        if (this.invokerPos != null) {
            if (!this.checkInvoker()) {
                if (this.getDispawnTick() == 0) {
                    this.setDispawnTick(60);
                }
            } else if (!this.isDeadOrDying()) {
                this.setDispawnTick(0);
            }
        }
        if (this.isDeadOrDying() && this.getDispawnTick() == 0) {
            this.setDispawnTick(60);
        }
        if (this.isDispawning()) {
            this.setDispawnTick(this.getDispawnTick() - 1);
            if (this.getDispawnTick() == 0) {
                this.deathParticleEffect();
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private boolean checkInvoker() {
        BlockEntity blockEntity = this.level().getBlockEntity(this.invokerPos);
        if (blockEntity instanceof ProtectorInvokerBlockEntity) {
            ProtectorInvokerBlockEntity invoker = (ProtectorInvokerBlockEntity)blockEntity;
            return invoker.isProtectorValid(this);
        }
        return false;
    }

    public void setInvokerPos(@NotNull BlockPos pos) {
        this.invokerPos = pos;
    }

    private void deathParticleEffect() {
        PacketHandler.sendToAllClient(new ParticleRadianceImplosion(this.getPosition(1.0f).add(0.0, 1.0, 0.0)));
    }

    protected void tickDeath() {
        ++this.protectorDeathTime;
        if (this.protectorDeathTime >= 60 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void die(@NotNull DamageSource source) {
        BlockEntity blockEntity;
        if (this.invokerPos != null && (blockEntity = this.level().getBlockEntity(this.invokerPos)) instanceof ProtectorInvokerBlockEntity) {
            ProtectorInvokerBlockEntity invoker = (ProtectorInvokerBlockEntity)blockEntity;
            invoker.saveHealth(this);
        }
        if (!this.isRemoved() && !this.dead) {
            Entity entity = source.getEntity();
            LivingEntity livingentity = this.getKillCredit();
            if (this.deathScore >= 0 && livingentity != null) {
                livingentity.awardKillScore((Entity)this, this.deathScore, source);
            }
            if (this.isSleeping()) {
                this.stopSleeping();
            }
            this.dead = true;
            this.getCombatTracker().recheckStatus();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (entity == null || entity.killedEntity(serverlevel, (LivingEntity)this)) {
                    this.gameEvent((Holder)GameEvent.ENTITY_DIE);
                    this.dropAllDeathLoot(serverlevel, source);
                    this.createWitherRose(livingentity);
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
            }
        }
        super.die(source);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder entityData) {
        super.defineSynchedData(entityData);
        entityData.define(attackAnimationTick, (Object)0);
        entityData.define(dispawnTick, (Object)0);
        entityData.define(spawnTick, (Object)0);
        entityData.define(earTick, (Object)0);
    }

    public boolean canAttackType(@NotNull EntityType<?> entity) {
        if (entity == EntityType.PLAYER) {
            return false;
        }
        return super.canAttackType(entity);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.invokerPos != null) {
            SaveUtils.putBlockPos(compound, "InvokerPos", this.invokerPos);
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("InvokerPos")) {
            this.invokerPos = SaveUtils.readBlockPos(compound, "InvokerPos");
        }
    }

    private float getAttackDamage() {
        return (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (this.invokerPos != null) {
            PacketHandler.sendToAllClient(new SynchronizeProtectorHeart(this.invokerPos, this.getHealth()));
            BlockEntity blockEntity = this.level().getBlockEntity(this.invokerPos);
            if (blockEntity instanceof ProtectorInvokerBlockEntity) {
                ProtectorInvokerBlockEntity invoker = (ProtectorInvokerBlockEntity)blockEntity;
                invoker.saveHealth(this);
            }
        }
        return super.hurt(source, amount);
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        this.setAttackTick(10);
        return super.doHurtTarget(target);
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, @NotNull DamageSource source) {
        return false;
    }

    public boolean checkSpawnRules(@NotNull LevelAccessor level, @NotNull MobSpawnType spawnType) {
        return true;
    }

    public static boolean canSpawn(EntityType<ProtectorEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return true;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.PROTECTOR_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)ModSounds.PROTECTOR_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.PROTECTOR_DEATH.get();
    }

    protected float getSoundVolume() {
        return 0.8f;
    }
}

