/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.custom;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import wardentools.entity.interfaces.MimicEntity;
import wardentools.fluid.FluidRegistry;
import wardentools.particle.ParticleRegistry;
import wardentools.sounds.ModSounds;

public class ShadowEntity
extends MimicEntity
implements VibrationSystem {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final AnimationState idleAnimation = new AnimationState();
    public final AnimationState stasisAnimation = new AnimationState();
    private static final EntityDataAccessor<Boolean> IS_STASIS = SynchedEntityData.defineId(ShadowEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final VibrationSystem.User vibrationUser = new ShadowVibrationUser();
    private VibrationSystem.Data vibrationData = new VibrationSystem.Data();
    private final DynamicGameEventListener<VibrationSystem.Listener> dynamicGameEventListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener((VibrationSystem)this));
    private int outOfStasisTicks = 0;
    private static final int MAX_OUT_OF_STASIS_TICKS = 6000;

    public ShadowEntity(EntityType<? extends Monster> entity, Level level) {
        super(entity, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 3.0, false){

            public boolean canUse() {
                return super.canUse() && !((ShadowEntity)this.mob).isStasis();
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && !((ShadowEntity)this.mob).isStasis();
            }
        });
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                return !ShadowEntity.this.isStasis() && super.canUse();
            }

            public boolean canContinueToUse() {
                return !ShadowEntity.this.isStasis() && super.canContinueToUse();
            }
        });
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttribute() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.1).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FLYING_SPEED, 0.01).add(Attributes.FOLLOW_RANGE, 20.0);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            VibrationSystem.Ticker.tick((Level)this.level(), (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
        }
        if (this.level().isClientSide) {
            this.idleAnimation.animateWhen(!this.isStasis(), this.tickCount);
            this.stasisAnimation.animateWhen(this.isStasis(), this.tickCount);
            this.animateParticleTick();
        }
        if (this.isStasis()) {
            this.doStasisTick();
        } else {
            this.setNoGravity(false);
        }
        if (!this.isStasis() && this.getTarget() == null) {
            ++this.outOfStasisTicks;
            if (this.outOfStasisTicks >= 6000) {
                this.setStasis(true);
                this.outOfStasisTicks = 0;
            }
        } else {
            this.outOfStasisTicks = 0;
        }
    }

    public void animateParticleTick() {
        float particleSpawnRadius = (float)this.getBoundingBox().getXsize() * 4.0f;
        Vec3 center = this.getBoundingBox().getCenter();
        if (this.isStasis()) {
            if (this.tickCount % 5 == this.getRandom().nextInt(5)) {
                float x = (this.getRandom().nextFloat() - 0.5f) * 1.2f * (float)this.getBoundingBox().getXsize();
                float y = (this.getRandom().nextFloat() - 0.5f) * 1.2f * (float)this.getBoundingBox().getYsize();
                float z = (this.getRandom().nextFloat() - 0.5f) * 1.2f * (float)this.getBoundingBox().getZsize();
                this.level().addParticle((ParticleOptions)ParticleRegistry.CORRUPTION.get(), (double)((float)center.x + x), (double)((float)center.y + y), (double)((float)center.z + z), 0.0, -0.2, 0.0);
            }
        } else if (this.tickCount % 10 == this.getRandom().nextInt(10)) {
            float x = (this.getRandom().nextFloat() * 2.0f - 1.0f) * particleSpawnRadius;
            float y = (this.getRandom().nextFloat() * 2.0f - 1.0f) * particleSpawnRadius;
            float z = (this.getRandom().nextFloat() * 2.0f - 1.0f) * particleSpawnRadius;
            float norm = Mth.sqrt((float)(x * x + y * y + z * z)) / (0.1f * particleSpawnRadius);
            this.level().addParticle((ParticleOptions)ParticleRegistry.CORRUPTION.get(), (double)((float)center.x + x), (double)((float)center.y + y), (double)((float)center.z + z), (double)(-x / norm), (double)(-y / norm), (double)(-z / norm));
        }
    }

    public void updateDynamicGameEventListener(@NotNull BiConsumer<DynamicGameEventListener<?>, ServerLevel> consumer) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            consumer.accept(this.dynamicGameEventListener, serverlevel);
        }
    }

    private void doStasisTick() {
        this.setNoGravity(true);
        if (this.getHeightAboveGround() < 3.0) {
            this.setDeltaMovement(0.0, 0.015, 0.0);
        } else {
            this.setDeltaMovement(0.0, Math.cos((double)this.tickCount * 0.02) * 0.02, 0.0);
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
    }

    public double getHeightAboveGround() {
        BlockPos groundPos = this.blockPosition();
        while (groundPos.getY() > this.level().getMinBuildHeight() && this.level().getBlockState(groundPos).isAir()) {
            groundPos = groundPos.below();
        }
        return this.getY() - (double)groundPos.getY();
    }

    protected boolean isAffectedByFluids() {
        return false;
    }

    public boolean canStandOnFluid(@NotNull FluidState fluidState) {
        if (fluidState.is((Fluid)FluidRegistry.SOURCE_LIQUID_CORRUPTION.get()) || fluidState.is((Fluid)FluidRegistry.FLOWING_LIQUID_CORRUPTION.get())) {
            return true;
        }
        return super.canStandOnFluid(fluidState);
    }

    public void playerTouch(@NotNull Player player) {
        if (!this.level().isClientSide) {
            this.setStasis(false);
        }
        super.playerTouch(player);
    }

    @Override
    public boolean hurt(@NotNull DamageSource source, float v) {
        this.setStasis(false);
        return super.hurt(source, v);
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder entityData) {
        super.defineSynchedData(entityData);
        entityData.define(IS_STASIS, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("isStasis", this.isStasis());
        VibrationSystem.Data.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.vibrationData).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_219418_ -> tag.put("listener", p_219418_));
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setStasis(tag.getBoolean("isStasis"));
        if (tag.contains("listener", 10)) {
            VibrationSystem.Data.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(data -> {
                this.vibrationData = data;
            });
        }
    }

    public boolean isStasis() {
        return (Boolean)this.entityData.get(IS_STASIS);
    }

    public void setStasis(boolean stasis) {
        this.entityData.set(IS_STASIS, (Object)stasis);
    }

    @NotNull
    public VibrationSystem.Data getVibrationData() {
        return this.vibrationData;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull VibrationSystem.User getVibrationUser() {
        return this.vibrationUser;
    }

    public static boolean canSpawn(EntityType<ShadowEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(BlockTags.VALID_SPAWN);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.playSound(SoundEvents.DROWNED_STEP, this.getSoundVolume(), 1.0f);
    }

    protected SoundEvent getAmbientSound() {
        return this.isStasis() ? null : (SoundEvent)ModSounds.SHADOW_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)ModSounds.SHADOW_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.SHADOW_DEATH.get();
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    class ShadowVibrationUser
    implements VibrationSystem.User {
        private static final int LISTEN_RADIUS = 16;
        private final PositionSource positionSource;

        ShadowVibrationUser() {
            this.positionSource = new EntityPositionSource((Entity)ShadowEntity.this, ShadowEntity.this.getEyeHeight());
        }

        public int getListenerRadius() {
            return 16;
        }

        @NotNull
        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        @NotNull
        public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.WARDEN_CAN_LISTEN;
        }

        public boolean canTriggerAvoidVibration() {
            return ShadowEntity.this.isStasis();
        }

        public boolean canReceiveVibration(@NotNull ServerLevel serverLevel, @NotNull BlockPos blockPos, @NotNull Holder<GameEvent> holder, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull GameEvent.Context context) {
            return ShadowEntity.this.isStasis();
        }

        public void onReceiveVibration(@NotNull ServerLevel level, @NotNull BlockPos blockPos, @NotNull Holder<GameEvent> holder, @Nullable Entity source, @Nullable Entity entity1, float v) {
            ServerPlayer player;
            if (source instanceof ServerPlayer && !(player = (ServerPlayer)source).isCreative() && ShadowEntity.this.isStasis()) {
                ShadowEntity.this.setStasis(false);
                ShadowEntity.this.playSound(SoundEvents.WARDEN_TENDRIL_CLICKS, 5.0f, ShadowEntity.this.getVoicePitch());
                level.broadcastEntityEvent((Entity)ShadowEntity.this, (byte)61);
            }
        }
    }
}

