/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.interfaces;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.interfaces.CorruptionMonster;
import wardentools.entity.utils.RenderToBufferFunction;
import wardentools.entity.utils.ScaleFunction;
import wardentools.entity.utils.SetUpAnimFunction;
import wardentools.entity.utils.getBobFunction;

public class MimicEntity
extends CorruptionMonster {
    private LivingEntity mimicEntity = null;
    private static final EntityDataAccessor<Integer> MIMIC_ENTITY_ID = SynchedEntityData.defineId(MimicEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    protected MimicEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public void tick() {
        Entity entity;
        int id;
        super.tick();
        if (this.level().isClientSide && (id = ((Integer)this.entityData.get(MIMIC_ENTITY_ID)).intValue()) != -1 && (entity = this.level().getEntity(id)) instanceof LivingEntity) {
            this.mimicEntity = (LivingEntity)entity;
        }
        this.updateBoundingBoxSize();
    }

    private void updateBoundingBoxSize() {
        if (this.mimicEntity != null) {
            double width = this.mimicEntity.getBbWidth();
            double height = this.mimicEntity.getBbHeight();
            double depth = this.mimicEntity.getBbWidth();
            double centerX = this.getX();
            double centerY = this.getY();
            double centerZ = this.getZ();
            AABB newBox = new AABB(centerX - width / 2.0, centerY, centerZ - depth / 2.0, centerX + width / 2.0, centerY + height, centerZ + depth / 2.0);
            this.setBoundingBox(newBox);
        }
    }

    public boolean isBaby() {
        if (this.mimicEntity == null) {
            return super.isBaby();
        }
        return this.mimicEntity.isBaby();
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder entityData) {
        super.defineSynchedData(entityData);
        entityData.define(MIMIC_ENTITY_ID, (Object)-1);
    }

    public double getEyeY() {
        if (this.mimicEntity == null) {
            return super.getEyeY();
        }
        return this.mimicEntity.getEyeY();
    }

    public RenderToBufferFunction getRenderToBufferFunction() {
        if (this.mimicEntity == null) {
            return null;
        }
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)this.mimicEntity);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            return (poseStack, vertexConsumer, i, j) -> livingRenderer.getModel().renderToBuffer(poseStack, vertexConsumer, i, j);
        }
        return null;
    }

    public <T extends LivingEntity> SetUpAnimFunction<T> getSetUpAnimFunction() {
        if (this.mimicEntity == null) {
            return null;
        }
        LivingEntity deadEntityCasted = this.mimicEntity;
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)deadEntityCasted);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            return (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((EntityModel)livingRenderer.getModel()).setupAnim(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
        }
        return null;
    }

    public <T extends LivingEntity> getBobFunction<T> getGetBobFunction() {
        if (this.mimicEntity == null) {
            return null;
        }
        LivingEntity deadEntityCasted = this.mimicEntity;
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)deadEntityCasted);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            try {
                Method getBobMethod = LivingEntityRenderer.class.getDeclaredMethod("getBob", LivingEntity.class, Float.TYPE);
                getBobMethod.setAccessible(true);
                return (entity, partialTicks) -> {
                    if (deadEntityCasted instanceof Chicken || deadEntityCasted instanceof Parrot) {
                        return 0.0f;
                    }
                    try {
                        return ((Float)getBobMethod.invoke((Object)livingRenderer, entity, Float.valueOf(partialTicks))).floatValue();
                    }
                    catch (Exception e) {
                        System.out.println("Error invoking getBob method");
                        return 0.0f;
                    }
                };
            }
            catch (NoSuchMethodException e) {
                System.out.println("Error invoking getBob method: NoSuchMethodException");
            }
        }
        return null;
    }

    public <T extends LivingEntity> ScaleFunction<T> getScaleFunction() {
        if (this.mimicEntity == null) {
            return null;
        }
        LivingEntity deadEntityCasted = this.mimicEntity;
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)deadEntityCasted);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            try {
                Method scaleMethod = LivingEntityRenderer.class.getDeclaredMethod("scale", LivingEntity.class, PoseStack.class, Float.TYPE);
                scaleMethod.setAccessible(true);
                return (entity, poseStack, v) -> {
                    try {
                        scaleMethod.invoke((Object)livingRenderer, entity, poseStack, Float.valueOf(v));
                    }
                    catch (Exception e) {
                        System.out.println("Error invoking scale method");
                    }
                };
            }
            catch (NoSuchMethodException e) {
                System.out.println("Error invoking getBob scale method: NoSuchMethodException");
            }
        }
        return null;
    }

    public LivingEntity getMimicEntity() {
        return this.mimicEntity;
    }

    public void setMimicEntity(LivingEntity mimicEntity) {
        this.mimicEntity = mimicEntity;
        this.entityData.set(MIMIC_ENTITY_ID, (Object)mimicEntity.getId());
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.mimicEntity != null) {
            tag.putInt("MimicEntityId", this.mimicEntity.getId());
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("MimicEntityId")) {
            int id = tag.getInt("MimicEntityId");
            this.entityData.set(MIMIC_ENTITY_ID, (Object)id);
        }
    }
}

