/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.Vec3;
import wardentools.entity.custom.NoctilureEntity;

public class NoctilureFlyingMoveControl
extends MoveControl {
    private final NoctilureEntity noctilure;

    public NoctilureFlyingMoveControl(NoctilureEntity mob) {
        super((Mob)mob);
        this.noctilure = mob;
    }

    public void tick() {
        if (this.hasWanted()) {
            this.operation = MoveControl.Operation.WAIT;
            double dx = this.getWantedX() - this.noctilure.getX();
            double dy = this.getWantedY() - this.noctilure.getY();
            double dz = this.getWantedZ() - this.noctilure.getZ();
            this.noctilure.setDeltaMovement(new Vec3(dx, dy, dz).normalize().scale((double)0.2f).scale(this.noctilure.getWantsToJoinOwner() ? (double)1.6f : 1.0));
            float newYRot = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            this.noctilure.yBodyRot = this.noctilure.getYRot();
            this.noctilure.setYRot(this.rotlerp(this.noctilure.getYRot(), newYRot, 90.0f));
        }
    }
}

