/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;
import wardentools.entity.custom.DeepLurkerEntity;

public class ClimbGoal
extends Goal {
    private final DeepLurkerEntity entity;

    public ClimbGoal(DeepLurkerEntity entity) {
        this.entity = entity;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public void start() {
        this.entity.setClimbing(true);
    }

    public void stop() {
        this.entity.setClimbing(false);
    }

    public boolean canUse() {
        return this.entity.horizontalCollision && this.entity.level().getBlockState(this.entity.blockPosition().above()).isAir();
    }

    public void tick() {
        if (this.entity.horizontalCollision) {
            this.entity.setDeltaMovement(this.entity.getDeltaMovement().multiply(1.0, 0.2, 1.0));
            if (this.entity.level().getBlockState(this.entity.blockPosition().above()).isAir()) {
                this.entity.setDeltaMovement(this.entity.getDeltaMovement().add(0.0, 0.2, 0.0));
            }
        }
    }
}

