/*
 * Decompiled with CFR 0.152.
 */
package wardentools.events;

import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import wardentools.advancement.ModCriteriaTriggers;
import wardentools.block.BlockRegistry;
import wardentools.entity.ModEntities;
import wardentools.entity.custom.ContagionIncarnationCorpseEntity;
import wardentools.entity.custom.ContagionIncarnationEntity;
import wardentools.entity.custom.CrystalGolemEntity;
import wardentools.entity.custom.DeepLurkerEntity;
import wardentools.entity.custom.NoctilureEntity;
import wardentools.entity.custom.PaleWandererEntity;
import wardentools.entity.custom.ParasyteEntity;
import wardentools.entity.custom.ProtectorEntity;
import wardentools.entity.custom.ShadowEntity;
import wardentools.entity.custom.TemperEntity;
import wardentools.network.PacketHandler;
import wardentools.particle.ParticleRegistry;
import wardentools.particle.custom.AbyssAmbient;
import wardentools.particle.custom.AbyssPortal;
import wardentools.particle.custom.BlackCorruption;
import wardentools.particle.custom.Corruption;
import wardentools.particle.custom.GlyphParticle;
import wardentools.particle.custom.GlyphParticleRotating;
import wardentools.particle.custom.Radiance;
import wardentools.particle.custom.ShineParticle;

@Mod.EventBusSubscriber(modid="wardentools", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonModEvents {
    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(PacketHandler::register);
        event.enqueueWork(() -> ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(BlockRegistry.WHITE_TORCHFLOWER.getId(), BlockRegistry.POTTED_WHITE_TORCHFLOWER));
        ModCriteriaTriggers.init();
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ModEntities.DEEPLURKER.get(), DeepLurkerEntity.createAttribute().build());
        event.put((EntityType)ModEntities.PALE_WANDERER.get(), PaleWandererEntity.createAttribute().build());
        event.put((EntityType)ModEntities.PROTECTOR.get(), ProtectorEntity.createAttribute().build());
        event.put((EntityType)ModEntities.CONTAGION_INCARNATION.get(), ContagionIncarnationEntity.createAttribute().build());
        event.put((EntityType)ModEntities.TEMPER.get(), TemperEntity.createAttribute().build());
        event.put((EntityType)ModEntities.PARASYTE.get(), ParasyteEntity.createAttribute().build());
        event.put((EntityType)ModEntities.NOCTILURE.get(), NoctilureEntity.createAttribute().build());
        event.put((EntityType)ModEntities.SHADOW.get(), ShadowEntity.createAttribute().build());
        event.put((EntityType)ModEntities.CONTAGION_INCARNATION_CORPSE.get(), ContagionIncarnationCorpseEntity.createAttribute().build());
        event.put((EntityType)ModEntities.CRYSTAL_GOLEM.get(), CrystalGolemEntity.createAttribute().build());
    }

    @SubscribeEvent
    public static void registerSpawnPlacement(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)ModEntities.DEEPLURKER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, DeepLurkerEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)ModEntities.PALE_WANDERER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.WORLD_SURFACE, PaleWandererEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)ModEntities.PROTECTOR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, ProtectorEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)ModEntities.CONTAGION_INCARNATION.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, ContagionIncarnationEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)ModEntities.TEMPER.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, TemperEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)ModEntities.PARASYTE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, ParasyteEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)ModEntities.NOCTILURE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.WORLD_SURFACE, NoctilureEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)ModEntities.SHADOW.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, ShadowEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)ModEntities.CRYSTAL_GOLEM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, CrystalGolemEntity::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        Minecraft.getInstance().particleEngine.register((ParticleType)ParticleRegistry.ABYSS_AMBIENT.get(), AbyssAmbient.Provider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ParticleRegistry.CORRUPTION.get(), Corruption.Provider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ParticleRegistry.ABYSS_PORTAL.get(), AbyssPortal.Provider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ParticleRegistry.RADIANCE.get(), Radiance.Provider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ParticleRegistry.BLACK_CORRUPTION.get(), BlackCorruption.Provider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ParticleRegistry.SHINE_PARTICLE.get(), ShineParticle.Provider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ParticleRegistry.GLYPH_PARTICLE.get(), GlyphParticle.Provider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ParticleRegistry.GLYPH_PARTICLE_ROTATING.get(), GlyphParticleRotating.Provider::new);
    }
}

