/*
 * Decompiled with CFR 0.152.
 */
package wardentools.events.gameevents;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wardentools")
public class CustomizeBossBar {
    private static final ResourceLocation FULL = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/bossbar/bar_full.png");
    private static final ResourceLocation EMPTY = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/bossbar/bar_empty.png");
    private static final int barWidth = 182;
    private static final int barHeight = 31;

    @SubscribeEvent
    public static void onBossEventProgress(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (event.getBossEvent().getName().getString().equals(Component.translatable((String)"entity.wardentools.contagion_incarnation").getString())) {
            event.setCanceled(true);
            GuiGraphics guiGraphics = event.getGuiGraphics();
            Window window = event.getWindow();
            int screenWidth = window.getGuiScaledWidth();
            LerpingBossEvent bossInfo = event.getBossEvent();
            int x = (int)((float)(screenWidth - 182) / 2.0f);
            int y = 5;
            int progressWidth = (int)((1.0f - bossInfo.getProgress()) * 182.0f);
            guiGraphics.blit(EMPTY, x, y, 0.0f, 0.0f, 182, 31, 182, 31);
            guiGraphics.blit(FULL, x, y, 0.0f, 0.0f, 182 - progressWidth, 31, 182, 31);
        }
    }
}

