/*
 * Decompiled with CFR 0.152.
 */
package wardentools.events.gameevents;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wardentools.block.BlockRegistry;
import wardentools.network.PacketHandler;
import wardentools.network.ParticulesSoundsEffects.ParticleWardenDeathPacket;

@Mod.EventBusSubscriber(modid="wardentools")
public class WardenDeathEvent {
    @SubscribeEvent
    public static void wardenDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof Warden) {
            Level level = event.getEntity().level();
            BlockPos pos = event.getEntity().blockPosition();
            if (!level.isClientSide) {
                PacketHandler.sendToAllClient(new ParticleWardenDeathPacket(pos));
                BlockPos deathPos = event.getEntity().blockPosition();
                int radius = 6;
                int numberOfBlocks = 9;
                int numberOfTry = 100;
                int placed = 0;
                int tried = 0;
                while (tried < numberOfTry && placed < numberOfBlocks) {
                    int offsetZ;
                    int offsetY;
                    ++tried;
                    int offsetX = level.random.nextInt(radius * 2 + 1) - radius;
                    BlockPos randomPos = deathPos.offset(offsetX, offsetY = level.random.nextInt(radius * 2 + 1) - radius, offsetZ = level.random.nextInt(radius * 2 + 1) - radius);
                    if (!level.getBlockState(randomPos).isAir()) continue;
                    placed += WardenDeathEvent.placeDeepCristal(level, randomPos);
                }
            }
        }
    }

    private static int placeDeepCristal(Level level, BlockPos pos) {
        BlockState deepCristalState = ((Block)BlockRegistry.DEEP_CRISTAL.get()).defaultBlockState();
        if (level.getBlockState(pos.above()).isFaceSturdy((BlockGetter)level, pos.above(), Direction.DOWN)) {
            level.setBlock(pos, (BlockState)deepCristalState.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN), 3);
            return 1;
        }
        if (level.getBlockState(pos.north()).isFaceSturdy((BlockGetter)level, pos.north(), Direction.SOUTH)) {
            level.setBlock(pos, (BlockState)deepCristalState.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH), 3);
            return 1;
        }
        if (level.getBlockState(pos.south()).isFaceSturdy((BlockGetter)level, pos.south(), Direction.NORTH)) {
            level.setBlock(pos, (BlockState)deepCristalState.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH), 3);
            return 1;
        }
        if (level.getBlockState(pos.west()).isFaceSturdy((BlockGetter)level, pos.west(), Direction.EAST)) {
            level.setBlock(pos, (BlockState)deepCristalState.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST), 3);
            return 1;
        }
        if (level.getBlockState(pos.east()).isFaceSturdy((BlockGetter)level, pos.east(), Direction.WEST)) {
            level.setBlock(pos, (BlockState)deepCristalState.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST), 3);
            return 1;
        }
        if (level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP)) {
            level.setBlock(pos, (BlockState)deepCristalState.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP), 3);
            return 1;
        }
        return 0;
    }
}

