/*
 * Decompiled with CFR 0.152.
 */
package wardentools.events.gameevents;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wardentools.entity.custom.ContagionIncarnationEntity;
import wardentools.entity.custom.DeepLurkerEntity;

@Mod.EventBusSubscriber(modid="wardentools")
public class WardenTargetFilter {
    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        Warden warden;
        LivingEntity target;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Warden && ((target = (warden = (Warden)entity).getTarget()) instanceof DeepLurkerEntity || target instanceof ContagionIncarnationEntity)) {
            warden.setTarget(null);
            warden.setAggressive(false);
            warden.setLastHurtByMob(null);
            WardenTargetFilter.makeWardenBurrow(warden);
        }
    }

    private static void makeWardenBurrow(Warden warden) {
        Level level = warden.level();
        if (!level.isClientSide) {
            warden.getBrain().stopAll((ServerLevel)level, (LivingEntity)warden);
            warden.getBrain().clearMemories();
        }
    }
}

