/*
 * Decompiled with CFR 0.152.
 */
package wardentools.fluid;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class LiquidCorruptionFluid
extends ForgeFlowingFluid {
    public LiquidCorruptionFluid(ForgeFlowingFluid.Properties prop) {
        super(prop);
    }

    public boolean isSource(FluidState state) {
        return false;
    }

    public int getAmount(FluidState state) {
        return (Integer)state.getValue((Property)LEVEL);
    }

    public Item getBucket() {
        return Items.AIR;
    }

    public static class Flowing
    extends LiquidCorruptionFluid {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.registerDefaultState((FluidState)((FluidState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(7)));
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        @Override
        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        @Override
        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends LiquidCorruptionFluid {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        @Override
        public int getAmount(FluidState state) {
            return 8;
        }

        @Override
        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

