/*
 * Decompiled with CFR 0.152.
 */
package wardentools.gui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import wardentools.items.ItemRegistry;
import wardentools.items.armors.ArmorRegistry;

public class ModCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"wardentools");
    private static final Map<Tag, List<Supplier<Item>>> TAGGED_ITEMS = new HashMap<Tag, List<Supplier<Item>>>();
    private static final List<Supplier<Item>> ALL_ITEMS = new ArrayList<Supplier<Item>>();
    public static final RegistryObject<CreativeModeTab> ALL;
    public static final RegistryObject<CreativeModeTab> BLOCKS;
    public static final RegistryObject<CreativeModeTab> NATURE;
    public static final RegistryObject<CreativeModeTab> DARKTREE;
    public static final RegistryObject<CreativeModeTab> WHITETREE;
    public static final RegistryObject<CreativeModeTab> TOOLS;
    public static final RegistryObject<CreativeModeTab> CRYSTALS;
    public static final RegistryObject<CreativeModeTab> MISC;
    public static final RegistryObject<CreativeModeTab> EGG;

    public static void register(IEventBus eventBus) {
        CREATIVE_MODE_TABS.register(eventBus);
    }

    public static void addItemToTag(Tag tag, Supplier<Item> item) {
        TAGGED_ITEMS.computeIfAbsent(tag, k -> new ArrayList()).add(item);
    }

    public static void addItemToTag(Tag tag, Item item) {
        ModCreativeTabs.addItemToTag(tag, () -> item);
    }

    public static List<Supplier<Item>> getItemsByTag(Tag tag) {
        return TAGGED_ITEMS.getOrDefault((Object)tag, Collections.emptyList());
    }

    public static void addAllItemsFromRegistry() {
        Field[] fields;
        for (Field field : fields = ItemRegistry.class.getDeclaredFields()) {
            if (!RegistryObject.class.isAssignableFrom(field.getType())) continue;
            try {
                RegistryObject registryObject = (RegistryObject)field.get(null);
                ModCreativeTabs.addItemToAll((Supplier<Item>)registryObject);
            }
            catch (IllegalAccessException e) {
                System.out.println("Error while adding all items to creative tabs");
            }
        }
    }

    public static void addItemToAll(Supplier<Item> item) {
        ALL_ITEMS.add(item);
    }

    static {
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.ABYSSALITE);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.CHISELED_ABYSSALITE);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.ABYSSALITE_BRICKS);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.ABYSSALITE_BRICKS_STAIRS);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.ABYSSALITE_BRICKS_SLAB);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.ABYSSALITE_BRICKS_WALL);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.CRACKED_ABYSSALITE_BRICKS);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.CRACKED_ABYSSALITE_BRICKS_STAIR);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.CRACKED_ABYSSALITE_BRICKS_SLAB);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.CRACKED_ABYSSALITE_BRICKS_WALL);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.ABYSSALITE_COAL_ORE);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.ABYSSALITE_LAPIS_ORE);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.ABYSSALITE_REDSTONE_ORE);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.ABYSSALITE_DIAMOND_ORE);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.ABYSSALITE_DEEP_ORE);
        ModCreativeTabs.addItemToTag(Tag.ABYSSALITE, ItemRegistry.CORRUPTED_ABYSSALITE);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, Items.AMETHYST_SHARD);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, Items.AMETHYST_CLUSTER);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, Items.AMETHYST_BLOCK);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.RUBY_FRAGMENT);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.RUBY);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.RUBY_BLOCK);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.CITRINE_FRAGMENT);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.CITRINE);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.CITRINE_BLOCK);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.MALACHITE_FRAGMENT);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.MALACHITE);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.MALACHITE_BLOCK);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, Items.ECHO_SHARD);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.ECHO_CRISTAL);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.ECHO_BLOCK);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.PALE_SHARD);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.PALE_CRISTAL);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.PALE_CRISTAL_BLOCK);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.DEEP_FRAGMENT);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.DEEPCRISTAL);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.DEEPINGOTS);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.DEEPBLOCK);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.RADIANCE_FRAGMENT);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.RADIANCE_CRISTAL);
        ModCreativeTabs.addItemToTag(Tag.CRYSTALS, ItemRegistry.RADIANCE_INGOTS);
        ModCreativeTabs.addItemToTag(Tag.DEEP_ARMOR, ArmorRegistry.DEEPCRISTAL_HELMET);
        ModCreativeTabs.addItemToTag(Tag.DEEP_ARMOR, ArmorRegistry.DEEPCRISTAL_CHESTPLATE);
        ModCreativeTabs.addItemToTag(Tag.DEEP_ARMOR, ArmorRegistry.DEEPCRISTAL_LEGGINGS);
        ModCreativeTabs.addItemToTag(Tag.DEEP_ARMOR, ArmorRegistry.DEEPCRISTAL_BOOTS);
        ModCreativeTabs.addItemToTag(Tag.RADIANT_ARMOR, ArmorRegistry.RADIANCE_CRISTAL_HELMET);
        ModCreativeTabs.addItemToTag(Tag.RADIANT_ARMOR, ArmorRegistry.RADIANCE_CRISTAL_CHESTPLATE);
        ModCreativeTabs.addItemToTag(Tag.RADIANT_ARMOR, ArmorRegistry.RADIANCE_CRISTAL_LEGGINGS);
        ModCreativeTabs.addItemToTag(Tag.RADIANT_ARMOR, ArmorRegistry.RADIANCE_CRISTAL_BOOTS);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_LOG);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_WOOD);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.STRIPPED_DARKTREE_LOG);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.STRIPPED_DARKTREE_WOOD);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_PLANKS);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_LEAVES);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DEEP_FRUIT);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_SAPLING);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_STAIRS);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_SLAB);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_FENCE);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_BUTTON);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_DOOR);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_TRAPDOOR);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_FENCE_GATE);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_PRESSURE_PLATE);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARK_STICK);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_BOAT);
        ModCreativeTabs.addItemToTag(Tag.DARKTREE, ItemRegistry.DARKTREE_CHEST_BOAT);
        ModCreativeTabs.addItemToTag(Tag.DARK_VEGETAL, ItemRegistry.DEPTH_BERRIES);
        ModCreativeTabs.addItemToTag(Tag.DARK_VEGETAL, ItemRegistry.BLUE_BUSH);
        ModCreativeTabs.addItemToTag(Tag.DARK_VEGETAL, ItemRegistry.DEEPFLOWER);
        ModCreativeTabs.addItemToTag(Tag.DARK_VEGETAL, ItemRegistry.TALL_DARK_GRASS);
        ModCreativeTabs.addItemToTag(Tag.DARK_VEGETAL, ItemRegistry.DARK_GRASS);
        ModCreativeTabs.addItemToTag(Tag.DARK_VEGETAL, ItemRegistry.BLUE_GLOW_BERRIES);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_LOG);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_WOOD);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.STRIPPED_WHITETREE_LOG);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.STRIPPED_WHITETREE_WOOD);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_LEAVES);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITE_SEED);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_SAPLING);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_PLANKS);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_STAIRS);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_SLAB);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_FENCE);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_BUTTON);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_DOOR);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_TRAPDOOR);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_FENCE_GATE);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_PRESSURE_PLATE);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_BOAT);
        ModCreativeTabs.addItemToTag(Tag.WHITETREE, ItemRegistry.WHITETREE_CHEST_BOAT);
        ModCreativeTabs.addItemToTag(Tag.WHITE_VEGETAL, ItemRegistry.WHITE_GRASS);
        ModCreativeTabs.addItemToTag(Tag.WHITE_VEGETAL, ItemRegistry.TALL_WHITE_GRASS);
        ModCreativeTabs.addItemToTag(Tag.WHITE_VEGETAL, ItemRegistry.WHITE_TORCHFLOWER);
        ModCreativeTabs.addItemToTag(Tag.NATURE, ItemRegistry.NOCTILURE_FEATHER);
        ModCreativeTabs.addItemToTag(Tag.NATURE, ItemRegistry.WANDERER_PAW);
        ModCreativeTabs.addItemToTag(Tag.NATURE, ItemRegistry.NOCTILURE_TREAT);
        ModCreativeTabs.addItemToTag(Tag.NATURE, ItemRegistry.LURKER_EYE);
        ModCreativeTabs.addItemToTag(Tag.DIRT, ItemRegistry.DARKDIRT);
        ModCreativeTabs.addItemToTag(Tag.DIRT, ItemRegistry.DARKGRASS_BLOCK);
        ModCreativeTabs.addItemToTag(Tag.EGG, ItemRegistry.DEEPLURKER_EGG);
        ModCreativeTabs.addItemToTag(Tag.EGG, ItemRegistry.PALEWANDERER_EGG);
        ModCreativeTabs.addItemToTag(Tag.EGG, ItemRegistry.TEMPER_EGG);
        ModCreativeTabs.addItemToTag(Tag.EGG, ItemRegistry.PARASYTE_EGG);
        ModCreativeTabs.addItemToTag(Tag.EGG, ItemRegistry.PROTECTOR_EGG);
        ModCreativeTabs.addItemToTag(Tag.EGG, ItemRegistry.CONTAGION_INCARNATION_EGG);
        ModCreativeTabs.addItemToTag(Tag.EGG, ItemRegistry.NOCTILURE_EGG);
        ModCreativeTabs.addItemToTag(Tag.EGG, ItemRegistry.SHADOW_EGG);
        ModCreativeTabs.addItemToTag(Tag.EGG, ItemRegistry.CRYSTAL_GOLEM_SPAWN_EGG);
        ModCreativeTabs.addItemToTag(Tag.CORRUPTED, ItemRegistry.WARDEN_HEART);
        ModCreativeTabs.addItemToTag(Tag.CORRUPTED, ItemRegistry.CORRUPTED_ESSENCE);
        ModCreativeTabs.addItemToTag(Tag.CORRUPTED, ItemRegistry.CORRUPTED_VESSEL);
        ModCreativeTabs.addItemToTag(Tag.CORRUPTED, ItemRegistry.WIND_WHISPERER);
        ModCreativeTabs.addItemToTag(Tag.CORRUPTED, ItemRegistry.SOLID_CORRUPTION);
        ModCreativeTabs.addItemToTag(Tag.CORRUPTED, ItemRegistry.DYSFUNCTIONNING_CATALYST);
        ModCreativeTabs.addItemToTag(Tag.RADIANT, ItemRegistry.RADIANCE_CATALYST);
        ModCreativeTabs.addItemToTag(Tag.RADIANT, ItemRegistry.PURE_ESSENCE);
        ModCreativeTabs.addItemToTag(Tag.RADIANT, ItemRegistry.PURE_VESSEL);
        ModCreativeTabs.addItemToTag(Tag.RADIANT, ItemRegistry.PROTECTOR_HEART);
        ModCreativeTabs.addItemToTag(Tag.RADIANT, ItemRegistry.DYING_PROTECTOR_HEART);
        ModCreativeTabs.addItemToTag(Tag.RADIANT, ItemRegistry.PROTECTOR_INVOKER);
        ModCreativeTabs.addItemToTag(Tag.STAFF, ItemRegistry.ABYSS_DIVER);
        ModCreativeTabs.addItemToTag(Tag.STAFF, ItemRegistry.RADIANT_STAFF);
        ModCreativeTabs.addItemToTag(Tag.WEAPONS, ItemRegistry.ABYSSAL_SCYTHE);
        ModCreativeTabs.addItemToTag(Tag.WEAPONS, ItemRegistry.RADIANT_SPEAR);
        ModCreativeTabs.addItemToTag(Tag.SCULK, Items.SCULK);
        ModCreativeTabs.addItemToTag(Tag.SCULK, Items.SCULK_CATALYST);
        ModCreativeTabs.addItemToTag(Tag.SCULK, Items.SCULK_SENSOR);
        ModCreativeTabs.addItemToTag(Tag.SCULK, Items.SCULK_SHRIEKER);
        ModCreativeTabs.addItemToTag(Tag.SCULK, Items.SCULK_VEIN);
        ModCreativeTabs.addItemToTag(Tag.SCULK, ItemRegistry.SCULK_TENDRIL_BLOCK);
        ModCreativeTabs.addItemToTag(Tag.SCULK, ItemRegistry.LIVING_SPROUT);
        ModCreativeTabs.addItemToTag(Tag.BUILDING, ItemRegistry.BLACK_LANTERN);
        ModCreativeTabs.addItemToTag(Tag.BUILDING, ItemRegistry.REINFORCED_GLASS);
        ModCreativeTabs.addItemToTag(Tag.JEWELRY, ItemRegistry.MIND_TIARA);
        ModCreativeTabs.addItemToTag(Tag.JEWELRY, ItemRegistry.RING_OF_WILL);
        ModCreativeTabs.addItemToTag(Tag.JEWELRY, ItemRegistry.STRENGTH_BRACELET);
        ModCreativeTabs.addItemToTag(Tag.JEWELRY, ItemRegistry.PENDANT_OF_BALANCE);
        ModCreativeTabs.addItemToTag(Tag.JEWELRY, ItemRegistry.SHADOW_ORNAMENT);
        ModCreativeTabs.addItemToTag(Tag.JEWELRY, ItemRegistry.LIGHT_ORNAMENT);
        ModCreativeTabs.addItemToTag(Tag.MISC, ItemRegistry.CONTAGION_INCARNATION_SKULL);
        ModCreativeTabs.addItemToTag(Tag.MISC, ItemRegistry.SOUL_SPAWNER);
        ModCreativeTabs.addItemToTag(Tag.MISC, ItemRegistry.WHISTLE);
        ModCreativeTabs.addItemToTag(Tag.MISC, ItemRegistry.WIND_JOURNAL);
        ModCreativeTabs.addItemToTag(Tag.MISC, ItemRegistry.GRAMOPHONE);
        ModCreativeTabs.addItemToTag(Tag.MISC, ItemRegistry.SONIC_BLASTER);
        ModCreativeTabs.addItemToTag(Tag.MISC, ItemRegistry.CRYSTAL_RESONATOR);
        ModCreativeTabs.addItemToTag(Tag.MISC, ItemRegistry.CRYSTAL_INFUSER);
        ModCreativeTabs.addItemToTag(Tag.MISC, ItemRegistry.GOLEM_STONE);
        ModCreativeTabs.addItemToTag(Tag.MISC, ItemRegistry.ANCIENT_CITADEL_MAP);
        ModCreativeTabs.addItemToTag(Tag.DISC, ItemRegistry.ABYSS_MUSIC_DISC);
        ModCreativeTabs.addItemToTag(Tag.DISC, ItemRegistry.INCARNATION_MUSIC_DISC);
        ModCreativeTabs.addItemToTag(Tag.DISC, ItemRegistry.DEEP_FOREST_MUSIC_DISC);
        ModCreativeTabs.addItemToTag(Tag.DISC, ItemRegistry.WHITE_FOREST_MUSIC_DISC);
        ModCreativeTabs.addItemToTag(Tag.DISC, ItemRegistry.REFLECTION_MUSIC_DISC);
        ModCreativeTabs.addAllItemsFromRegistry();
        ALL = CREATIVE_MODE_TABS.register("all", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ItemRegistry.DARKGRASS_BLOCK.get())).title((Component)Component.translatable((String)"creativetab.all")).displayItems((pParameters, event) -> ALL_ITEMS.forEach(item -> event.accept((ItemLike)item.get()))).build());
        BLOCKS = CREATIVE_MODE_TABS.register("blocks", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ItemRegistry.ABYSSALITE.get())).title((Component)Component.translatable((String)"creativetab.blocks")).displayItems((pParameters, event) -> {
            ModCreativeTabs.getItemsByTag(Tag.DIRT).forEach(item -> event.accept((ItemLike)item.get()));
            ModCreativeTabs.getItemsByTag(Tag.ABYSSALITE).forEach(item -> event.accept((ItemLike)item.get()));
            ModCreativeTabs.getItemsByTag(Tag.SCULK).forEach(item -> event.accept((ItemLike)item.get()));
            ModCreativeTabs.getItemsByTag(Tag.BUILDING).forEach(item -> event.accept((ItemLike)item.get()));
        }).build());
        NATURE = CREATIVE_MODE_TABS.register("nature", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ItemRegistry.BLUE_GLOW_BERRIES.get())).title((Component)Component.translatable((String)"creativetab.nature")).displayItems((pParameters, event) -> {
            ModCreativeTabs.getItemsByTag(Tag.DARK_VEGETAL).forEach(item -> event.accept((ItemLike)item.get()));
            ModCreativeTabs.getItemsByTag(Tag.WHITE_VEGETAL).forEach(item -> event.accept((ItemLike)item.get()));
            ModCreativeTabs.getItemsByTag(Tag.NATURE).forEach(item -> event.accept((ItemLike)item.get()));
        }).build());
        DARKTREE = CREATIVE_MODE_TABS.register("darktree", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ItemRegistry.DARKTREE_LOG.get())).title((Component)Component.translatable((String)"creativetab.darktree")).displayItems((pParameters, event) -> ModCreativeTabs.getItemsByTag(Tag.DARKTREE).forEach(item -> event.accept((ItemLike)item.get()))).build());
        WHITETREE = CREATIVE_MODE_TABS.register("whitetree", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ItemRegistry.WHITETREE_LOG.get())).title((Component)Component.translatable((String)"creativetab.whitetree")).displayItems((pParameters, event) -> ModCreativeTabs.getItemsByTag(Tag.WHITETREE).forEach(item -> event.accept((ItemLike)item.get()))).build());
        TOOLS = CREATIVE_MODE_TABS.register("tools", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ArmorRegistry.DEEPCRISTAL_CHESTPLATE.get())).title((Component)Component.translatable((String)"creativetab.tools")).displayItems((pParameters, event) -> {
            ModCreativeTabs.getItemsByTag(Tag.DEEP_ARMOR).forEach(item -> event.accept((ItemLike)item.get()));
            ModCreativeTabs.getItemsByTag(Tag.RADIANT_ARMOR).forEach(item -> event.accept((ItemLike)item.get()));
            ModCreativeTabs.getItemsByTag(Tag.STAFF).forEach(item -> event.accept((ItemLike)item.get()));
            ModCreativeTabs.getItemsByTag(Tag.WEAPONS).forEach(item -> event.accept((ItemLike)item.get()));
        }).build());
        CRYSTALS = CREATIVE_MODE_TABS.register("crystals", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ItemRegistry.CITRINE_FRAGMENT.get())).title((Component)Component.translatable((String)"creativetab.crystals")).displayItems((pParameters, event) -> {
            ModCreativeTabs.getItemsByTag(Tag.CRYSTALS).forEach(item -> event.accept((ItemLike)item.get()));
            ModCreativeTabs.getItemsByTag(Tag.JEWELRY).forEach(item -> event.accept((ItemLike)item.get()));
        }).build());
        MISC = CREATIVE_MODE_TABS.register("misc", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ItemRegistry.CORRUPTED_ESSENCE.get())).title((Component)Component.translatable((String)"creativetab.misc")).displayItems((pParameters, event) -> {
            ModCreativeTabs.getItemsByTag(Tag.CORRUPTED).forEach(item -> event.accept((ItemLike)item.get()));
            ModCreativeTabs.getItemsByTag(Tag.RADIANT).forEach(item -> event.accept((ItemLike)item.get()));
            ModCreativeTabs.getItemsByTag(Tag.DISC).forEach(item -> event.accept((ItemLike)item.get()));
            ModCreativeTabs.getItemsByTag(Tag.MISC).forEach(item -> event.accept((ItemLike)item.get()));
        }).build());
        EGG = CREATIVE_MODE_TABS.register("egg", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ItemRegistry.DEEPLURKER_EGG.get())).title((Component)Component.translatable((String)"creativetab.egg")).displayItems((pParameters, event) -> ModCreativeTabs.getItemsByTag(Tag.EGG).forEach(item -> event.accept((ItemLike)item.get()))).build());
    }

    public static enum Tag {
        ABYSSALITE("abyssalite"),
        CRYSTALS("crystals"),
        DEEP_ARMOR("deep_armor"),
        RADIANT_ARMOR("radiant_armor"),
        DARKTREE("darktree"),
        DARK_VEGETAL("dark_vegetal"),
        WHITETREE("whitetree"),
        WHITE_VEGETAL("white_vegetal"),
        NATURE("nature"),
        DIRT("dirt"),
        EGG("egg"),
        CORRUPTED("corrupted"),
        RADIANT("radiant"),
        STAFF("staff"),
        WEAPONS("weapons"),
        SCULK("sculk"),
        BUILDING("building"),
        JEWELRY("jewelry"),
        MISC("misc"),
        DISC("disc");

        private final String key;

        private Tag(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

