/*
 * Decompiled with CFR 0.152.
 */
package wardentools.gui.menu;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;
import wardentools.blockentity.DysfunctionningCatalystBlockEntity;
import wardentools.gui.MenuRegistry;
import wardentools.gui.menu.slot.CrystalFragmentSlot;
import wardentools.misc.Crystal;

public class DysfunctionningCatalystMenu
extends AbstractContainerMenu {
    private final DysfunctionningCatalystBlockEntity blockEntity;
    private final ContainerLevelAccess levelAccess;
    private final ContainerData data;

    public DysfunctionningCatalystMenu(int containerId, Inventory playerInventory, FriendlyByteBuf additionalData) {
        this(containerId, playerInventory, playerInventory.player.level().getBlockEntity(additionalData.readBlockPos()), (ContainerData)new SimpleContainerData(8));
    }

    public DysfunctionningCatalystMenu(int containerId, Inventory playerInventory, BlockEntity blockEntity, ContainerData data) {
        super((MenuType)MenuRegistry.DYSFUNCTIONNING_CATALYST_MENU.get(), containerId);
        DysfunctionningCatalystBlockEntity be;
        if (!(blockEntity instanceof DysfunctionningCatalystBlockEntity)) {
            throw new IllegalStateException("Incorrect block entity class (%s) passed into DysfunctionningCatalystMenu!".formatted(blockEntity.getClass().getCanonicalName()));
        }
        this.blockEntity = be = (DysfunctionningCatalystBlockEntity)blockEntity;
        this.levelAccess = ContainerLevelAccess.create((Level)Objects.requireNonNull(blockEntity.getLevel()), (BlockPos)blockEntity.getBlockPos());
        this.data = data;
        this.createPlayerHotbar(playerInventory);
        this.createPlayerInventory(playerInventory);
        this.createBlockEntityInventory(be);
        this.addDataSlots(data);
    }

    private void createBlockEntityInventory(DysfunctionningCatalystBlockEntity be) {
        be.getInventoryOptional().ifPresent(inventory -> {
            this.addSlot((Slot)new CrystalFragmentSlot((IItemHandler)inventory, 0, 15, 15, Crystal.AMETHYST));
            this.addSlot((Slot)new CrystalFragmentSlot((IItemHandler)inventory, 1, 15, 42, Crystal.CITRINE));
            this.addSlot((Slot)new CrystalFragmentSlot((IItemHandler)inventory, 2, 15, 70, Crystal.ECHO));
            this.addSlot((Slot)new CrystalFragmentSlot((IItemHandler)inventory, 3, 145, 15, Crystal.RUBY));
            this.addSlot((Slot)new CrystalFragmentSlot((IItemHandler)inventory, 4, 145, 42, Crystal.MALACHITE));
            this.addSlot((Slot)new CrystalFragmentSlot((IItemHandler)inventory, 5, 145, 70, Crystal.PALE));
        });
    }

    private void createPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)playerInventory, 9 + column + row * 9, 8 + column * 18, 105 + row * 18));
            }
        }
    }

    private void createPlayerHotbar(Inventory playerInventory) {
        for (int column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)playerInventory, column, 8 + column * 18, 163));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot fromSlot = this.getSlot(index);
        ItemStack fromStack = fromSlot.getItem();
        if (fromStack.getCount() <= 0) {
            fromSlot.set(ItemStack.EMPTY);
        }
        if (!fromSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack copyFromStack = fromStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(fromStack, 36, 42, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 42) {
            if (!this.moveItemStackTo(fromStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.err.println("Invalid slot index: " + index);
            return ItemStack.EMPTY;
        }
        fromSlot.setChanged();
        fromSlot.onTake(player, fromStack);
        return copyFromStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return DysfunctionningCatalystMenu.stillValid((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)BlockRegistry.DYSFUNCTIONNING_CATALYST.get()));
    }

    public DysfunctionningCatalystBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public int getCitrineProgression() {
        return this.data.get(0);
    }

    public int getAmethystProgression() {
        return this.data.get(1);
    }

    public int getPaleProgression() {
        return this.data.get(2);
    }

    public int getRubyProgression() {
        return this.data.get(3);
    }

    public int getMalachiteProgression() {
        return this.data.get(4);
    }

    public int getEchoProgression() {
        return this.data.get(5);
    }

    public int getTotalCharge() {
        return this.data.get(6);
    }

    public int getEyeProgression() {
        return this.data.get(7);
    }
}

