/*
 * Decompiled with CFR 0.152.
 */
package wardentools.gui.windscreen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wardentools.gui.windscreen.CheckButton;
import wardentools.network.PacketHandler;
import wardentools.playerdata.tasks.TaskDataProvider;
import wardentools.playerdata.tasks.TaskDataSyncServerPacket;

@OnlyIn(value=Dist.CLIENT)
public class TaskNoteAccess {
    public static final int HEIGHT_OF_ONE_TASK = 24;
    public static final int LENGTH_OF_ONE_TASK = 42;
    public static final int ICON_TO_BUTTON_MARGIN = 36;
    public static final int Y_TASK_MARGIN = 3;
    public List<List<Task>> sections = new ArrayList<List<Task>>();
    private static final Map<Integer, Task> tasks = new HashMap<Integer, Task>();

    public TaskNoteAccess() {
        this.buildHasCompletedTask();
        this.buildSections();
    }

    private void buildSections() {
        int i = 0;
        while (i < tasks.size()) {
            int line = 0;
            ArrayList<Task> page = new ArrayList<Task>();
            while (line < 120 && i < tasks.size()) {
                Task task = tasks.get(i);
                if (task == null) continue;
                page.add(task);
                line += 27;
                ++i;
            }
            if (page.isEmpty()) continue;
            this.sections.add(page);
        }
    }

    private void buildHasCompletedTask() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        player.getCapability(TaskDataProvider.TASKS_CAPABILITY).ifPresent(data -> {
            for (int i : data.getAll()) {
                Task task = tasks.get(i);
                if (task == null) continue;
                task.setOk(true);
            }
        });
    }

    public List<Task> getTaskPage(int index) {
        if (index < 0 || index >= this.sections.size()) {
            return new ArrayList<Task>();
        }
        return this.sections.get(index);
    }

    public int getPageCount() {
        return this.sections.size();
    }

    public List<CheckButton> getTaskButtons(int index, int x_left, int y_top) {
        ArrayList<CheckButton> buttons = new ArrayList<CheckButton>();
        if (index < 0 || index >= this.sections.size()) {
            return buttons;
        }
        for (int i = 0; i < this.sections.get(index).size(); ++i) {
            Task task = this.sections.get(index).get(i);
            buttons.add(new CheckButton(x_left + 42 + 36, y_top - 10 + 27 * i, task, task::defaultOnPress));
        }
        return buttons;
    }

    public void updateTaskButtonXPos(CheckButton button, int x_left) {
        button.updateXPos(x_left + 42 + 36);
    }

    static {
        tasks.put(0, new Task(0, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/wind_journal/deepforest.png")));
        tasks.put(1, new Task(1, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/wind_journal/whiteforest.png")));
        tasks.put(2, new Task(2, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/wind_journal/crystal_cave.png")));
        tasks.put(3, new Task(3, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/wind_journal/waste_land.png")));
        tasks.put(4, new Task(4, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/wind_journal/ancient_citadel.png")));
        tasks.put(5, new Task(5, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/wind_journal/noctilure.png")));
        tasks.put(6, new Task(6, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/wind_journal/protector.png")));
        tasks.put(7, new Task(7, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/wind_journal/portal.png")));
        tasks.put(8, new Task(8, ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/wind_journal/incarnation.png")));
    }

    public static class Task {
        int id;
        private ResourceLocation icon = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/wind_journal/default_task.png");
        boolean isOk = false;

        public Task(int id) {
            this.id = id;
        }

        public Task(int id, ResourceLocation icon) {
            this.id = id;
            this.icon = icon;
        }

        public void setOk(boolean isOk) {
            this.isOk = isOk;
        }

        public void switchState() {
            this.isOk = !this.isOk;
        }

        public Component getHoveredText() {
            return Component.empty().withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Task.hoveredTranslatableText(this.getLangName()))));
        }

        public ResourceLocation getIcon() {
            return this.icon;
        }

        private String getLangName() {
            return "message.wardentools.wind_task." + this.id;
        }

        public void defaultOnPress(Button button) {
            this.switchState();
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            player.getCapability(TaskDataProvider.TASKS_CAPABILITY).ifPresent(completedTasks -> {
                if (!completedTasks.taskCompleted(this.id)) {
                    completedTasks.addCompletedTask(this.id);
                } else {
                    completedTasks.removeCompletedTask(this.id);
                }
                PacketHandler.sendToServer(new TaskDataSyncServerPacket(this.id));
            });
        }

        public static Component hoveredTranslatableText(String text) {
            return Component.translatable((String)text).withStyle(ChatFormatting.GRAY);
        }
    }
}

