/*
 * Decompiled with CFR 0.152.
 */
package wardentools.gui.windscreen;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.gui.windscreen.CheckButton;
import wardentools.gui.windscreen.JournalAccess;
import wardentools.gui.windscreen.JumpToTaskButton;
import wardentools.gui.windscreen.TaskNoteAccess;

@OnlyIn(value=Dist.CLIENT)
public class WindJournalScreen
extends Screen {
    public static final int PAGE_TEXT_X_OFFSET = 18;
    public static final int PAGE_TEXT_Y_OFFSET = 30;
    public static final ResourceLocation JOURNAL_FIRST_PAGE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/wind_journal/wind_journal_first.png");
    public static final ResourceLocation JOURNAL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/wind_journal/wind_journal.png");
    public static final ChatFormatting TEXT_COLOR = ChatFormatting.DARK_RED;
    protected static final int TOP_MARGIN = 10;
    protected static final int TEXTURE_WIDTH = 292;
    protected static final int TEXTURE_HEIGHT = 180;
    protected static final int TEXT_WIDTH = 114;
    protected static final int TEXT_HEIGHT = 128;
    protected static final int LINE_HEIGHT = 9;
    protected static final int MAX_LINES_PER_PAGE = 14;
    private final JournalAccess journalAccess;
    private final TaskNoteAccess taskNoteAccess;
    private int currentLeftPageIndex;
    private List<FormattedCharSequence> cachedLeftPageLines = Collections.emptyList();
    private List<FormattedCharSequence> cachedRightPageLines = Collections.emptyList();
    private List<TaskNoteAccess.Task> cachedRightTaskPage;
    private List<TaskNoteAccess.Task> cachedLeftTaskPage;
    private List<CheckButton> cachedLeftTaskButtons;
    private List<CheckButton> cachedRightTaskButtons;
    private int cachedLeftPageIndex = -1;
    private Component leftPageIndicatorText = CommonComponents.EMPTY;
    private Component rightPageIndicatorText;
    private PageButton nextPageButton;
    private PageButton previousPageButton;
    private Button firstPageButton;
    private Button jumpToTaskButton;
    private final boolean playSoundOnPageTurn;

    public WindJournalScreen() {
        this(new JournalAccess(), new TaskNoteAccess(), true);
    }

    private WindJournalScreen(JournalAccess journalAccess, TaskNoteAccess taskNoteAccess, boolean playSoundOnPageTurn) {
        super(GameNarrator.NO_TITLE);
        this.journalAccess = journalAccess;
        this.taskNoteAccess = taskNoteAccess;
        this.playSoundOnPageTurn = playSoundOnPageTurn;
    }

    public boolean setPage(int doublePageIndex) {
        int clampedPageIndex = Mth.clamp((int)doublePageIndex, (int)0, (int)(this.getTotalPageCount() - 1));
        int newPageIndex = clampedPageIndex - clampedPageIndex % 2;
        if (newPageIndex != this.currentLeftPageIndex) {
            this.currentLeftPageIndex = newPageIndex;
            this.updatePageButtonVisibility();
            this.cachedLeftPageIndex = -1;
            return true;
        }
        return false;
    }

    protected boolean forcePage(int pageIndex) {
        return this.setPage(pageIndex);
    }

    protected void init() {
        this.journalAccess.initPages(this.font);
        this.createMenuControls();
        this.createPageControlButtons();
    }

    protected void createMenuControls() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - 100, 196, 200, 20).build());
    }

    protected void createPageControlButtons() {
        int buttonXMargin = 20;
        this.nextPageButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.leftMargin() + 292 - 2 * buttonXMargin - 4, this.footerYPosition(), true, button -> this.goToNextPage(), this.playSoundOnPageTurn));
        this.previousPageButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.leftMargin() + buttonXMargin, this.footerYPosition(), false, button -> this.goToPreviousPage(), this.playSoundOnPageTurn));
        this.firstPageButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)" <-"), button -> this.setPage(0)).bounds(292 + this.leftMargin() + 5, 12, 12, 12).build());
        this.jumpToTaskButton = (Button)this.addRenderableWidget((GuiEventListener)new JumpToTaskButton(this.leftMargin() + 7, 88, button -> this.setPage(this.getJournalPageCount() + 2)));
        this.updatePageButtonVisibility();
    }

    private int getTotalPageCount() {
        return this.getJournalPageCount() + this.taskNoteAccess.getPageCount();
    }

    private int getJournalPageCount() {
        int journalPages = this.journalAccess.getPageCount();
        if (journalPages % 2 == 0) {
            ++journalPages;
        }
        return journalPages;
    }

    protected void goToPreviousPage() {
        if (this.currentLeftPageIndex > 0) {
            this.currentLeftPageIndex -= 2;
        }
        this.updatePageButtonVisibility();
    }

    protected void goToNextPage() {
        if (this.currentLeftPageIndex < this.getTotalPageCount() - 1) {
            this.currentLeftPageIndex += 2;
        }
        this.updatePageButtonVisibility();
    }

    private void updatePageButtonVisibility() {
        this.nextPageButton.visible = this.currentLeftPageIndex < this.getTotalPageCount() - 1;
        this.firstPageButton.visible = this.currentLeftPageIndex != 0;
        this.previousPageButton.visible = this.currentLeftPageIndex > 0;
        this.jumpToTaskButton.visible = this.currentLeftPageIndex == 0;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return switch (keyCode) {
            case 266 -> {
                this.previousPageButton.onPress();
                yield true;
            }
            case 267 -> {
                this.nextPageButton.onPress();
                yield true;
            }
            default -> false;
        };
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.updateCache();
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.cachedLeftPageIndex == 0) {
            this.renderFirstPage(graphics);
        } else if (this.currentLeftPageIndex <= this.journalAccess.getPageCount()) {
            this.renderPages(graphics);
        } else {
            this.renderTaskPages(graphics, mouseX, mouseY, partialTick);
        }
        this.renderHoverStyle(graphics, mouseX, mouseY);
        this.nextPageButton.setFocused(false);
        this.previousPageButton.setFocused(false);
        this.firstPageButton.setFocused(false);
    }

    private void updateCache() {
        if (this.cachedLeftPageIndex != this.currentLeftPageIndex) {
            int maxPages = Math.max(this.getTotalPageCount(), 1);
            maxPages += 1 - maxPages % 2;
            if (this.currentLeftPageIndex == 0) {
                this.cachedRightPageLines = this.journalAccess.getPage(this.currentLeftPageIndex);
                this.removeAllButtons(this.cachedLeftTaskButtons);
                this.removeAllButtons(this.cachedRightTaskButtons);
            } else if (this.currentLeftPageIndex <= this.getJournalPageCount()) {
                this.cachedLeftPageLines = this.journalAccess.getPage(this.currentLeftPageIndex - 1);
                this.cachedRightPageLines = this.journalAccess.getPage(this.currentLeftPageIndex);
                this.leftPageIndicatorText = JournalAccess.baseText(this.currentLeftPageIndex + "/" + maxPages);
                this.removeAllButtons(this.cachedLeftTaskButtons);
                this.removeAllButtons(this.cachedRightTaskButtons);
            } else {
                int trunkIndex = this.currentLeftPageIndex - this.getJournalPageCount();
                this.cachedLeftTaskPage = this.taskNoteAccess.getTaskPage(trunkIndex - 1);
                this.cachedRightTaskPage = this.taskNoteAccess.getTaskPage(trunkIndex);
                this.cachedLeftTaskButtons = this.taskNoteAccess.getTaskButtons(trunkIndex - 1, this.leftMargin() + 18, 40);
                this.cachedRightTaskButtons = this.taskNoteAccess.getTaskButtons(trunkIndex, this.rightPageXStart() + 18, 40);
                this.leftPageIndicatorText = JournalAccess.baseText(this.currentLeftPageIndex + "/" + maxPages);
                this.addAllButtons(this.cachedLeftTaskButtons);
                this.addAllButtons(this.cachedRightTaskButtons);
            }
            this.rightPageIndicatorText = JournalAccess.baseText(this.currentLeftPageIndex + 1 + "/" + maxPages);
            this.cachedLeftPageIndex = this.currentLeftPageIndex;
        }
    }

    private void addAllButtons(@Nullable List<CheckButton> checkButtons) {
        if (checkButtons == null) {
            return;
        }
        for (CheckButton button : checkButtons) {
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    private void removeAllButtons(@Nullable List<CheckButton> checkButtons) {
        if (checkButtons == null) {
            return;
        }
        for (CheckButton button : checkButtons) {
            this.removeWidget((GuiEventListener)button);
        }
    }

    private void renderHoverStyle(GuiGraphics graphics, int mouseX, int mouseY) {
        Style stylePageAt = this.getStylePage(mouseX, mouseY);
        if (stylePageAt != null) {
            graphics.renderComponentHoverEffect(this.font, stylePageAt, mouseX, mouseY);
        }
    }

    private Style getStylePage(int mouseX, int mouseY) {
        return this.cachedLeftPageIndex <= this.journalAccess.getTableOfContentLength() ? this.getStyleUnderMouseOnTableOfContentPage(mouseX, mouseY) : WindJournalScreen.getStyleUnderMouse(this.font, this.cachedLeftPageLines, mouseX, mouseY, this.rightPageXStart(), 30, 114, 9);
    }

    private void renderPages(GuiGraphics graphics) {
        Objects.requireNonNull(this.font);
        this.renderPage(graphics, false);
        this.renderPage(graphics, true);
    }

    private void renderTaskPages(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.cachedLeftTaskPage != null) {
            this.renderTaskPage(graphics, false, mouseX, mouseY, partialTick);
        }
        if (this.cachedRightTaskPage != null) {
            this.renderTaskPage(graphics, true, mouseX, mouseY, partialTick);
        }
    }

    private void renderFirstPage(GuiGraphics graphics) {
        this.renderPage(graphics, true);
    }

    private void renderPage(GuiGraphics graphics, boolean isRightPage) {
        List<FormattedCharSequence> pageLines = isRightPage ? this.cachedRightPageLines : this.cachedLeftPageLines;
        int visibleRightLines = Math.min(14, pageLines.size());
        int textX = !isRightPage ? this.leftMargin() + 18 : this.rightPageXStart();
        for (int lineIndex = 0; lineIndex < visibleRightLines; ++lineIndex) {
            FormattedCharSequence line = pageLines.get(lineIndex);
            Font currentFont = this.font;
            Objects.requireNonNull(this.font);
            graphics.drawString(currentFont, line, textX, 30 + lineIndex * 9, 0, false);
        }
        this.renderPageIndex(graphics, isRightPage);
    }

    private void renderTaskPage(GuiGraphics graphics, boolean isRightPage, int mouseX, int mouseY, float partialTick) {
        List<TaskNoteAccess.Task> pageTasks = isRightPage ? this.cachedRightTaskPage : this.cachedLeftTaskPage;
        int xPos = isRightPage ? this.rightPageXStart() : this.leftMargin() + 18 + 10;
        for (int i = 0; i < pageTasks.size(); ++i) {
            TaskNoteAccess.Task task = pageTasks.get(i);
            ResourceLocation icon = task.getIcon();
            int yPos = 25 + i * 27;
            graphics.blit(icon, xPos, yPos, 0.0f, 0.0f, 42, 24, 42, 24);
            if (!this.isHovering(xPos, yPos, 42, 24, mouseX, mouseY)) continue;
            graphics.renderComponentHoverEffect(this.font, task.getHoveredText().getStyle(), mouseX, mouseY);
        }
        this.renderPageIndex(graphics, isRightPage);
    }

    private void renderPageIndex(GuiGraphics graphics, boolean isRightPage) {
        Component pageIndicatorText;
        Component component = pageIndicatorText = isRightPage ? this.rightPageIndicatorText : this.leftPageIndicatorText;
        int xPosition = isRightPage ? this.leftMargin() + 146 + 11 - (this.currentLeftPageIndex > 9 ? 5 : 0) : this.leftMargin() + 146 - 34;
        graphics.drawString(this.font, pageIndicatorText, xPosition, this.footerYPosition(), 0, false);
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(graphics);
        if (this.cachedLeftPageIndex == 0) {
            graphics.blit(JOURNAL_FIRST_PAGE_TEXTURE, this.leftMargin(), 10, 0.0f, 0.0f, 292, 180, 292, 180);
        } else {
            graphics.blit(JOURNAL_TEXTURE, this.leftMargin(), 10, 0.0f, 0.0f, 292, 180, 292, 180);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Style clickedStyle;
        if (button == 0 && (clickedStyle = this.getStylePage((int)mouseX, (int)mouseY)) != null && this.handleComponentClicked(clickedStyle)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private int leftMargin() {
        return (this.width - 292) / 2;
    }

    private int footerYPosition() {
        return 167;
    }

    public boolean handleComponentClicked(@Nullable Style style) {
        if (style == null) {
            return false;
        }
        ClickEvent clickEvent = style.getClickEvent();
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.getAction() == ClickEvent.Action.CHANGE_PAGE) {
            String pageValue = clickEvent.getValue();
            try {
                int pageIndex = Integer.parseInt(pageValue) - 1;
                return this.forcePage(pageIndex);
            }
            catch (Exception exception) {
                return false;
            }
        }
        boolean handled = super.handleComponentClicked(style);
        if (handled && clickEvent.getAction() == ClickEvent.Action.RUN_COMMAND) {
            this.closeScreen();
        }
        return handled;
    }

    protected void closeScreen() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(null);
        }
    }

    public int rightPageXStart() {
        return this.leftMargin() + 114 + 54 - 8;
    }

    private boolean isHovering(int x1, int y1, int x2, int y2, int mouseX, int mouseY) {
        return x1 <= mouseX && y1 <= mouseY && x1 + x2 >= mouseX && y1 + y2 >= mouseY;
    }

    @Nullable
    public static Style getStyleUnderMouse(Font font, List<FormattedCharSequence> lines, double mouseX, double mouseY, int textStartX, int textStartY, int maxWidth, int lineHeight) {
        int relativeX = Mth.floor((double)(mouseX - (double)textStartX));
        int relativeY = Mth.floor((double)(mouseY - (double)textStartY));
        if (relativeX < 0 || relativeY < 0 || relativeX > maxWidth) {
            return null;
        }
        int lineIndex = relativeY / lineHeight;
        if (lineIndex >= lines.size()) {
            return null;
        }
        FormattedCharSequence line = lines.get(lineIndex);
        return font.getSplitter().componentStyleAtWidth(line, relativeX);
    }

    @Nullable
    private Style getStyleUnderMouseOnTableOfContentPage(double mouseX, double mouseY) {
        int tocPageIndex;
        boolean overRightPage;
        List<List<Component>> tocPages = this.journalAccess.getTableOfContentComponents();
        if (tocPages == null || tocPages.isEmpty()) {
            return null;
        }
        boolean bl = overRightPage = mouseX >= (double)this.rightPageXStart();
        if (this.currentLeftPageIndex == 0) {
            if (!overRightPage) {
                return null;
            }
            tocPageIndex = 0;
        } else {
            int n = tocPageIndex = overRightPage ? this.currentLeftPageIndex : this.currentLeftPageIndex - 1;
        }
        if (tocPageIndex < 0 || tocPageIndex >= tocPages.size()) {
            return null;
        }
        List<Component> pageLines = tocPages.get(tocPageIndex);
        int pageTextStartX = overRightPage ? this.rightPageXStart() : this.leftMargin() + 18;
        int relativeX = Mth.floor((double)(mouseX - (double)pageTextStartX));
        int extraYOffset = tocPageIndex == 0 ? this.journalAccess.tableOfContentComponentYOffset : 0;
        int relativeY = Mth.floor((double)(mouseY - 30.0 - (double)extraYOffset));
        if (relativeX < 0 || relativeY < 0 || relativeX > 114) {
            return null;
        }
        int lineIndex = relativeY / 9;
        if (lineIndex >= pageLines.size()) {
            return null;
        }
        Component line = pageLines.get(lineIndex);
        return this.font.getSplitter().componentStyleAtWidth(line.getVisualOrderText(), relativeX);
    }
}

