/*
 * Decompiled with CFR 0.152.
 */
package wardentools.gui.winscreen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.network.PacketHandler;
import wardentools.network.SwitchAchievement;
import wardentools.sounds.ModMusics;

@OnlyIn(value=Dist.CLIENT)
public class ChoiceScreen
extends Screen {
    private static final ResourceLocation VIGNETTE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/misc/vignette.png");
    private static final ResourceLocation CORRUPTION_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/choice_screen/corruption.png");
    private static final ResourceLocation RADIANCE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/choice_screen/radiance.png");
    private static final ResourceLocation CORRUPTION_BUTTON_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/choice_screen/corruption_button_overlay.png");
    private static final ResourceLocation RADIANCE_BUTTON_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/choice_screen/radiance_button_overlay.png");
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 20;
    private static final int OVERLAY_MARGIN = 40;
    private final Runnable onFinished;
    private Button contagionButton;
    private Button radianceButton;
    private float spreadFactor = 0.5f;
    private static final float MAX_CENTER_FACTOR = 0.7f;
    private static final float MIN_CENTER_FACTOR = 0.3f;
    private static final float SPREAD_FACTOR = 0.02f;
    private long seed = 123456789L;
    private int fadeInTick = 0;
    private static final int FADE_IN_DURATION = 80;

    public ChoiceScreen(Runnable runnable) {
        super(GameNarrator.NO_TITLE);
        this.onFinished = runnable;
    }

    protected void init() {
        Minecraft.getInstance().getMusicManager().startPlaying(this.getBackgroundMusic());
        int spacing = 30;
        int x1 = this.width / 2 - 100 - spacing;
        int x2 = this.width / 2 + spacing;
        int y = this.height / 2 - 10;
        this.contagionButton = Button.builder((Component)Component.literal((String)"Contagion"), button -> this.onContagionClicked()).bounds(x1, y, 100, 20).build();
        this.radianceButton = Button.builder((Component)Component.literal((String)"Radiance"), button -> this.onRadianceClicked()).bounds(x2, y, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.radianceButton);
        this.addRenderableWidget((GuiEventListener)this.contagionButton);
        this.seed = new Random().nextLong();
        this.fadeInTick = 80;
    }

    public void tick() {
        if (this.fadeInTick > 0) {
            --this.fadeInTick;
        }
        if (this.minecraft != null) {
            this.minecraft.getMusicManager().tick();
            this.minecraft.getSoundManager().tick(false);
            if (!this.minecraft.getMusicManager().isPlayingMusic(ModMusics.DEEP_FOREST)) {
                this.minecraft.getMusicManager().startPlaying(ModMusics.DEEP_FOREST);
            }
        }
        if (this.radianceButton.isHovered() && this.spreadFactor < 0.7f) {
            this.spreadFactor += 0.02f;
        } else if (this.contagionButton.isHovered() && this.spreadFactor > 0.3f) {
            this.spreadFactor -= 0.02f;
        } else if (!this.radianceButton.isHovered() && !this.contagionButton.isHovered()) {
            if (this.spreadFactor > 0.51f) {
                this.spreadFactor -= 0.02f;
            } else if (this.spreadFactor < 0.49f) {
                this.spreadFactor += 0.02f;
            }
        }
    }

    public void onClose() {
        this.respawn();
    }

    private void respawn() {
        this.onFinished.run();
    }

    private void onRadianceClicked() {
        PacketHandler.sendToServer(new SwitchAchievement(0));
        this.respawn();
    }

    private void onContagionClicked() {
        PacketHandler.sendToServer(new SwitchAchievement(1));
        this.respawn();
    }

    public void render(@NotNull GuiGraphics graphics, int x, int y, float a) {
        super.render(graphics, x, y, a);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR);
        graphics.blit(VIGNETTE_LOCATION, 0, 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        this.renderButtonOverlay(graphics);
    }

    private void renderButtonOverlay(@NotNull GuiGraphics graphics) {
        graphics.blit(CORRUPTION_BUTTON_OVERLAY, this.contagionButton.getX() - 20, this.contagionButton.getY() - 20, 0, 0.0f, 0.0f, this.contagionButton.getWidth() + 40, this.contagionButton.getHeight() + 40, this.contagionButton.getWidth() + 40, this.contagionButton.getHeight() + 40);
        graphics.blit(RADIANCE_BUTTON_OVERLAY, this.radianceButton.getX() - 20, this.radianceButton.getY() - 20, 0, 0.0f, 0.0f, this.radianceButton.getWidth() + 40, this.radianceButton.getHeight() + 40, this.radianceButton.getWidth() + 40, this.radianceButton.getHeight() + 40);
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int x, int y, float a) {
        Random random = new Random(this.seed);
        graphics.setColor(0.5f, 0.5f, 0.5f, 1.0f);
        float min = 0.1f * (float)this.width;
        float max = 0.8f * (float)this.width;
        for (int i = 0; i < this.width / 16 + 1; ++i) {
            for (int j = 0; j < this.height / 16 + 1; ++j) {
                if ((float)(i * 16) < min) {
                    graphics.blit(CORRUPTION_LOCATION, i * 16, j * 16, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                    continue;
                }
                if ((float)(i * 16) > max) {
                    graphics.blit(RADIANCE_LOCATION, i * 16, j * 16, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                    continue;
                }
                float distanceFromLeft = (float)i * 16.0f - min;
                float maxDistance = max - min;
                float contagionProbability = Math.max(0.0f, 1.0f - distanceFromLeft / maxDistance * (2.0f * this.spreadFactor));
                if (random.nextFloat() < contagionProbability) {
                    graphics.blit(CORRUPTION_LOCATION, i * 16, j * 16, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                    continue;
                }
                graphics.blit(RADIANCE_LOCATION, i * 16, j * 16, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
    }

    public void removed() {
        if (this.minecraft != null) {
            this.minecraft.getMusicManager().stopPlaying(this.getBackgroundMusic());
        }
    }

    @NotNull
    public Music getBackgroundMusic() {
        return ModMusics.DEEP_FOREST;
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }
}

