/*
 * Decompiled with CFR 0.152.
 */
package wardentools.gui.winscreen;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import wardentools.gui.winscreen.ChoiceScreen;
import wardentools.sounds.ModMusics;

@OnlyIn(value=Dist.CLIENT)
public class CustomWinScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation VIGNETTE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/misc/vignette.png");
    private static final ResourceLocation WIN_TXT = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"texts/win.txt");
    private static final ResourceLocation MOD_CREDITS = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"texts/mod_credits.json");
    private static final ResourceLocation POSTCREDITS_LOCATION = ResourceLocation.withDefaultNamespace((String)"texts/postcredits.txt");
    private static final ResourceLocation MOD_BACKGROUND_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/background.png");
    private static final Component SECTION_HEADING = Component.literal((String)"========================").withStyle(ChatFormatting.WHITE);
    private static final String OBFUSCATE_TOKEN = String.valueOf(ChatFormatting.YELLOW) + String.valueOf(ChatFormatting.OBFUSCATED) + String.valueOf(ChatFormatting.GREEN) + String.valueOf(ChatFormatting.AQUA);
    private static final float SPEEDUP_FACTOR = 5.0f;
    private static final float SPEEDUP_FACTOR_FAST = 15.0f;
    private final boolean poem;
    private final Runnable onFinished;
    private float scroll;
    private List<FormattedCharSequence> lines;
    private IntSet centeredLines;
    private int totalScrollLength;
    private boolean speedupActive;
    private final IntSet speedupModifiers = new IntOpenHashSet();
    private float scrollSpeed;
    private final float unmodifiedScrollSpeed;
    private int direction;
    private final LogoRenderer logoRenderer = new LogoRenderer(false);
    private int musicTickCountDown = 0;
    private static final int MUSIC_TICK_COUNTDOWN = 80;

    public CustomWinScreen(boolean hasPoem, Runnable runnable) {
        super(GameNarrator.NO_TITLE);
        this.poem = hasPoem;
        this.onFinished = runnable;
        this.unmodifiedScrollSpeed = !hasPoem ? 0.75f : 0.5f;
        this.direction = 1;
        this.scrollSpeed = this.unmodifiedScrollSpeed;
    }

    private float calculateScrollSpeed() {
        return this.speedupActive ? this.unmodifiedScrollSpeed * (5.0f + (float)this.speedupModifiers.size() * 15.0f) * (float)this.direction : this.unmodifiedScrollSpeed * (float)this.direction;
    }

    public void tick() {
        if (this.minecraft != null) {
            this.minecraft.getSoundManager().tick(false);
        }
        if (this.musicTickCountDown == 1 && this.minecraft != null) {
            this.minecraft.getMusicManager().startPlaying(this.getBackgroundMusic());
            --this.musicTickCountDown;
        } else if (this.musicTickCountDown > 0) {
            --this.musicTickCountDown;
        }
        float f = this.totalScrollLength + this.height + this.height + 24;
        if (this.scroll > f) {
            this.changeToChoiceScreen();
        }
    }

    public boolean keyPressed(int key, int i, int j) {
        if (key == 265) {
            this.direction = -1;
        } else if (key != 341 && key != 345) {
            if (key == 32) {
                this.speedupActive = true;
            } else {
                this.speedupModifiers.add(key);
            }
        }
        this.scrollSpeed = this.calculateScrollSpeed();
        return super.keyPressed(key, i, j);
    }

    public boolean keyReleased(int key, int i, int j) {
        if (key == 265) {
            this.direction = 1;
        }
        if (key == 32) {
            this.speedupActive = false;
        } else if (key == 341 || key == 345) {
            this.speedupModifiers.remove(key);
        }
        this.scrollSpeed = this.calculateScrollSpeed();
        return super.keyReleased(key, i, j);
    }

    public void onClose() {
        this.changeToChoiceScreen();
    }

    private void changeToChoiceScreen() {
        if (this.minecraft != null) {
            ChoiceScreen choiseScreen = new ChoiceScreen(this.onFinished);
            choiseScreen.init(this.minecraft, this.minecraft.getWindow().getGuiScaledWidth(), this.minecraft.getWindow().getGuiScaledHeight());
            this.minecraft.setScreen((Screen)choiseScreen);
        }
    }

    protected void init() {
        if (this.lines == null) {
            this.lines = Lists.newArrayList();
            this.centeredLines = new IntOpenHashSet();
            if (this.poem) {
                this.wrapCreditsIO(WIN_TXT, this::addPoemFile);
            }
            this.wrapCreditsIO(MOD_CREDITS, this::addCreditsFile);
            if (this.poem) {
                this.wrapCreditsIO(POSTCREDITS_LOCATION, this::addPoemFile);
            }
            this.totalScrollLength = this.lines.size() * 12;
        }
        this.musicTickCountDown = 80;
    }

    private void wrapCreditsIO(ResourceLocation location, CreditsReader reader) {
        if (this.minecraft == null) {
            return;
        }
        try (BufferedReader reader1 = this.minecraft.getResourceManager().openAsReader(location);){
            reader.read(reader1);
        }
        catch (Exception var8) {
            LOGGER.error("Couldn't load credits from file {}", (Object)location, (Object)var8);
        }
    }

    private void addPoemFile(Reader reader) throws IOException {
        BufferedReader bufferedreader = new BufferedReader(reader);
        RandomSource randomsource = RandomSource.create((long)8124371L);
        if (this.minecraft != null) {
            Object s;
            while ((s = bufferedreader.readLine()) != null) {
                int i;
                s = ((String)s).replaceAll("PLAYERNAME", this.minecraft.getUser().getName());
                while ((i = ((String)s).indexOf(OBFUSCATE_TOKEN)) != -1) {
                    String s1 = ((String)s).substring(0, i);
                    String s2 = ((String)s).substring(i + OBFUSCATE_TOKEN.length());
                    s = s1 + String.valueOf(ChatFormatting.WHITE) + String.valueOf(ChatFormatting.OBFUSCATED) + "XXXXXXXX".substring(0, randomsource.nextInt(4) + 3) + s2;
                }
                this.addPoemLines((String)s);
                this.addEmptyLine();
            }
            for (int j = 0; j < 8; ++j) {
                this.addEmptyLine();
            }
        }
    }

    private void addCreditsFile(Reader reader) {
        for (JsonElement jsonelement : GsonHelper.parseArray((Reader)reader)) {
            JsonObject jsonobject = jsonelement.getAsJsonObject();
            String s = jsonobject.get("section").getAsString();
            this.addCreditsLine(SECTION_HEADING, true);
            this.addCreditsLine((Component)Component.literal((String)s).withStyle(ChatFormatting.YELLOW), true);
            this.addCreditsLine(SECTION_HEADING, true);
            this.addEmptyLine();
            this.addEmptyLine();
            for (JsonElement jsonelement1 : jsonobject.getAsJsonArray("disciplines")) {
                JsonObject jsonobject1 = jsonelement1.getAsJsonObject();
                String s1 = jsonobject1.get("discipline").getAsString();
                if (StringUtils.isNotEmpty((CharSequence)s1)) {
                    this.addCreditsLine((Component)Component.literal((String)s1).withStyle(ChatFormatting.YELLOW), true);
                    this.addEmptyLine();
                    this.addEmptyLine();
                }
                for (JsonElement jsonelement2 : jsonobject1.getAsJsonArray("titles")) {
                    JsonObject jsonobject2 = jsonelement2.getAsJsonObject();
                    String s2 = jsonobject2.get("title").getAsString();
                    JsonArray jsonarray = jsonobject2.getAsJsonArray("names");
                    this.addCreditsLine((Component)Component.literal((String)s2).withStyle(ChatFormatting.GRAY), false);
                    for (JsonElement jsonelement3 : jsonarray) {
                        String s3 = jsonelement3.getAsString();
                        this.addCreditsLine((Component)Component.literal((String)"           ").append(s3).withStyle(ChatFormatting.WHITE), false);
                    }
                    this.addEmptyLine();
                    this.addEmptyLine();
                }
            }
        }
    }

    private void addEmptyLine() {
        this.lines.add(FormattedCharSequence.EMPTY);
    }

    private void addPoemLines(String p_181398_) {
        if (this.minecraft != null) {
            this.lines.addAll(this.minecraft.font.split((FormattedText)Component.literal((String)p_181398_), 256));
        }
    }

    private void addCreditsLine(Component component, boolean center) {
        if (center) {
            this.centeredLines.add(this.lines.size());
        }
        this.lines.add(component.getVisualOrderText());
    }

    public void render(@NotNull GuiGraphics graphics, int x, int y, float a) {
        this.scroll = Math.max(0.0f, this.scroll + a * this.scrollSpeed);
        super.render(graphics, x, y, a);
        int i = this.width / 2 - 128;
        int j = this.height + 50;
        float f = -this.scroll;
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, f, 0.0f);
        this.logoRenderer.renderLogo(graphics, this.width, 1.0f, j);
        int k = j + 100;
        for (int l = 0; l < this.lines.size(); ++l) {
            float f1;
            if (l == this.lines.size() - 1 && (f1 = (float)k + f - (float)(this.height / 2 - 6)) < 0.0f) {
                graphics.pose().translate(0.0f, -f1, 0.0f);
            }
            if ((float)k + f + 12.0f + 8.0f > 0.0f && (float)k + f < (float)this.height) {
                FormattedCharSequence formattedcharsequence = this.lines.get(l);
                if (this.centeredLines.contains(l)) {
                    graphics.drawCenteredString(this.font, formattedcharsequence, i + 128, k, 0xFFFFFF);
                } else {
                    graphics.drawString(this.font, formattedcharsequence, i, k, 0xFFFFFF);
                }
            }
            k += 12;
        }
        graphics.pose().popPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR);
        graphics.blit(VIGNETTE_LOCATION, 0, 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int x, int y, float a) {
        int i = this.width;
        float f = this.scroll * 0.5f;
        int j = 64;
        float f3 = (float)(this.totalScrollLength + this.height + this.height + 24) / this.unmodifiedScrollSpeed;
        float f1 = this.scroll / this.unmodifiedScrollSpeed;
        float f4 = (f3 - 20.0f - f1) * 0.005f;
        float f2 = f1 * 0.02f;
        if (f4 < f2) {
            f2 = f4;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 *= f2;
        f2 = f2 * 96.0f / 255.0f;
        graphics.setColor(f2, f2, f2, 1.0f);
        graphics.blit(MOD_BACKGROUND_LOCATION, 0, 0, 0, 0.0f, f, i, this.height, 64, 64);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @NotNull
    public Music getBackgroundMusic() {
        return ModMusics.ABYSS_THEME;
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    static interface CreditsReader {
        public void read(Reader var1) throws IOException;
    }
}

