/*
 * Decompiled with CFR 0.152.
 */
package wardentools.items;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import wardentools.items.ItemRegistry;
import wardentools.network.PacketHandler;
import wardentools.network.ParticulesSoundsEffects.ParticleContagionImplosion;
import wardentools.tags.ModTags;
import wardentools.worldgen.dimension.ModDimensions;
import wardentools.worldgen.portal.ModTeleporter;

public class AbyssDiverItem
extends Item {
    public AbyssDiverItem(Item.Properties prop) {
        super(prop);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos clickedPos = context.getClickedPos();
        BlockState clickedBlockState = level.getBlockState(clickedPos);
        if (clickedBlockState.is(ModTags.Blocks.ABYSS_TELEPORTABLE)) {
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            if (player.level() instanceof ServerLevel) {
                PacketHandler.sendToAllClient(new ParticleContagionImplosion(player.getPosition(0.1f).add(0.0, 1.0, 0.0)));
                AbyssDiverItem.teleportPlayer(player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean isValidRepairItem(@NotNull ItemStack toRepair, ItemStack repair) {
        return repair.getItem() == ItemRegistry.DEEP_FRAGMENT.get();
    }

    private static void teleportPlayer(Player player) {
        ServerLevel serverLevel = (ServerLevel)player.level();
        if (player instanceof ServerPlayer) {
            ServerLevel portalDimension;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MinecraftServer minecraftserver = serverLevel.getServer();
            ResourceKey resourcekey = ModDimensions.ABYSS_LEVEL_KEY;
            if (player.level().dimension() == ModDimensions.ABYSS_LEVEL_KEY) {
                resourcekey = Level.OVERWORLD;
            }
            if ((portalDimension = minecraftserver.getLevel(resourcekey)) != null && !player.isPassenger()) {
                player.changeDimension(ModTeleporter.diveSamePlace(portalDimension, serverPlayer));
            }
        }
    }
}

